/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.io.stream;

import com.hedera.pbj.runtime.io.DataAccessException;
import com.hedera.pbj.runtime.io.DataEncodingException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;

public class ReadableStreamingData
implements ReadableSequentialData,
Closeable {
    private final InputStream in;
    private long position = 0L;
    private long limit = Long.MAX_VALUE;
    private boolean eof = false;

    public ReadableStreamingData(@NonNull InputStream in) {
        this.in = Objects.requireNonNull(in);
    }

    public ReadableStreamingData(@NonNull Path file) throws IOException {
        if (!Files.isRegularFile(file, new LinkOption[0]) || !Files.isReadable(file)) {
            throw new IOException("Cannot read file: " + file);
        }
        this.in = Files.newInputStream(file, StandardOpenOption.READ);
        this.limit = Files.size(file);
    }

    public ReadableStreamingData(@NonNull byte[] bytes) {
        this.in = new ByteArrayInputStream(bytes);
        this.limit = bytes.length;
    }

    @Override
    public void close() {
        try {
            this.eof = true;
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public long capacity() {
        return Long.MAX_VALUE;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public void limit(long limit) {
        this.limit = Math.min(this.capacity(), Math.max(this.position, limit));
    }

    @Override
    public long remaining() {
        return this.eof ? 0L : this.limit - this.position;
    }

    @Override
    public boolean hasRemaining() {
        return !this.eof && this.position < this.limit;
    }

    @Override
    public byte readByte() {
        if (!this.hasRemaining()) {
            throw new BufferUnderflowException();
        }
        try {
            int result = this.in.read();
            if (result == -1) {
                this.eof = true;
                throw new EOFException();
            }
            ++this.position;
            return (byte)result;
        }
        catch (IOException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public long skip(long n) {
        long clamped = Math.min(n, this.limit);
        if (clamped <= 0L) {
            return 0L;
        }
        try {
            long numSkipped = this.in.skip(clamped);
            this.position += numSkipped;
            return numSkipped;
        }
        catch (IOException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public long readBytes(@NonNull byte[] dst, int offset, int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("Negative maxLength not allowed");
        }
        if (offset < 0 || maxLength > dst.length - offset) {
            throw new IndexOutOfBoundsException("Illegal read offset / maxLength");
        }
        int len = Math.min(dst.length - offset, maxLength);
        if (len == 0 || !this.hasRemaining()) {
            return 0L;
        }
        try {
            int bytesRead = this.in.readNBytes(dst, offset, len);
            this.position += (long)bytesRead;
            if (bytesRead < len) {
                this.eof = true;
            }
            return bytesRead;
        }
        catch (IOException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public long readBytes(@NonNull ByteBuffer dst) {
        if (!dst.hasArray()) {
            return ReadableSequentialData.super.readBytes(dst);
        }
        if (!this.hasRemaining()) {
            return 0L;
        }
        byte[] dstArr = dst.array();
        int dstArrOffset = dst.arrayOffset();
        int dstPos = dst.position();
        long len = Math.min(this.remaining(), (long)dst.remaining());
        try {
            int bytesRead = this.in.readNBytes(dstArr, dstPos + dstArrOffset, Math.toIntExact(len));
            this.position += (long)bytesRead;
            if ((long)bytesRead < len) {
                this.eof = true;
            }
            return bytesRead;
        }
        catch (IOException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public long readBytes(@NonNull BufferedData dst) {
        long len = Math.min(this.remaining(), dst.remaining());
        int bytesRead = dst.writeBytes(this.in, Math.toIntExact(len));
        this.position += (long)bytesRead;
        if ((long)bytesRead < len) {
            this.eof = true;
        }
        return bytesRead;
    }

    @Override
    public long readVarLong(boolean zigZag) {
        if (!this.hasRemaining()) {
            throw new BufferUnderflowException();
        }
        long value = 0L;
        try {
            int i;
            for (i = 0; i < 10; ++i) {
                int b = this.in.read();
                if (b < 0) {
                    this.eof = true;
                    throw new EOFException();
                }
                value |= (long)(b & 0x7F) << i * 7;
                if ((b & 0x80) != 0) continue;
                this.position += (long)(i + 1);
                return zigZag ? value >>> 1 ^ -(value & 1L) : value;
            }
            throw i == 10 ? new DataEncodingException("Malformed var int") : new BufferUnderflowException();
        }
        catch (IOException e) {
            throw new DataAccessException(e);
        }
    }
}

