/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;

public interface Codec<T> {
    @NonNull
    public T parse(@NonNull ReadableSequentialData var1) throws IOException;

    @NonNull
    public T parseStrict(@NonNull ReadableSequentialData var1) throws IOException;

    public void write(@NonNull T var1, @NonNull WritableSequentialData var2) throws IOException;

    public int measure(@NonNull ReadableSequentialData var1) throws IOException;

    public int measureRecord(T var1);

    public boolean fastEquals(@NonNull T var1, @NonNull ReadableSequentialData var2) throws IOException;

    default public Bytes toBytes(@NonNull T item) {
        byte[] bytes;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             WritableStreamingData writableStreamingData = new WritableStreamingData(byteArrayOutputStream);){
            this.write(item, writableStreamingData);
            bytes = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return Bytes.wrap(bytes);
    }
}

