/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime;

import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ProtoParserTools {
    public static final int TAG_FIELD_OFFSET = 3;
    public static final int TAG_WRITE_TYPE_MASK = 7;

    private ProtoParserTools() {
    }

    public static <T> List<T> addToList(List<T> list, T newItem) {
        if (list == Collections.EMPTY_LIST) {
            list = new ArrayList<T>();
        }
        list.add(newItem);
        return list;
    }

    public static int readInt32(ReadableSequentialData input) throws IOException {
        return input.readVarInt(false);
    }

    public static long readInt64(ReadableSequentialData input) throws IOException {
        return input.readVarLong(false);
    }

    public static int readUint32(ReadableSequentialData input) throws IOException {
        return input.readVarInt(false);
    }

    public static long readUint64(ReadableSequentialData input) throws IOException {
        return input.readVarLong(false);
    }

    public static boolean readBool(ReadableSequentialData input) throws IOException {
        int i = input.readVarInt(false);
        if (i != 1 && i != 0) {
            throw new IOException("Bad protobuf encoding. Boolean was not 0 or 1");
        }
        return i == 1;
    }

    public static int readEnum(ReadableSequentialData input) throws IOException {
        return input.readVarInt(false);
    }

    public static int readSignedInt32(ReadableSequentialData input) throws IOException {
        return input.readVarInt(true);
    }

    public static long readSignedInt64(ReadableSequentialData input) throws IOException {
        return input.readVarLong(true);
    }

    public static int readSignedFixed32(ReadableSequentialData input) throws IOException {
        return input.readInt(ByteOrder.LITTLE_ENDIAN);
    }

    public static int readFixed32(ReadableSequentialData input) throws IOException {
        return input.readInt(ByteOrder.LITTLE_ENDIAN);
    }

    public static float readFloat(ReadableSequentialData input) throws IOException {
        return input.readFloat(ByteOrder.LITTLE_ENDIAN);
    }

    public static long readSignedFixed64(ReadableSequentialData input) throws IOException {
        return input.readLong(ByteOrder.LITTLE_ENDIAN);
    }

    public static long readFixed64(ReadableSequentialData input) throws IOException {
        return input.readLong(ByteOrder.LITTLE_ENDIAN);
    }

    public static double readDouble(ReadableSequentialData input) throws IOException {
        return input.readDouble(ByteOrder.LITTLE_ENDIAN);
    }

    public static String readString(ReadableSequentialData input) throws IOException {
        int length = input.readVarInt(false);
        byte[] bytes = new byte[length];
        input.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static Bytes readBytes(ReadableSequentialData input) throws IOException {
        int length = input.readVarInt(false);
        return input.readBytes(length);
    }

    public static void skipField(ReadableSequentialData input, ProtoConstants wireType) throws IOException {
        switch (wireType) {
            case WIRE_TYPE_FIXED_64_BIT: {
                input.skip(8L);
                break;
            }
            case WIRE_TYPE_FIXED_32_BIT: {
                input.skip(4L);
                break;
            }
            case WIRE_TYPE_VARINT_OR_ZIGZAG: {
                input.readVarLong(false);
                break;
            }
            case WIRE_TYPE_DELIMITED: {
                int length = input.readVarInt(false);
                input.skip(length);
                break;
            }
            case WIRE_TYPE_GROUP_START: {
                throw new IOException("Wire type 'Group Start' is unsupported");
            }
            case WIRE_TYPE_GROUP_END: {
                throw new IOException("Wire type 'Group End' is unsupported");
            }
            default: {
                throw new IOException("Unhandled wire type while trying to skip a field " + wireType);
            }
        }
    }
}

