/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime;

import com.hedera.pbj.runtime.MalformedProtobufException;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import java.io.IOException;

public class Utf8Tools {
    static int encodedLength(CharSequence sequence) throws IOException {
        int i;
        int utf16Length;
        int utf8Length = utf16Length = sequence.length();
        for (i = 0; i < utf16Length && sequence.charAt(i) < '\u0080'; ++i) {
        }
        while (i < utf16Length) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += Utf8Tools.encodedLengthGeneral(sequence, i);
                break;
            }
            ++i;
        }
        if (utf8Length < utf16Length) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return utf8Length;
    }

    private static int encodedLengthGeneral(CharSequence sequence, int start) throws IOException {
        int utf16Length = sequence.length();
        int utf8Length = 0;
        for (int i = start; i < utf16Length; ++i) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
                continue;
            }
            utf8Length += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int cp = Character.codePointAt(sequence, i);
            if (cp < 65536) {
                throw new MalformedProtobufException("Unpaired surrogate at index " + i + " of " + utf16Length);
            }
            ++i;
        }
        return utf8Length;
    }

    static void encodeUtf8(CharSequence in, WritableSequentialData out) throws IOException {
        int inLength = in.length();
        for (int inIx = 0; inIx < inLength; ++inIx) {
            char low;
            char c = in.charAt(inIx);
            if (c < '\u0080') {
                out.writeByte((byte)c);
                continue;
            }
            if (c < '\u0800') {
                out.writeByte((byte)(0xC0 | c >>> 6));
                out.writeByte((byte)(0x80 | 0x3F & c));
                continue;
            }
            if (c < '\ud800' || '\udfff' < c) {
                out.writeByte((byte)(0xE0 | c >>> 12));
                out.writeByte((byte)(0x80 | 0x3F & c >>> 6));
                out.writeByte((byte)(0x80 | 0x3F & c));
                continue;
            }
            if (inIx + 1 == inLength || !Character.isSurrogatePair(c, low = in.charAt(++inIx))) {
                throw new MalformedProtobufException("Unpaired surrogate at index " + inIx + " of " + inLength);
            }
            int codePoint = Character.toCodePoint(c, low);
            out.writeByte((byte)(0xF0 | codePoint >>> 18));
            out.writeByte((byte)(0x80 | 0x3F & codePoint >>> 12));
            out.writeByte((byte)(0x80 | 0x3F & codePoint >>> 6));
            out.writeByte((byte)(0x80 | 0x3F & codePoint));
        }
    }
}

