/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.io;

import com.hedera.pbj.runtime.io.DataEncodingException;
import com.hedera.pbj.runtime.io.SequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public interface ReadableSequentialData
extends SequentialData {
    public byte readByte();

    default public int readUnsignedByte() {
        return Byte.toUnsignedInt(this.readByte());
    }

    default public long readBytes(@NonNull byte[] dst) {
        return this.readBytes(dst, 0, dst.length);
    }

    default public long readBytes(@NonNull byte[] dst, int offset, int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("Negative maxLength not allowed");
        }
        long length = Math.min((long)maxLength, this.remaining());
        long maxIndex = (long)offset + length;
        long bytesRead = 0L;
        int i = offset;
        while ((long)i < maxIndex) {
            if (!this.hasRemaining()) {
                return (long)i - (long)offset;
            }
            try {
                dst[i] = this.readByte();
                ++bytesRead;
            }
            catch (EOFException e) {
                return bytesRead;
            }
            ++i;
        }
        return length;
    }

    default public long readBytes(@NonNull ByteBuffer dst) {
        int len = dst.remaining();
        for (int i = 0; i < len; ++i) {
            if (!this.hasRemaining()) {
                return i;
            }
            dst.put(this.readByte());
        }
        return len;
    }

    default public long readBytes(@NonNull BufferedData dst) {
        long len = dst.remaining();
        int i = 0;
        while ((long)i < len) {
            if (!this.hasRemaining()) {
                return i;
            }
            dst.writeByte(this.readByte());
            ++i;
        }
        return len;
    }

    @NonNull
    default public Bytes readBytes(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Negative length not allowed");
        }
        if (this.remaining() < (long)length) {
            throw new BufferUnderflowException();
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return Bytes.wrap(bytes);
    }

    @NonNull
    default public ReadableSequentialData view(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length cannot be negative");
        }
        byte[] bytes = new byte[length];
        long numReadBytes = this.readBytes(bytes);
        if (numReadBytes != (long)length) {
            throw new BufferUnderflowException();
        }
        return Bytes.wrap(bytes).toReadableSequentialData();
    }

    default public int readInt() {
        if (this.remaining() < 4L) {
            throw new BufferUnderflowException();
        }
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        byte b3 = this.readByte();
        byte b4 = this.readByte();
        return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    default public int readInt(@NonNull ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            if (this.remaining() < 4L) {
                throw new BufferUnderflowException();
            }
            byte b4 = this.readByte();
            byte b3 = this.readByte();
            byte b2 = this.readByte();
            byte b1 = this.readByte();
            return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
        }
        return this.readInt();
    }

    default public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    default public long readUnsignedInt(@NonNull ByteOrder byteOrder) {
        return (long)this.readInt(byteOrder) & 0xFFFFFFFFL;
    }

    default public long readLong() {
        if (this.remaining() < 8L) {
            throw new BufferUnderflowException();
        }
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        byte b3 = this.readByte();
        byte b4 = this.readByte();
        byte b5 = this.readByte();
        byte b6 = this.readByte();
        byte b7 = this.readByte();
        byte b8 = this.readByte();
        return ((long)b1 << 56) + ((long)(b2 & 0xFF) << 48) + ((long)(b3 & 0xFF) << 40) + ((long)(b4 & 0xFF) << 32) + ((long)(b5 & 0xFF) << 24) + (long)((b6 & 0xFF) << 16) + (long)((b7 & 0xFF) << 8) + (long)(b8 & 0xFF);
    }

    default public long readLong(@NonNull ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            if (this.remaining() < 8L) {
                throw new BufferUnderflowException();
            }
            byte b8 = this.readByte();
            byte b7 = this.readByte();
            byte b6 = this.readByte();
            byte b5 = this.readByte();
            byte b4 = this.readByte();
            byte b3 = this.readByte();
            byte b2 = this.readByte();
            byte b1 = this.readByte();
            return ((long)b1 << 56) + ((long)(b2 & 0xFF) << 48) + ((long)(b3 & 0xFF) << 40) + ((long)(b4 & 0xFF) << 32) + ((long)(b5 & 0xFF) << 24) + (long)((b6 & 0xFF) << 16) + (long)((b7 & 0xFF) << 8) + (long)(b8 & 0xFF);
        }
        return this.readLong();
    }

    default public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    default public float readFloat(@NonNull ByteOrder byteOrder) {
        return Float.intBitsToFloat(this.readInt(byteOrder));
    }

    default public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    default public double readDouble(@NonNull ByteOrder byteOrder) {
        return Double.longBitsToDouble(this.readLong(byteOrder));
    }

    default public int readVarInt(boolean zigZag) {
        long pos = this.position();
        long limit = this.limit();
        if (limit == pos) {
            return (int)this.readVarIntLongSlow(zigZag);
        }
        if (limit - pos < 10L) {
            return (int)this.readVarIntLongSlow(zigZag);
        }
        int x = this.readByte();
        if (x >= 0) {
            return zigZag ? x >>> 1 ^ -(x & 1) : x;
        }
        if ((x ^= this.readByte() << 7) < 0) {
            x ^= 0xFFFFFF80;
        } else if ((x ^= this.readByte() << 14) >= 0) {
            x ^= 0x3F80;
        } else if ((x ^= this.readByte() << 21) < 0) {
            x ^= 0xFFE03F80;
        } else {
            byte y = this.readByte();
            x ^= y << 28;
            x ^= 0xFE03F80;
            if (y < 0 && this.readByte() < 0 && this.readByte() < 0 && this.readByte() < 0 && this.readByte() < 0 && this.readByte() < 0) {
                return (int)this.readVarIntLongSlow(zigZag);
            }
        }
        return zigZag ? x >>> 1 ^ -(x & 1) : x;
    }

    default public long readVarLong(boolean zigZag) {
        long x;
        long pos = this.position();
        long limit = this.limit();
        if (limit == pos) {
            return this.readVarIntLongSlow(zigZag);
        }
        if (limit - pos < 10L) {
            return this.readVarIntLongSlow(zigZag);
        }
        int y = this.readByte();
        if (y >= 0) {
            return zigZag ? (long)(y >>> 1 ^ -(y & 1)) : (long)y;
        }
        if ((y ^= this.readByte() << 7) < 0) {
            x = y ^ 0xFFFFFF80;
        } else if ((y ^= this.readByte() << 14) >= 0) {
            x = y ^ 0x3F80;
        } else if ((y ^= this.readByte() << 21) < 0) {
            x = y ^ 0xFFE03F80;
        } else {
            x = (long)y ^ (long)this.readByte() << 28;
            if (x >= 0L) {
                x ^= 0xFE03F80L;
            } else if ((x ^= (long)this.readByte() << 35) < 0L) {
                x ^= 0xFFFFFFF80FE03F80L;
            } else if ((x ^= (long)this.readByte() << 42) >= 0L) {
                x ^= 0x3F80FE03F80L;
            } else if ((x ^= (long)this.readByte() << 49) < 0L) {
                x ^= 0xFFFE03F80FE03F80L;
            } else {
                x ^= (long)this.readByte() << 56;
                if ((x ^= 0xFE03F80FE03F80L) < 0L && (long)this.readByte() < 0L) {
                    throw new DataEncodingException("Malformed VarLong");
                }
            }
        }
        return zigZag ? x >>> 1 ^ -(x & 1L) : x;
    }

    default public long readVarIntLongSlow(boolean zigZag) {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return zigZag ? result >>> 1 ^ -(result & 1L) : result;
        }
        throw new DataEncodingException("Malformed Varlong");
    }

    default public InputStream asInputStream() {
        return new ReadableSequentialDataInputStream(this);
    }

    public static class ReadableSequentialDataInputStream
    extends InputStream {
        final ReadableSequentialData sequentialData;

        public ReadableSequentialDataInputStream(@NonNull ReadableSequentialData sequentialData) {
            this.sequentialData = sequentialData;
        }

        @Override
        public int read() {
            try {
                return this.sequentialData.readByte();
            }
            catch (BufferUnderflowException e) {
                return -1;
            }
        }
    }
}

