/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.io.buffer;

import com.hedera.pbj.runtime.io.DataAccessException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

public class BufferedData
implements BufferedSequentialData,
ReadableSequentialData,
WritableSequentialData,
RandomAccessData {
    public static final BufferedData EMPTY_BUFFER = BufferedData.wrap(ByteBuffer.allocate(0));
    private final ByteBuffer buffer;
    private final boolean direct;

    private BufferedData(@NonNull ByteBuffer buffer) {
        this.buffer = buffer;
        this.direct = buffer.isDirect();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
    }

    @NonNull
    public static BufferedData wrap(@NonNull ByteBuffer buffer) {
        return new BufferedData(buffer);
    }

    @NonNull
    public static BufferedData wrap(@NonNull byte[] array) {
        return new BufferedData(ByteBuffer.wrap(array));
    }

    @NonNull
    public static BufferedData wrap(@NonNull byte[] array, int offset, int len) {
        return new BufferedData(ByteBuffer.wrap(array, offset, len));
    }

    @NonNull
    public static BufferedData allocate(int size) {
        return new BufferedData(ByteBuffer.allocate(size));
    }

    @NonNull
    public static BufferedData allocateOffHeap(int size) {
        return new BufferedData(ByteBuffer.allocateDirect(size));
    }

    @NonNull
    public InputStream toInputStream() {
        return new InputStream(){
            private long pos = 0L;
            private final long length = BufferedData.this.capacity();

            @Override
            public int read() throws IOException {
                if (this.length - this.pos <= 0L) {
                    return -1;
                }
                try {
                    return BufferedData.this.getUnsignedByte(this.pos++);
                }
                catch (DataAccessException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public int read(@NonNull byte[] b, int off, int len) throws IOException {
                long remaining = this.length - this.pos;
                if (remaining <= 0L) {
                    return -1;
                }
                try {
                    int toRead = (int)Math.min((long)len, remaining);
                    BufferedData.this.getBytes(this.pos, b, off, toRead);
                    this.pos += (long)toRead;
                    return toRead;
                }
                catch (DataAccessException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BufferedData[");
        for (int i = 0; i < this.buffer.limit(); ++i) {
            int v = this.buffer.get(i) & 0xFF;
            sb.append(v);
            if (i >= this.buffer.limit() - 1) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferedData that = (BufferedData)o;
        if (this.capacity() != that.capacity()) {
            return false;
        }
        if (this.limit() != that.limit()) {
            return false;
        }
        int i = 0;
        while ((long)i < this.limit()) {
            if (this.buffer.get(i) != that.buffer.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    @Override
    public long capacity() {
        return this.buffer.capacity();
    }

    @Override
    public long position() {
        return this.buffer.position();
    }

    @Override
    public long limit() {
        return this.buffer.limit();
    }

    @Override
    public void limit(long limit) {
        long lim = Math.min(this.capacity(), Math.max(limit, this.position()));
        this.buffer.limit((int)lim);
    }

    @Override
    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    @Override
    public long remaining() {
        return this.buffer.remaining();
    }

    @Override
    public long skip(long count) {
        if ((count = Math.min(count, (long)this.buffer.remaining())) <= 0L) {
            return 0L;
        }
        this.buffer.position(this.buffer.position() + (int)count);
        return count;
    }

    @Override
    public void position(long position) {
        this.buffer.position(Math.toIntExact(position));
    }

    @Override
    public void flip() {
        this.buffer.flip();
    }

    @Override
    public void reset() {
        this.buffer.clear();
    }

    @Override
    public void resetPosition() {
        this.buffer.position(0);
    }

    @Override
    public long length() {
        return this.buffer.limit();
    }

    @Override
    public byte getByte(long offset) {
        this.checkUnderflow(offset, 1);
        return this.buffer.get(Math.toIntExact(offset));
    }

    @Override
    public long getBytes(long offset, @NonNull byte[] dst, int dstOffset, int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("Negative maxLength not allowed");
        }
        long len = Math.min((long)maxLength, this.length() - offset);
        this.buffer.get(Math.toIntExact(offset), dst, dstOffset, Math.toIntExact(len));
        return len;
    }

    @Override
    public long getBytes(long offset, @NonNull ByteBuffer dst) {
        long len = Math.min((long)dst.remaining(), this.length() - offset);
        dst.put(dst.position(), this.buffer, Math.toIntExact(offset), Math.toIntExact(len));
        return len;
    }

    @Override
    public long getBytes(long offset, @NonNull BufferedData dst) {
        long len = Math.min(dst.remaining(), this.length() - offset);
        dst.buffer.put(dst.buffer.position(), this.buffer, Math.toIntExact(offset), Math.toIntExact(len));
        return len;
    }

    @Override
    @NonNull
    public Bytes getBytes(long offset, long length) {
        int len = Math.toIntExact(length);
        if (len < 0) {
            throw new IllegalArgumentException("Length cannot be negative");
        }
        byte[] copy = new byte[len];
        this.buffer.get(Math.toIntExact(offset), copy, 0, len);
        return Bytes.wrap(copy);
    }

    @Override
    @NonNull
    public BufferedData slice(long offset, long length) {
        return new BufferedData(this.buffer.slice(Math.toIntExact(offset), Math.toIntExact(length)));
    }

    @Override
    public int getInt(long offset) {
        this.checkUnderflow(offset, 4);
        return this.buffer.getInt(Math.toIntExact(offset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(long offset, @NonNull ByteOrder byteOrder) {
        this.checkUnderflow(offset, 4);
        ByteOrder order = this.buffer.order();
        try {
            this.buffer.order(byteOrder);
            int n = this.buffer.getInt(Math.toIntExact(offset));
            return n;
        }
        finally {
            this.buffer.order(order);
        }
    }

    @Override
    public long getLong(long offset) {
        this.checkUnderflow(offset, 8);
        return this.buffer.getLong(Math.toIntExact(offset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(long offset, @NonNull ByteOrder byteOrder) {
        this.checkUnderflow(offset, 8);
        ByteOrder order = this.buffer.order();
        try {
            this.buffer.order(byteOrder);
            long l = this.buffer.getLong(Math.toIntExact(offset));
            return l;
        }
        finally {
            this.buffer.order(order);
        }
    }

    @Override
    public float getFloat(long offset) {
        this.checkUnderflow(offset, 4);
        return this.buffer.getFloat(Math.toIntExact(offset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(long offset, @NonNull ByteOrder byteOrder) {
        this.checkUnderflow(offset, 4);
        ByteOrder order = this.buffer.order();
        try {
            this.buffer.order(byteOrder);
            float f = this.buffer.getFloat(Math.toIntExact(offset));
            return f;
        }
        finally {
            this.buffer.order(order);
        }
    }

    @Override
    public double getDouble(long offset) {
        this.checkUnderflow(offset, 8);
        return this.buffer.getDouble(Math.toIntExact(offset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(long offset, @NonNull ByteOrder byteOrder) {
        this.checkUnderflow(offset, 8);
        ByteOrder order = this.buffer.order();
        try {
            this.buffer.order(byteOrder);
            double d = this.buffer.getDouble(Math.toIntExact(offset));
            return d;
        }
        finally {
            this.buffer.order(order);
        }
    }

    private void checkUnderflow(long offset, int remainingBytes) {
        if (this.length() - offset - (long)remainingBytes < 0L) {
            throw new BufferUnderflowException();
        }
    }

    @Override
    public byte readByte() {
        return this.buffer.get();
    }

    @Override
    public int readUnsignedByte() {
        return Byte.toUnsignedInt(this.buffer.get());
    }

    @Override
    public long readBytes(@NonNull byte[] dst, int offset, int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("Negative maxLength not allowed");
        }
        int len = Math.toIntExact(Math.min((long)maxLength, this.remaining()));
        if (len == 0) {
            return 0L;
        }
        this.buffer.get(dst, offset, len);
        return len;
    }

    @Override
    public long readBytes(@NonNull ByteBuffer dst) {
        int len = Math.toIntExact(Math.min((long)dst.remaining(), this.remaining()));
        if (len == 0) {
            return 0L;
        }
        int dstPos = dst.position();
        dst.put(dstPos, this.buffer, Math.toIntExact(this.position()), len);
        dst.position(dstPos + len);
        this.position(this.position() + (long)len);
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long readBytes(@NonNull BufferedData dst) {
        int len = Math.toIntExact(Math.min(dst.remaining(), this.remaining()));
        if (len == 0) {
            return 0L;
        }
        int lim = this.buffer.limit();
        this.buffer.limit(this.buffer.position() + len);
        try {
            dst.buffer.put(this.buffer);
            long l = len;
            return l;
        }
        finally {
            this.buffer.limit(lim);
        }
    }

    @Override
    @NonNull
    public Bytes readBytes(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length cannot be negative");
        }
        if (length == 0) {
            return Bytes.EMPTY;
        }
        if (this.remaining() < (long)length) {
            throw new BufferUnderflowException();
        }
        Bytes bytes = this.getBytes(this.position(), length);
        this.buffer.position(this.buffer.position() + length);
        return bytes;
    }

    @Override
    @NonNull
    public BufferedData view(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length cannot be negative");
        }
        if ((long)length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int pos = Math.toIntExact(this.position());
        BufferedData buf = new BufferedData(this.buffer.slice(pos, length));
        this.position((long)pos + (long)length);
        return buf;
    }

    @Override
    public int readInt() {
        return this.buffer.getInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readInt(@NonNull ByteOrder byteOrder) {
        ByteOrder order = this.buffer.order();
        try {
            this.buffer.order(byteOrder);
            int n = this.buffer.getInt();
            return n;
        }
        finally {
            this.buffer.order(order);
        }
    }

    @Override
    public long readUnsignedInt() {
        return Integer.toUnsignedLong(this.buffer.getInt());
    }

    @Override
    public long readLong() {
        return this.buffer.getLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long readLong(@NonNull ByteOrder byteOrder) {
        ByteOrder order = this.buffer.order();
        try {
            this.buffer.order(byteOrder);
            long l = this.buffer.getLong();
            return l;
        }
        finally {
            this.buffer.order(order);
        }
    }

    @Override
    public float readFloat() {
        return this.buffer.getFloat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float readFloat(@NonNull ByteOrder byteOrder) {
        ByteOrder order = this.buffer.order();
        try {
            this.buffer.order(byteOrder);
            float f = this.buffer.getFloat();
            return f;
        }
        finally {
            this.buffer.order(order);
        }
    }

    @Override
    public double readDouble() {
        return this.buffer.getDouble();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double readDouble(@NonNull ByteOrder byteOrder) {
        ByteOrder order = this.buffer.order();
        try {
            this.buffer.order(byteOrder);
            double d = this.buffer.getDouble();
            return d;
        }
        finally {
            this.buffer.order(order);
        }
    }

    @Override
    public int readVarInt(boolean zigZag) {
        int x;
        if (this.direct) {
            return ReadableSequentialData.super.readVarInt(zigZag);
        }
        int arrayOffset = this.buffer.arrayOffset();
        int tempPos = this.buffer.position() + arrayOffset;
        byte[] buff = this.buffer.array();
        int lastPos = this.buffer.limit() + arrayOffset;
        if (lastPos == tempPos) {
            throw new BufferUnderflowException();
        }
        if ((x = buff[tempPos++]) >= 0) {
            this.buffer.position(tempPos - arrayOffset);
            return zigZag ? x >>> 1 ^ -(x & 1) : x;
        }
        if (lastPos - tempPos < 9) {
            return (int)this.readVarIntLongSlow(zigZag);
        }
        if ((x ^= buff[tempPos++] << 7) < 0) {
            x ^= 0xFFFFFF80;
        } else if ((x ^= buff[tempPos++] << 14) >= 0) {
            x ^= 0x3F80;
        } else if ((x ^= buff[tempPos++] << 21) < 0) {
            x ^= 0xFFE03F80;
        } else {
            byte y = buff[tempPos++];
            x ^= y << 28;
            x ^= 0xFE03F80;
            if (y < 0 && buff[tempPos++] < 0 && buff[tempPos++] < 0 && buff[tempPos++] < 0 && buff[tempPos++] < 0 && buff[tempPos++] < 0) {
                return (int)this.readVarIntLongSlow(zigZag);
            }
        }
        this.buffer.position(tempPos - arrayOffset);
        return zigZag ? x >>> 1 ^ -(x & 1) : x;
    }

    @Override
    public long readVarLong(boolean zigZag) {
        long x;
        int y;
        if (this.direct) {
            return ReadableSequentialData.super.readVarLong(zigZag);
        }
        int arrayOffset = this.buffer.arrayOffset();
        int tempPos = this.buffer.position() + arrayOffset;
        byte[] buff = this.buffer.array();
        int lastPos = this.buffer.limit() + arrayOffset;
        if (lastPos == tempPos) {
            throw new BufferUnderflowException();
        }
        if ((y = buff[tempPos++]) >= 0) {
            this.buffer.position(tempPos - arrayOffset);
            return zigZag ? (long)(y >>> 1 ^ -(y & 1)) : (long)y;
        }
        if (lastPos - tempPos < 9) {
            return this.readVarIntLongSlow(zigZag);
        }
        if ((y ^= buff[tempPos++] << 7) < 0) {
            x = y ^ 0xFFFFFF80;
        } else if ((y ^= buff[tempPos++] << 14) >= 0) {
            x = y ^ 0x3F80;
        } else if ((y ^= buff[tempPos++] << 21) < 0) {
            x = y ^ 0xFFE03F80;
        } else if ((x = (long)y ^ (long)buff[tempPos++] << 28) >= 0L) {
            x ^= 0xFE03F80L;
        } else if ((x ^= (long)buff[tempPos++] << 35) < 0L) {
            x ^= 0xFFFFFFF80FE03F80L;
        } else if ((x ^= (long)buff[tempPos++] << 42) >= 0L) {
            x ^= 0x3F80FE03F80L;
        } else if ((x ^= (long)buff[tempPos++] << 49) < 0L) {
            x ^= 0xFFFE03F80FE03F80L;
        } else {
            x ^= (long)buff[tempPos++] << 56;
            if ((x ^= 0xFE03F80FE03F80L) < 0L && (long)buff[tempPos++] < 0L) {
                return this.readVarIntLongSlow(zigZag);
            }
        }
        this.buffer.position(tempPos - arrayOffset);
        return zigZag ? x >>> 1 ^ -(x & 1L) : x;
    }

    @Override
    public void writeByte(byte b) {
        this.buffer.put(b);
    }

    @Override
    public void writeUnsignedByte(int b) {
        this.buffer.put((byte)b);
    }

    @Override
    public void writeBytes(@NonNull byte[] src) {
        this.buffer.put(src);
    }

    @Override
    public void writeBytes(@NonNull byte[] src, int offset, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        this.buffer.put(src, offset, length);
    }

    @Override
    public void writeBytes(@NonNull ByteBuffer src) {
        if (this.limit() - this.position() < (long)src.remaining()) {
            throw new BufferOverflowException();
        }
        this.buffer.put(src);
    }

    @Override
    public void writeBytes(@NonNull BufferedData src) {
        if (this.limit() - this.position() < src.remaining()) {
            throw new BufferOverflowException();
        }
        this.buffer.put(src.buffer);
    }

    @Override
    public void writeBytes(@NonNull RandomAccessData src) {
        if (src instanceof Bytes) {
            Bytes buf = (Bytes)src;
            if (this.limit() - this.position() < src.length()) {
                throw new BufferOverflowException();
            }
            buf.writeTo(this.buffer);
        } else {
            WritableSequentialData.super.writeBytes(src);
        }
    }

    @Override
    public int writeBytes(@NonNull InputStream src, int maxLength) {
        if (!this.buffer.hasArray()) {
            return WritableSequentialData.super.writeBytes(src, maxLength);
        }
        Objects.requireNonNull(src);
        if (maxLength < 0) {
            throw new IllegalArgumentException("The length must be >= 0");
        }
        if (maxLength == 0) {
            return 0;
        }
        byte[] array = this.buffer.array();
        long numBytesToRead = Math.min((long)maxLength, this.remaining());
        if (numBytesToRead == 0L) {
            return 0;
        }
        try {
            int totalBytesRead = 0;
            while ((long)totalBytesRead < numBytesToRead) {
                int numBytesRead = src.read(array, this.buffer.position() + this.buffer.arrayOffset(), (int)numBytesToRead - totalBytesRead);
                if (numBytesRead == -1) {
                    return totalBytesRead;
                }
                this.buffer.position(this.buffer.position() + numBytesRead);
                totalBytesRead += numBytesRead;
            }
            return totalBytesRead;
        }
        catch (IOException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public void writeInt(int value) {
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.buffer.putInt(value);
    }

    @Override
    public void writeInt(int value, @NonNull ByteOrder byteOrder) {
        this.buffer.order(byteOrder);
        this.buffer.putInt(value);
    }

    @Override
    public void writeUnsignedInt(long value) {
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.buffer.putInt((int)value);
    }

    @Override
    public void writeUnsignedInt(long value, @NonNull ByteOrder byteOrder) {
        this.buffer.order(byteOrder);
        this.buffer.putInt((int)value);
    }

    @Override
    public void writeLong(long value) {
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.buffer.putLong(value);
    }

    @Override
    public void writeLong(long value, @NonNull ByteOrder byteOrder) {
        this.buffer.order(byteOrder);
        this.buffer.putLong(value);
    }

    @Override
    public void writeFloat(float value) {
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.buffer.putFloat(value);
    }

    @Override
    public void writeFloat(float value, @NonNull ByteOrder byteOrder) {
        this.buffer.order(byteOrder);
        this.buffer.putFloat(value);
    }

    @Override
    public void writeDouble(double value) {
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.buffer.putDouble(value);
    }

    @Override
    public void writeDouble(double value, @NonNull ByteOrder byteOrder) {
        this.buffer.order(byteOrder);
        this.buffer.putDouble(value);
    }

    @Override
    public void writeVarInt(int value, boolean zigZag) {
        long longValue = value;
        if (zigZag) {
            longValue = longValue << 1 ^ longValue >> 63;
        }
        while (true) {
            if ((longValue & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.buffer.put((byte)(longValue & 0x7FL | 0x80L));
            longValue >>>= 7;
        }
        this.buffer.put((byte)longValue);
    }

    @Override
    public void writeVarLong(long value, boolean zigZag) {
        if (zigZag) {
            value = value << 1 ^ value >> 63;
        }
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.buffer.put((byte)((int)value & 0x7F | 0x80));
            value >>>= 7;
        }
        this.buffer.put((byte)value);
    }
}

