/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.io.buffer;

import com.hedera.pbj.runtime.io.DataAccessException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.buffer.RandomAccessSequenceAdapter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Comparator;
import java.util.HexFormat;
import java.util.Objects;

public final class Bytes
implements RandomAccessData {
    public static final Bytes EMPTY = new Bytes(new byte[0]);
    public static final Comparator<Bytes> SORT_BY_LENGTH = (o1, o2) -> Comparator.comparingLong(Bytes::length).compare((Bytes)o1, (Bytes)o2);
    public static final Comparator<Bytes> SORT_BY_SIGNED_VALUE = Bytes.valueSorter(Byte::compare);
    public static final Comparator<Bytes> SORT_BY_UNSIGNED_VALUE = Bytes.valueSorter(Byte::compareUnsigned);
    private final byte[] buffer;
    private final int start;
    private final int length;

    private Bytes(@NonNull byte[] data) {
        this(data, 0, data.length);
    }

    private Bytes(@NonNull byte[] data, int offset, int length) {
        this.buffer = Objects.requireNonNull(data);
        this.start = offset;
        this.length = length;
        if (offset < 0 || offset > data.length) {
            throw new IndexOutOfBoundsException("Offset " + offset + " is out of bounds for buffer of length " + data.length);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length " + length + " is negative");
        }
        if (offset + length > data.length) {
            throw new IllegalArgumentException("Length " + length + " is too large buffer of length " + data.length + " starting at offset " + offset);
        }
    }

    @NonNull
    public static Bytes wrap(@NonNull byte[] byteArray) {
        return new Bytes(byteArray);
    }

    @NonNull
    public static Bytes wrap(@NonNull byte[] byteArray, int offset, int length) {
        return new Bytes(byteArray, offset, length);
    }

    @NonNull
    public static Bytes wrap(@NonNull String string) {
        return new Bytes(string.getBytes(StandardCharsets.UTF_8));
    }

    @NonNull
    public static Bytes fromBase64(@NonNull String string) {
        return new Bytes(Base64.getDecoder().decode(string));
    }

    @NonNull
    public static Bytes fromHex(@NonNull String string) {
        return new Bytes(HexFormat.of().parseHex(string.toLowerCase()));
    }

    @NonNull
    public Bytes replicate() {
        int newLength = this.length - this.start;
        byte[] bytes = new byte[newLength];
        System.arraycopy(this.buffer, this.start, bytes, 0, newLength);
        return new Bytes(bytes, 0, newLength);
    }

    public void writeTo(@NonNull ByteBuffer dstBuffer) {
        dstBuffer.put(this.buffer, this.start, this.length);
    }

    public void writeTo(@NonNull ByteBuffer dstBuffer, int offset, int length) {
        dstBuffer.put(this.buffer, offset, length);
        dstBuffer.position(dstBuffer.position() + length);
    }

    public void writeTo(@NonNull OutputStream outStream) {
        try {
            outStream.write(this.buffer, this.start, this.length);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void writeTo(@NonNull OutputStream outStream, int offset, int length) {
        try {
            outStream.write(this.buffer, offset, length);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void writeTo(@NonNull WritableSequentialData wsd) {
        wsd.writeBytes(this.buffer, this.start, this.length);
    }

    public void writeTo(@NonNull WritableSequentialData wsd, int offset, int length) {
        wsd.writeBytes(this.buffer, offset, length);
    }

    public void writeTo(@NonNull MessageDigest digest) {
        digest.update(this.buffer, this.start, this.length);
    }

    public void writeTo(@NonNull MessageDigest digest, int offset, int length) {
        digest.update(this.buffer, offset, length);
    }

    @NonNull
    public ReadableSequentialData toReadableSequentialData() {
        return new RandomAccessSequenceAdapter(this);
    }

    @NonNull
    public InputStream toInputStream() {
        return new InputStream(){
            private long pos = 0L;

            @Override
            public int read() throws IOException {
                if ((long)Bytes.this.length - this.pos <= 0L) {
                    return -1;
                }
                try {
                    return Bytes.this.getUnsignedByte(this.pos++);
                }
                catch (DataAccessException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    @NonNull
    public String toString() {
        return HexFormat.of().formatHex(this.buffer, this.start, this.start + this.length);
    }

    public String toBase64() {
        if (this.start == 0 && this.buffer.length == this.length) {
            return Base64.getEncoder().encodeToString(this.buffer);
        }
        byte[] bytes = new byte[this.length];
        this.getBytes(0L, bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    public String toHex() {
        return HexFormat.of().formatHex(this.buffer, this.start, this.start + this.length);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Bytes)) {
            return false;
        }
        Bytes that = (Bytes)o;
        if ((long)this.length != that.length()) {
            return false;
        }
        if (this.length == 0) {
            return true;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.getByte(i) == that.getByte(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 1;
        for (long i = this.length() - 1L; i >= 0L; --i) {
            h = 31 * h + this.getByte(i);
        }
        return h;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte getByte(long offset) {
        if (this.length == 0) {
            throw new BufferUnderflowException();
        }
        this.validateOffset(offset);
        return this.buffer[this.start + Math.toIntExact(offset)];
    }

    @Override
    public long getBytes(long offset, @NonNull byte[] dst, int dstOffset, int maxLength) {
        this.validateOffset(offset);
        if (maxLength < 0) {
            throw new IllegalArgumentException("Negative maxLength not allowed");
        }
        if (maxLength == 0) {
            return 0L;
        }
        long len = Math.min((long)maxLength, (long)this.length - offset);
        System.arraycopy(this.buffer, this.start + Math.toIntExact(offset), dst, dstOffset, Math.toIntExact(len));
        return len;
    }

    @Override
    public long getBytes(long offset, @NonNull ByteBuffer dst) {
        this.validateOffset(offset);
        if (this.length == 0) {
            return 0L;
        }
        long len = Math.min((long)dst.remaining(), (long)this.length - offset);
        dst.put(this.buffer, this.start + Math.toIntExact(offset), Math.toIntExact(len));
        return len;
    }

    @Override
    public long getBytes(long offset, @NonNull BufferedData dst) {
        this.validateOffset(offset);
        if (this.length == 0) {
            return 0L;
        }
        long len = Math.min(dst.remaining(), (long)this.length - offset);
        dst.writeBytes(this.buffer, this.start + Math.toIntExact(offset), Math.toIntExact(len));
        return len;
    }

    @Override
    @NonNull
    public Bytes getBytes(long offset, long length) {
        this.validateOffset(offset);
        if (length > (long)this.length - offset) {
            throw new BufferUnderflowException();
        }
        if (length == 0L) {
            return EMPTY;
        }
        return new Bytes(this.buffer, Math.toIntExact((long)this.start + offset), Math.toIntExact(length));
    }

    @Override
    @NonNull
    public Bytes slice(long offset, long length) {
        return this.getBytes(offset, length);
    }

    @NonNull
    public byte[] toByteArray() {
        return this.toByteArray(0, this.length);
    }

    @NonNull
    public byte[] toByteArray(int offset, int length) {
        byte[] ret = new byte[length];
        this.getBytes((long)offset, ret);
        return ret;
    }

    private void validateOffset(long offset) {
        if (offset < 0L || offset > (long)this.length) {
            throw new IndexOutOfBoundsException("offset=" + offset + ", length=" + this.length);
        }
    }

    private static Comparator<Bytes> valueSorter(@NonNull Comparator<Byte> byteComparator) {
        return (o1, o2) -> {
            long val = Math.min(o1.length(), o2.length());
            for (long i = 0L; i < val; ++i) {
                int byteComparison = byteComparator.compare(o1.getByte(i), o2.getByte(i));
                if (byteComparison == 0) continue;
                return byteComparison;
            }
            long len = o1.length() - o2.length();
            if (len == 0L) {
                return 0;
            }
            return len > 0L ? 1 : -1;
        };
    }

    @NonNull
    public Bytes append(@NonNull Bytes bytes) {
        long length = this.length();
        byte[] newBytes = new byte[(int)(length + (long)((int)bytes.length()))];
        this.getBytes(0L, newBytes, 0, (int)length);
        bytes.getBytes(0L, newBytes, (int)length, (int)bytes.length());
        return Bytes.wrap(newBytes);
    }

    @NonNull
    public Bytes append(@NonNull RandomAccessData data) {
        byte[] newBytes = new byte[(int)(this.length() + (long)((int)data.length()))];
        int length1 = (int)this.length();
        this.getBytes(0L, newBytes, 0, length1);
        data.getBytes(0L, newBytes, length1, (int)data.length());
        return Bytes.wrap(newBytes);
    }

    @Override
    public int getVarInt(long offset, boolean zigZag) {
        int x;
        int tempPos = (int)offset;
        if (this.length == tempPos) {
            return RandomAccessData.super.getVarInt(offset, zigZag);
        }
        if ((x = this.buffer[tempPos++]) >= 0) {
            return zigZag ? x >>> 1 ^ -(x & 1) : x;
        }
        if (this.length - tempPos < 9) {
            return RandomAccessData.super.getVarInt(offset, zigZag);
        }
        if ((x ^= this.buffer[tempPos++] << 7) < 0) {
            x ^= 0xFFFFFF80;
        } else if ((x ^= this.buffer[tempPos++] << 14) >= 0) {
            x ^= 0x3F80;
        } else if ((x ^= this.buffer[tempPos++] << 21) < 0) {
            x ^= 0xFFE03F80;
        } else {
            byte y = this.buffer[tempPos++];
            x ^= y << 28;
            x ^= 0xFE03F80;
            if (y < 0 && this.buffer[tempPos++] < 0 && this.buffer[tempPos++] < 0 && this.buffer[tempPos++] < 0 && this.buffer[tempPos++] < 0 && this.buffer[tempPos++] < 0) {
                return RandomAccessData.super.getVarInt(offset, zigZag);
            }
        }
        return zigZag ? x >>> 1 ^ -(x & 1) : x;
    }

    @Override
    public long getVarLong(long offset, boolean zigZag) {
        long x;
        int y;
        int tempPos = (int)offset;
        if (tempPos == this.length) {
            return RandomAccessData.super.getVarLong(offset, zigZag);
        }
        if ((y = this.buffer[tempPos++]) >= 0) {
            return zigZag ? (long)(y >>> 1 ^ -(y & 1)) : (long)y;
        }
        if (this.length - tempPos < 9) {
            return RandomAccessData.super.getVarLong(offset, zigZag);
        }
        if ((y ^= this.buffer[tempPos++] << 7) < 0) {
            x = y ^ 0xFFFFFF80;
        } else if ((y ^= this.buffer[tempPos++] << 14) >= 0) {
            x = y ^ 0x3F80;
        } else if ((y ^= this.buffer[tempPos++] << 21) < 0) {
            x = y ^ 0xFFE03F80;
        } else if ((x = (long)y ^ (long)this.buffer[tempPos++] << 28) >= 0L) {
            x ^= 0xFE03F80L;
        } else if ((x ^= (long)this.buffer[tempPos++] << 35) < 0L) {
            x ^= 0xFFFFFFF80FE03F80L;
        } else if ((x ^= (long)this.buffer[tempPos++] << 42) >= 0L) {
            x ^= 0x3F80FE03F80L;
        } else if ((x ^= (long)this.buffer[tempPos++] << 49) < 0L) {
            x ^= 0xFFFE03F80FE03F80L;
        } else {
            x ^= (long)this.buffer[tempPos++] << 56;
            if ((x ^= 0xFE03F80FE03F80L) < 0L && (long)this.buffer[tempPos++] < 0L) {
                return RandomAccessData.super.getVarLong(offset, zigZag);
            }
        }
        return zigZag ? x >>> 1 ^ -(x & 1L) : x;
    }
}

