/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.io.buffer;

import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public interface RandomAccessData {
    public long length();

    public byte getByte(long var1);

    default public int getUnsignedByte(long offset) {
        return Byte.toUnsignedInt(this.getByte(offset));
    }

    default public long getBytes(long offset, @NonNull byte[] dst) {
        return this.getBytes(offset, dst, 0, dst.length);
    }

    default public long getBytes(long offset, @NonNull byte[] dst, int dstOffset, int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("Negative maxLength not allowed");
        }
        long len = Math.min((long)maxLength, this.length() - offset);
        int i = 0;
        while ((long)i < len) {
            dst[dstOffset + i] = this.getByte(offset + (long)i);
            ++i;
        }
        return len;
    }

    default public long getBytes(long offset, @NonNull ByteBuffer dst) {
        long index = offset;
        while (dst.hasRemaining()) {
            dst.put(this.getByte(index++));
        }
        return index - offset;
    }

    default public long getBytes(long offset, @NonNull BufferedData dst) {
        long index = offset;
        while (dst.hasRemaining()) {
            dst.writeByte(this.getByte(index++));
        }
        return index - offset;
    }

    @NonNull
    default public Bytes getBytes(long offset, long length) {
        if (offset < 0L || offset >= this.length()) {
            throw new IndexOutOfBoundsException("offset=" + offset + ", length=" + this.length());
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Negative maxLength not allowed");
        }
        if (length > this.length() - offset) {
            throw new BufferUnderflowException();
        }
        if (length == 0L) {
            return Bytes.EMPTY;
        }
        byte[] buf = new byte[Math.toIntExact(length)];
        this.getBytes(offset, buf);
        return Bytes.wrap(buf);
    }

    @NonNull
    default public RandomAccessData slice(long offset, long length) {
        return this.getBytes(offset, length);
    }

    default public int getInt(long offset) {
        if (this.length() - offset < 4L) {
            throw new BufferUnderflowException();
        }
        byte b1 = this.getByte(offset);
        byte b2 = this.getByte(offset + 1L);
        byte b3 = this.getByte(offset + 2L);
        byte b4 = this.getByte(offset + 3L);
        return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    default public int getInt(long offset, @NonNull ByteOrder byteOrder) {
        if (this.length() - offset < 4L) {
            throw new BufferUnderflowException();
        }
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            byte b4 = this.getByte(offset);
            byte b3 = this.getByte(offset + 1L);
            byte b2 = this.getByte(offset + 2L);
            byte b1 = this.getByte(offset + 3L);
            return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
        }
        return this.getInt(offset);
    }

    default public long getUnsignedInt(long offset) {
        return (long)this.getInt(offset) & 0xFFFFFFFFL;
    }

    default public long getUnsignedInt(long offset, @NonNull ByteOrder byteOrder) {
        return (long)this.getInt(offset, byteOrder) & 0xFFFFFFFFL;
    }

    default public long getLong(long offset) {
        if (this.length() - offset < 8L) {
            throw new BufferUnderflowException();
        }
        byte b1 = this.getByte(offset);
        byte b2 = this.getByte(offset + 1L);
        byte b3 = this.getByte(offset + 2L);
        byte b4 = this.getByte(offset + 3L);
        byte b5 = this.getByte(offset + 4L);
        byte b6 = this.getByte(offset + 5L);
        byte b7 = this.getByte(offset + 6L);
        byte b8 = this.getByte(offset + 7L);
        return ((long)b1 << 56) + ((long)(b2 & 0xFF) << 48) + ((long)(b3 & 0xFF) << 40) + ((long)(b4 & 0xFF) << 32) + ((long)(b5 & 0xFF) << 24) + (long)((b6 & 0xFF) << 16) + (long)((b7 & 0xFF) << 8) + (long)(b8 & 0xFF);
    }

    default public long getLong(long offset, @NonNull ByteOrder byteOrder) {
        if (this.length() - offset < 8L) {
            throw new BufferUnderflowException();
        }
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            byte b8 = this.getByte(offset);
            byte b7 = this.getByte(offset + 1L);
            byte b6 = this.getByte(offset + 2L);
            byte b5 = this.getByte(offset + 3L);
            byte b4 = this.getByte(offset + 4L);
            byte b3 = this.getByte(offset + 5L);
            byte b2 = this.getByte(offset + 6L);
            byte b1 = this.getByte(offset + 7L);
            return ((long)b1 << 56) + ((long)(b2 & 0xFF) << 48) + ((long)(b3 & 0xFF) << 40) + ((long)(b4 & 0xFF) << 32) + ((long)(b5 & 0xFF) << 24) + (long)((b6 & 0xFF) << 16) + (long)((b7 & 0xFF) << 8) + (long)(b8 & 0xFF);
        }
        return this.getLong(offset);
    }

    default public float getFloat(long offset) {
        return Float.intBitsToFloat(this.getInt(offset));
    }

    default public float getFloat(long offset, @NonNull ByteOrder byteOrder) {
        return Float.intBitsToFloat(this.getInt(offset, byteOrder));
    }

    default public double getDouble(long offset) {
        return Double.longBitsToDouble(this.getLong(offset));
    }

    default public double getDouble(long offset, @NonNull ByteOrder byteOrder) {
        return Double.longBitsToDouble(this.getLong(offset, byteOrder));
    }

    default public int getVarInt(long offset, boolean zigZag) {
        int result = 0;
        long index = offset;
        for (int shift = 0; shift < 32; shift += 7) {
            byte b = this.getByte(index++);
            result = (int)((long)result | (long)(b & 0x7F) << shift);
            if ((b & 0x80) != 0) continue;
            return zigZag ? result >>> 1 ^ -(result & 1) : result;
        }
        throw new RuntimeException("Malformed Varint");
    }

    default public long getVarLong(long offset, boolean zigZag) {
        long result = 0L;
        long index = offset;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.getByte(index++);
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return zigZag ? result >>> 1 ^ -(result & 1L) : result;
        }
        throw new RuntimeException("Malformed Varlong");
    }

    @NonNull
    default public String asUtf8String() {
        return this.asUtf8String(0L, this.length());
    }

    @NonNull
    default public String asUtf8String(long offset, long len) {
        if (len > this.length() - offset) {
            throw new BufferUnderflowException();
        }
        if (offset < 0L || offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0L) {
            return "";
        }
        byte[] data = new byte[Math.toIntExact(len)];
        this.getBytes(offset, data);
        return new String(data, StandardCharsets.UTF_8);
    }

    default public boolean matchesPrefix(@NonNull byte[] prefix) {
        return this.contains(0L, prefix);
    }

    default public boolean contains(long offset, @NonNull byte[] bytes) {
        if (offset < 0L || offset >= this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.length() - offset < (long)bytes.length) {
            return false;
        }
        for (long i = offset; i < (long)bytes.length; ++i) {
            if (bytes[Math.toIntExact(i)] == this.getByte(i)) continue;
            return false;
        }
        return true;
    }

    default public boolean matchesPrefix(@NonNull RandomAccessData prefix) {
        return this.contains(0L, prefix);
    }

    default public boolean contains(long offset, @NonNull RandomAccessData data) {
        if (this.length() == 0L) {
            return data.length() == 0L;
        }
        if (offset < 0L || offset >= this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.length() - offset < data.length()) {
            return false;
        }
        for (long i = offset; i < data.length(); ++i) {
            if (data.getByte(i) == this.getByte(i)) continue;
            return false;
        }
        return true;
    }
}

