/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.io.buffer;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class RandomAccessSequenceAdapter
implements ReadableSequentialData {
    private final RandomAccessData delegate;
    private final long capacity;
    private final long start;
    private long position;
    private long limit;

    RandomAccessSequenceAdapter(@NonNull RandomAccessData delegate) {
        this.delegate = delegate;
        this.capacity = delegate.length();
        this.start = 0L;
        this.limit = this.capacity;
    }

    RandomAccessSequenceAdapter(@NonNull RandomAccessData delegate, long start) {
        this.delegate = delegate;
        this.start = start;
        this.limit = this.capacity = delegate.length() - start;
        if (this.start > delegate.length()) {
            throw new IllegalArgumentException("Start " + start + " is greater than the delegate length " + delegate.length());
        }
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public void limit(long limit) {
        this.limit = Math.max(this.position, Math.min(limit, this.delegate.length()));
    }

    @Override
    public long skip(long count) {
        long c = Math.min(count, this.remaining());
        if (c <= 0L) {
            return 0L;
        }
        this.position += c;
        return c;
    }

    @Override
    public byte readByte() {
        this.checkUnderflow(1);
        byte b = this.delegate.getByte(this.start + this.position);
        ++this.position;
        return b;
    }

    @Override
    public int readUnsignedByte() {
        this.checkUnderflow(1);
        int b = this.delegate.getUnsignedByte(this.start + this.position);
        ++this.position;
        return b;
    }

    @Override
    public long readBytes(@NonNull byte[] dst, int offset, int maxLength) {
        if (offset < 0 || offset > dst.length) {
            throw new IndexOutOfBoundsException("Offset cannot be negative or larger than last index");
        }
        long length = Math.min((long)maxLength, this.remaining());
        long read = this.delegate.getBytes(this.start + this.position, dst, offset, Math.toIntExact(length));
        this.position += read;
        return read;
    }

    @Override
    public long readBytes(@NonNull ByteBuffer dst) {
        int dstPos = dst.position();
        long length = Math.min((long)dst.remaining(), this.remaining());
        long finalLimit = (long)dstPos + Math.min(length, (long)dst.remaining());
        dst.limit(Math.toIntExact(finalLimit));
        this.delegate.getBytes(this.start + this.position, dst);
        this.position += length;
        return length;
    }

    @Override
    public long readBytes(@NonNull BufferedData dst) {
        long dstPos = dst.position();
        long length = Math.min(dst.remaining(), this.remaining());
        long finalLimit = dstPos + Math.min(length, dst.remaining());
        dst.limit(Math.toIntExact(finalLimit));
        this.delegate.getBytes(this.start + this.position, dst);
        this.position += length;
        return length;
    }

    @Override
    @NonNull
    public Bytes readBytes(int length) {
        if (this.remaining() < (long)length) {
            throw new BufferUnderflowException();
        }
        Bytes bytes = this.delegate.getBytes(this.start + this.position, length);
        this.position += bytes.length();
        return bytes;
    }

    @Override
    @NonNull
    public ReadableSequentialData view(int length) {
        this.checkUnderflow(length);
        if (length < 0) {
            throw new IllegalArgumentException("Length cannot be negative");
        }
        RandomAccessSequenceAdapter view = new RandomAccessSequenceAdapter(this.delegate.slice(this.start + this.position, length));
        this.position += view.capacity();
        return view;
    }

    @Override
    public int readInt() {
        this.checkUnderflow(4);
        int result = this.delegate.getInt(this.start + this.position);
        this.position += 4L;
        return result;
    }

    @Override
    public int readInt(@NonNull ByteOrder byteOrder) {
        this.checkUnderflow(4);
        int result = this.delegate.getInt(this.start + this.position, byteOrder);
        this.position += 4L;
        return result;
    }

    @Override
    public long readLong() {
        this.checkUnderflow(8);
        long result = this.delegate.getLong(this.start + this.position);
        this.position += 8L;
        return result;
    }

    @Override
    public long readLong(@NonNull ByteOrder byteOrder) {
        this.checkUnderflow(8);
        long result = this.delegate.getLong(this.start + this.position, byteOrder);
        this.position += 8L;
        return result;
    }

    @Override
    public float readFloat() {
        this.checkUnderflow(4);
        float result = this.delegate.getFloat(this.start + this.position);
        this.position += 4L;
        return result;
    }

    @Override
    public float readFloat(@NonNull ByteOrder byteOrder) {
        this.checkUnderflow(4);
        float result = this.delegate.getFloat(this.start + this.position, byteOrder);
        this.position += 4L;
        return result;
    }

    @Override
    public double readDouble() {
        this.checkUnderflow(8);
        double result = this.delegate.getDouble(this.start + this.position);
        this.position += 8L;
        return result;
    }

    @Override
    public double readDouble(@NonNull ByteOrder byteOrder) {
        this.checkUnderflow(8);
        double result = this.delegate.getDouble(this.start + this.position, byteOrder);
        this.position += 8L;
        return result;
    }

    private void checkUnderflow(int remainingBytes) {
        if (this.remaining() - (long)remainingBytes < 0L) {
            throw new BufferUnderflowException();
        }
    }
}

