/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.io.stream;

import com.hedera.pbj.runtime.io.DataAccessException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.util.Objects;

public class ReadableStreamingData
implements ReadableSequentialData,
AutoCloseable {
    private final InputStream in;
    private long position = 0L;
    private long limit = Long.MAX_VALUE;
    private boolean eof = false;

    public ReadableStreamingData(@NonNull InputStream in) {
        this.in = Objects.requireNonNull(in);
    }

    @Override
    public void close() {
        try {
            this.eof = true;
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public long capacity() {
        return Long.MAX_VALUE;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public void limit(long limit) {
        this.limit = Math.min(this.capacity(), Math.max(this.position, limit));
    }

    @Override
    public long remaining() {
        return this.eof ? 0L : this.limit - this.position;
    }

    @Override
    public boolean hasRemaining() {
        return !this.eof && this.position < this.limit;
    }

    @Override
    public byte readByte() {
        if (this.eof || this.position >= this.limit) {
            throw new BufferUnderflowException();
        }
        try {
            int result = this.in.read();
            if (result == -1) {
                this.eof = true;
                throw new EOFException();
            }
            ++this.position;
            return (byte)result;
        }
        catch (IOException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public long skip(long n) {
        long clamped = Math.min(n, this.limit);
        if (clamped <= 0L) {
            return 0L;
        }
        try {
            long numSkipped = this.in.skip(clamped);
            this.position += numSkipped;
            return numSkipped;
        }
        catch (IOException e) {
            throw new DataAccessException(e);
        }
    }
}

