/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.test;

import com.hedera.pbj.runtime.io.DataAccessException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.CharBuffer;

public class CharBufferToWritableSequentialData
implements WritableSequentialData,
ReadableSequentialData {
    private final CharBuffer charBuffer;

    public CharBufferToWritableSequentialData(CharBuffer charBuffer) {
        this.charBuffer = charBuffer;
    }

    @Override
    public long capacity() {
        return this.charBuffer.capacity();
    }

    @Override
    public long position() {
        return this.charBuffer.position();
    }

    @Override
    public long limit() {
        return this.charBuffer.limit();
    }

    @Override
    public void limit(long limit) {
        this.charBuffer.limit((int)limit);
    }

    @Override
    public long skip(long count) {
        long numToSkip = Math.max(Math.min(count, (long)this.charBuffer.remaining()), 0L);
        this.charBuffer.position((int)numToSkip);
        return numToSkip;
    }

    @Override
    public void writeByte(byte b) throws DataAccessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeUTF8(@NonNull String value) {
        this.charBuffer.put(value);
    }

    @Override
    public byte readByte() {
        throw new UnsupportedOperationException();
    }
}

