/*
 * Decompiled with CFR 0.152.
 */
package com.heidelpay.android.backend;

import com.heidelpay.android.backend.BackendError;
import com.heidelpay.android.backend.BackendRequestAsyncTask;
import com.heidelpay.android.backend.BackendRequestParams;
import com.heidelpay.android.backend.BackendServerErrorResponse;
import com.heidelpay.android.backend.BackendService;
import com.heidelpay.android.backend.Environment;
import com.heidelpay.android.backend.HeidelpayDataRequest;
import com.heidelpay.android.backend.HeidelpayRequest;
import com.heidelpay.android.types.PublicKey;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J?\u0010\u0007\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\t2\u000e\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010H\u0000\u00a2\u0006\u0002\b\u0011J%\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016JP\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152>\u0010\u0019\u001a:\u0012\u0015\u0012\u0013\u0018\u00010\u001b\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0015\u0012\u0013\u0018\u00010\n\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00180\u001aj\u0002` H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/heidelpay/android/backend/HttpBackendService;", "Lcom/heidelpay/android/backend/BackendService;", "publicKey", "Lcom/heidelpay/android/types/PublicKey;", "environment", "Lcom/heidelpay/android/backend/Environment;", "(Lcom/heidelpay/android/types/PublicKey;Lcom/heidelpay/android/backend/Environment;)V", "buildResponse", "Lkotlin/Pair;", "", "Lcom/heidelpay/android/backend/BackendError;", "urlConnection", "Ljavax/net/ssl/HttpsURLConnection;", "responseString", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "buildResponse$heidelpay_release", "buildUrlConnection", "Lorg/json/JSONObject;", "request", "Lcom/heidelpay/android/backend/HeidelpayRequest;", "buildUrlConnection$heidelpay_release", "performRequest", "", "completion", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "response", "error", "Lcom/heidelpay/android/backend/HeidelpayBackendRequestCompletion;", "heidelpay_release"})
public final class HttpBackendService
implements BackendService {
    private final PublicKey publicKey;
    private final Environment environment;

    @Nullable
    public final Pair<HttpsURLConnection, JSONObject> buildUrlConnection$heidelpay_release(@NotNull HeidelpayRequest request) {
        HttpsURLConnection urlConnection;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        URL requestURL = this.environment.fullURLPathForPath(request.getRequestPath());
        URLConnection uRLConnection = requestURL.openConnection();
        if (!(uRLConnection instanceof HttpsURLConnection)) {
            uRLConnection = null;
        }
        if ((urlConnection = (HttpsURLConnection)uRLConnection) != null) {
            urlConnection.addRequestProperty("Accept", "application/json");
            urlConnection.addRequestProperty("Accept-Language", "en");
            urlConnection.addRequestProperty("Authorization", this.publicKey.getAuthorizationHeaderValue());
            JSONObject dataObject = null;
            if (request instanceof HeidelpayDataRequest) {
                urlConnection.setRequestMethod("POST");
                urlConnection.addRequestProperty("Content-Type", "application/json");
                dataObject = ((HeidelpayDataRequest)request).encodeToJSON();
            } else {
                urlConnection.setRequestMethod("GET");
            }
            return new Pair((Object)urlConnection, (Object)dataObject);
        }
        return null;
    }

    @Override
    public void performRequest(@NotNull HeidelpayRequest request, @NotNull Function2<Object, ? super BackendError, Unit> completion) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
        Pair<HttpsURLConnection, JSONObject> urlConnectionAndDataObject = this.buildUrlConnection$heidelpay_release(request);
        if (urlConnectionAndDataObject != null) {
            new BackendRequestAsyncTask().execute(new BackendRequestParams[]{new BackendRequestParams((HttpsURLConnection)urlConnectionAndDataObject.getFirst(), (JSONObject)urlConnectionAndDataObject.getSecond(), this.environment.getPinnedPublicKeyHash(), (Function3<? super HttpsURLConnection, ? super String, ? super Exception, Unit>)((Function3)new Function3<HttpsURLConnection, String, Exception, Unit>(this, completion, request){
                final /* synthetic */ HttpBackendService this$0;
                final /* synthetic */ Function2 $completion;
                final /* synthetic */ HeidelpayRequest $request;

                public final void invoke(@NotNull HttpsURLConnection urlConnection, @Nullable String responseString, @Nullable Exception exception) {
                    Intrinsics.checkParameterIsNotNull((Object)urlConnection, (String)"urlConnection");
                    Pair<String, BackendError> response = this.this$0.buildResponse$heidelpay_release(urlConnection, responseString, exception);
                    if (response.getFirst() != null) {
                        Object object = response.getFirst();
                        if (object == null) {
                            Intrinsics.throwNpe();
                        }
                        this.$completion.invoke(this.$request.createResponseFromDataString((String)object), null);
                    } else {
                        this.$completion.invoke(null, response.getSecond());
                    }
                }
                {
                    this.this$0 = httpBackendService;
                    this.$completion = function2;
                    this.$request = heidelpayRequest;
                    super(3);
                }
            }))});
        } else {
            completion.invoke(null, (Object)new BackendError.InvalidRequest());
        }
    }

    @NotNull
    public final Pair<String, BackendError> buildResponse$heidelpay_release(@NotNull HttpsURLConnection urlConnection, @Nullable String responseString, @Nullable Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)urlConnection, (String)"urlConnection");
        if (exception != null) {
            if (exception instanceof IOException) {
                return new Pair(null, (Object)new BackendError.NoInternet());
            }
            return new Pair(null, (Object)new BackendError.RequestFailed(exception));
        }
        if (urlConnection.getResponseCode() >= 400) {
            return new Pair(null, (Object)new BackendError.ServerHTTPError(urlConnection.getResponseCode()));
        }
        if (responseString != null) {
            BackendServerErrorResponse backendServerErrorResponse = BackendServerErrorResponse.Companion.fromJSONString(responseString);
            if (backendServerErrorResponse != null) {
                return new Pair(null, (Object)new BackendError.ServerResponseError(backendServerErrorResponse.getErrors()));
            }
            return new Pair((Object)responseString, null);
        }
        return new Pair(null, (Object)new BackendError.InvalidRequest());
    }

    public HttpBackendService(@NotNull PublicKey publicKey, @NotNull Environment environment) {
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        this.publicKey = publicKey;
        this.environment = environment;
    }
}

