/*
 * Decompiled with CFR 0.152.
 */
package com.heidelpay.android.backend;

import android.net.http.X509TrustManagerExtensions;
import android.util.Base64;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u00042\u0006\u0010\n\u001a\u00020\u0001H\u0002*\u00b1\u0001\u0010\u000b\"K\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0015\u0012\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012\u0015\u0012\u0013\u0018\u0001`\u0011\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00030\f2`\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0015\u0012\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012*\u0012(\u0018\u00010\u0013j\u0013\u0018\u0001`\u0011\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0012\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00030\f\u00a8\u0006\u0014"}, d2={"getTrustManagerExt", "Landroid/net/http/X509TrustManagerExtensions;", "pin", "", "Ljavax/net/ssl/HttpsURLConnection;", "publicKeyToPin", "", "trustedChain", "", "Ljava/security/cert/X509Certificate;", "trustManagerExt", "HeidelpayHttpBackendServiceInternalCompletion", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "urlConnection", "responseString", "Lkotlin/Exception;", "exception", "Ljava/lang/Exception;", "heidelpay_release"})
public final class HttpBackendServiceKt {
    private static final void pin(@NotNull HttpsURLConnection $receiver, String publicKeyToPin) {
        X509TrustManagerExtensions trustManagerExt = HttpBackendServiceKt.getTrustManagerExt();
        String certChainMsg = "";
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            List<X509Certificate> trustedChain = HttpBackendServiceKt.trustedChain($receiver, trustManagerExt);
            for (X509Certificate cert : trustedChain) {
                byte[] publicKeyOfServer = cert.getPublicKey().getEncoded();
                md.update(publicKeyOfServer, 0, publicKeyOfServer.length);
                String pin = Base64.encodeToString((byte[])md.digest(), (int)2);
                certChainMsg = certChainMsg + "    sha256/" + pin + " : " + ((Object)cert.getSubjectDN()).toString() + "\n";
                if (!publicKeyToPin.equals(pin)) continue;
                return;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new SSLException(e);
        }
        throw (Throwable)new SSLPeerUnverifiedException("Certificate pinning failure\n  Peer certificate chain:\n" + certChainMsg);
    }

    private static final List<X509Certificate> trustedChain(@NotNull HttpsURLConnection $receiver, X509TrustManagerExtensions trustManagerExt) throws SSLException {
        Certificate[] serverCerts = $receiver.getServerCertificates();
        X509Certificate[] untrustedCerts = (X509Certificate[])Arrays.copyOf(serverCerts, serverCerts.length, X509Certificate[].class);
        String host = $receiver.getURL().getHost();
        try {
            List list = trustManagerExt.checkServerTrusted(untrustedCerts, "RSA", host);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"trustManagerExt.checkSer\u2026rustedCerts, \"RSA\", host)");
            return list;
        }
        catch (CertificateException e) {
            throw (Throwable)new SSLException(e);
        }
    }

    private static final X509TrustManagerExtensions getTrustManagerExt() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        X509TrustManager x509TrustManager = null;
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            x509TrustManager = (X509TrustManager)trustManager;
            break;
        }
        X509TrustManagerExtensions trustManagerExt = new X509TrustManagerExtensions(x509TrustManager);
        return trustManagerExt;
    }

    public static final /* synthetic */ void access$pin(@NotNull HttpsURLConnection $receiver, @NotNull String publicKeyToPin) {
        HttpBackendServiceKt.pin($receiver, publicKeyToPin);
    }
}

