/*
 * Decompiled with CFR 0.152.
 */
package com.heidelpay.android.ui;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import com.heidelpay.android.R;
import com.heidelpay.android.ui.model.Input;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00020\u001fH$\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0002J\u0012\u0010#\u001a\u00020$2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002R\u001a\u0010\f\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001e\u0010\u0017\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006%"}, d2={"Lcom/heidelpay/android/ui/FormattingEditText;", "T", "Lcom/heidelpay/android/ui/model/Input;", "Landroid/support/v7/widget/AppCompatEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "drawableTintColor", "getDrawableTintColor", "()I", "setDrawableTintColor", "(I)V", "errorTextColor", "getErrorTextColor", "setErrorTextColor", "originalTextColor", "getOriginalTextColor", "setOriginalTextColor", "userInput", "getUserInput", "()Lcom/heidelpay/android/ui/model/Input;", "setUserInput", "(Lcom/heidelpay/android/ui/model/Input;)V", "Lcom/heidelpay/android/ui/model/Input;", "createInput", "string", "", "(Ljava/lang/String;)Lcom/heidelpay/android/ui/model/Input;", "getColorFromId", "colorId", "readAttributes", "", "heidelpay_release"})
public abstract class FormattingEditText<T extends Input>
extends AppCompatEditText {
    private int errorTextColor;
    private int originalTextColor;
    private int drawableTintColor;
    @Nullable
    private T userInput;
    private HashMap _$_findViewCache;

    protected final int getErrorTextColor() {
        return this.errorTextColor;
    }

    protected final void setErrorTextColor(int n) {
        this.errorTextColor = n;
    }

    protected final int getOriginalTextColor() {
        return this.originalTextColor;
    }

    protected final void setOriginalTextColor(int n) {
        this.originalTextColor = n;
    }

    protected final int getDrawableTintColor() {
        return this.drawableTintColor;
    }

    protected final void setDrawableTintColor(int n) {
        this.drawableTintColor = n;
    }

    @Nullable
    public final T getUserInput() {
        return this.userInput;
    }

    public final void setUserInput(@Nullable T t) {
        this.userInput = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readAttributes(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.FormattingEditText, 0, 0);
        try {
            this.errorTextColor = typedArray.getColor(R.styleable.FormattingEditText_errorTextColor, this.getColorFromId(R.color.heidelPayErrorColor));
            this.drawableTintColor = typedArray.getColor(R.styleable.FormattingEditText_drawableTintColor, 0);
        }
        catch (Exception exception) {
        }
        finally {
            typedArray.recycle();
        }
    }

    private final int getColorFromId(int colorId) {
        if (Build.VERSION.SDK_INT >= 23) {
            Resources resources = this.getResources();
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            return resources.getColor(colorId, context.getTheme());
        }
        return this.getResources().getColor(colorId);
    }

    @NotNull
    protected abstract T createInput(@NotNull String var1);

    public FormattingEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.originalTextColor = this.getCurrentTextColor();
        this.addTextChangedListener(new TextWatcher(this){
            final /* synthetic */ FormattingEditText this$0;

            public void afterTextChanged(@Nullable Editable s) {
            }

            public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
                this.this$0.removeTextChangedListener(this);
                if (s != null) {
                    String string = ((Object)s).toString();
                    this.this$0.setUserInput(this.this$0.createInput(string));
                    if (this.this$0.getUserInput() != null) {
                        if (this.isDeleting(count)) {
                            Object t = this.this$0.getUserInput();
                            if (t == null) {
                                Intrinsics.throwNpe();
                            }
                            this.this$0.setText(t.getTrimmedValue());
                        } else {
                            Object t = this.this$0.getUserInput();
                            if (t == null) {
                                Intrinsics.throwNpe();
                            }
                            this.this$0.setText(t.getFormattedValue());
                        }
                        Object t = this.this$0.getUserInput();
                        if (t == null) {
                            Intrinsics.throwNpe();
                        }
                        if (t.getValid()) {
                            this.this$0.setTextColor(this.this$0.getOriginalTextColor());
                        } else if (this.this$0.getErrorTextColor() != 0) {
                            this.this$0.setTextColor(this.this$0.getErrorTextColor());
                        }
                    }
                    if (this.this$0.getText() != null) {
                        Editable editable = this.this$0.getText();
                        if (editable == null) {
                            Intrinsics.throwNpe();
                        }
                        this.this$0.setSelection(editable.length());
                    }
                } else {
                    this.this$0.setUserInput(null);
                }
                this.this$0.addTextChangedListener(this);
            }

            private final boolean isDeleting(int count) {
                return count == 0;
            }
            {
                this.this$0 = $outer;
            }
        });
        this.readAttributes(attrs);
    }

    public FormattingEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.originalTextColor = this.getCurrentTextColor();
        this.addTextChangedListener(new /* invalid duplicate definition of identical inner class */);
        this.readAttributes(attrs);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

