/*
 * Decompiled with CFR 0.152.
 */
package com.heidelpay.android.ui.model;

import com.heidelpay.android.ui.StringExtensionsKt;
import com.heidelpay.android.ui.model.FixedGroups;
import com.heidelpay.android.ui.model.GroupingStyle;
import com.heidelpay.android.ui.model.Input;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/heidelpay/android/ui/model/CardExpiryInput;", "Lcom/heidelpay/android/ui/model/Input;", "expiryDateAsString", "", "(Ljava/lang/String;)V", "expiryDate", "getExpiryDate", "()Ljava/lang/String;", "formattedValue", "getFormattedValue", "groupingSeparator", "groupingStyle", "Lcom/heidelpay/android/ui/model/FixedGroups;", "maxLength", "", "month", "getMonth", "()I", "trimmedValue", "getTrimmedValue", "valid", "", "getValid", "()Z", "year", "getYear", "heidelpay_release"})
public final class CardExpiryInput
implements Input {
    @NotNull
    private final String expiryDate;
    private final boolean valid;
    private final String groupingSeparator = "/";
    private final int maxLength = 4;
    private final FixedGroups groupingStyle;

    @NotNull
    public final String getExpiryDate() {
        return this.expiryDate;
    }

    @Override
    public boolean getValid() {
        return this.valid;
    }

    public final int getMonth() {
        if (this.expiryDate.length() == 4) {
            String string = this.expiryDate;
            int n = 0;
            int n2 = 2;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string3;
            int monthValue = Integer.parseInt(string);
            if (monthValue > 0 && monthValue < 13) {
                return monthValue;
            }
        }
        return -1;
    }

    public final int getYear() {
        if (this.expiryDate.length() == 4) {
            String string = this.expiryDate;
            int n = this.expiryDate.length() - 2;
            int n2 = this.expiryDate.length();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string3;
            return Integer.parseInt(string) + 2000;
        }
        return -1;
    }

    @Override
    @NotNull
    public String getFormattedValue() {
        return this.groupingStyle.groupString(this.expiryDate, this.groupingSeparator);
    }

    @Override
    @NotNull
    public String getTrimmedValue() {
        return StringExtensionsKt.heidelpay_trim(this.getFormattedValue(), this.groupingSeparator);
    }

    public CardExpiryInput(@NotNull String expiryDateAsString) {
        Intrinsics.checkParameterIsNotNull((Object)expiryDateAsString, (String)"expiryDateAsString");
        this.groupingSeparator = "/";
        this.maxLength = 4;
        this.groupingStyle = new FixedGroups(2, this.maxLength);
        String condensedExpDate = StringExtensionsKt.heidelpay_limitedString(GroupingStyle.Companion.ungroupString(expiryDateAsString, this.groupingSeparator), this.maxLength);
        this.expiryDate = condensedExpDate.length() == 1 && condensedExpDate.charAt(0) != '1' && condensedExpDate.charAt(0) != '0' ? '0' + condensedExpDate + this.groupingSeparator : condensedExpDate;
        if (condensedExpDate.length() == this.maxLength) {
            int currentYear = Calendar.getInstance().get(1);
            int currentMonth = Calendar.getInstance().get(2);
            this.valid = this.getMonth() <= 12 && this.getMonth() > 0 && (this.getYear() > currentYear || this.getYear() == currentYear && this.getMonth() > currentMonth);
        } else {
            this.valid = false;
        }
    }
}

