/*
 * Decompiled with CFR 0.152.
 */
package com.heidelpay.android.ui.model;

import com.heidelpay.android.ui.StringExtensionsKt;
import com.heidelpay.android.ui.model.CreditCardType;
import com.heidelpay.android.ui.model.GroupingStyle;
import com.heidelpay.android.ui.model.Input;
import com.heidelpay.android.ui.model.PaymentTypeInformationValidationResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/heidelpay/android/ui/model/CreditCardInput;", "Lcom/heidelpay/android/ui/model/Input;", "creditCardNumber", "", "(Ljava/lang/String;)V", "getCreditCardNumber", "()Ljava/lang/String;", "creditCardType", "Lcom/heidelpay/android/ui/model/CreditCardType;", "getCreditCardType", "()Lcom/heidelpay/android/ui/model/CreditCardType;", "formattedValue", "getFormattedValue", "groupingSeparator", "groupingStyle", "Lcom/heidelpay/android/ui/model/GroupingStyle;", "maxLength", "", "trimmedValue", "getTrimmedValue", "valid", "", "getValid", "()Z", "validationResult", "Lcom/heidelpay/android/ui/model/PaymentTypeInformationValidationResult;", "getValidationResult", "()Lcom/heidelpay/android/ui/model/PaymentTypeInformationValidationResult;", "heidelpay_release"})
public final class CreditCardInput
implements Input {
    @NotNull
    private final String creditCardNumber;
    @NotNull
    private final PaymentTypeInformationValidationResult validationResult;
    @NotNull
    private final CreditCardType creditCardType;
    private final String groupingSeparator = " ";
    private final int maxLength;
    private final GroupingStyle groupingStyle;

    @NotNull
    public final String getCreditCardNumber() {
        return this.creditCardNumber;
    }

    @NotNull
    public final PaymentTypeInformationValidationResult getValidationResult() {
        return this.validationResult;
    }

    @NotNull
    public final CreditCardType getCreditCardType() {
        return this.creditCardType;
    }

    @Override
    public boolean getValid() {
        return this.validationResult == PaymentTypeInformationValidationResult.ValidChecksum;
    }

    @Override
    @NotNull
    public String getFormattedValue() {
        return this.groupingStyle.groupString(this.creditCardNumber, this.groupingSeparator);
    }

    @Override
    @NotNull
    public String getTrimmedValue() {
        return StringExtensionsKt.heidelpay_trim(this.getFormattedValue(), this.groupingSeparator);
    }

    public CreditCardInput(@NotNull String creditCardNumber) {
        Intrinsics.checkParameterIsNotNull((Object)creditCardNumber, (String)"creditCardNumber");
        this.groupingSeparator = " ";
        String condensedCreditCardNumber = GroupingStyle.Companion.ungroupString(creditCardNumber, this.groupingSeparator);
        this.creditCardType = CreditCardType.Companion.fromString$heidelpay_release(condensedCreditCardNumber);
        this.groupingStyle = this.creditCardType.getGroupingMode();
        this.maxLength = this.creditCardType.getMaximumLength();
        this.creditCardNumber = StringExtensionsKt.heidelpay_limitedString(condensedCreditCardNumber, this.maxLength);
        this.validationResult = this.creditCardType.validate(this.creditCardNumber);
    }
}

