/*
 * Decompiled with CFR 0.152.
 */
package com.heidelpay.android.ui.model;

import com.heidelpay.android.ui.StringExtensionsKt;
import com.heidelpay.android.ui.model.CreditCardType$WhenMappings;
import com.heidelpay.android.ui.model.FixedGroups;
import com.heidelpay.android.ui.model.GroupingStyle;
import com.heidelpay.android.ui.model.PaymentTypeInformationValidationResult;
import com.heidelpay.android.ui.model.PaymentTypeInformationValidator;
import com.heidelpay.android.ui.model.VariableGroups;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0001\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nj\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0017"}, d2={"Lcom/heidelpay/android/ui/model/CreditCardType;", "", "(Ljava/lang/String;I)V", "groupingMode", "Lcom/heidelpay/android/ui/model/GroupingStyle;", "getGroupingMode", "()Lcom/heidelpay/android/ui/model/GroupingStyle;", "maximumLength", "", "getMaximumLength", "()I", "minimumLength", "getMinimumLength", "validate", "Lcom/heidelpay/android/ui/model/PaymentTypeInformationValidationResult;", "cardNumber", "", "Unknown", "Visa", "AmericanExpress", "MasterCard", "Maestro", "Companion", "heidelpay_release"})
public final class CreditCardType
extends Enum<CreditCardType> {
    public static final /* enum */ CreditCardType Unknown;
    public static final /* enum */ CreditCardType Visa;
    public static final /* enum */ CreditCardType AmericanExpress;
    public static final /* enum */ CreditCardType MasterCard;
    public static final /* enum */ CreditCardType Maestro;
    private static final /* synthetic */ CreditCardType[] $VALUES;
    public static final Companion Companion;

    static {
        CreditCardType[] creditCardTypeArray = new CreditCardType[5];
        CreditCardType[] creditCardTypeArray2 = creditCardTypeArray;
        creditCardTypeArray[0] = Unknown = new CreditCardType();
        creditCardTypeArray[1] = Visa = new CreditCardType();
        creditCardTypeArray[2] = AmericanExpress = new CreditCardType();
        creditCardTypeArray[3] = MasterCard = new CreditCardType();
        creditCardTypeArray[4] = Maestro = new CreditCardType();
        $VALUES = creditCardTypeArray;
        Companion = new Companion(null);
    }

    public final int getMinimumLength() {
        switch (CreditCardType$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                return 15;
            }
            case 2: {
                return 16;
            }
            case 3: {
                return 12;
            }
        }
        return 16;
    }

    public final int getMaximumLength() {
        switch (CreditCardType$WhenMappings.$EnumSwitchMapping$1[this.ordinal()]) {
            case 1: {
                return 15;
            }
            case 2: {
                return 16;
            }
            case 3: {
                return 19;
            }
        }
        return 16;
    }

    @NotNull
    public final GroupingStyle getGroupingMode() {
        switch (CreditCardType$WhenMappings.$EnumSwitchMapping$2[this.ordinal()]) {
            case 1: {
                return new VariableGroups(new int[]{4, 6, 5}, this.getMaximumLength());
            }
        }
        return new FixedGroups(4, this.getMaximumLength());
    }

    @NotNull
    public final PaymentTypeInformationValidationResult validate(@NotNull String cardNumber) {
        Intrinsics.checkParameterIsNotNull((Object)cardNumber, (String)"cardNumber");
        String condensedNumber = StringExtensionsKt.heidelpay_condensedString$default(cardNumber, null, 1, null);
        if (condensedNumber.length() < this.getMinimumLength() || condensedNumber.length() > this.getMaximumLength()) {
            return PaymentTypeInformationValidationResult.InvalidLength;
        }
        return PaymentTypeInformationValidator.INSTANCE.validateCreditCardNumber(cardNumber);
    }

    public static CreditCardType[] values() {
        return (CreditCardType[])$VALUES.clone();
    }

    public static CreditCardType valueOf(String string) {
        return Enum.valueOf(CreditCardType.class, string);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/heidelpay/android/ui/model/CreditCardType$Companion;", "", "()V", "fromString", "Lcom/heidelpay/android/ui/model/CreditCardType;", "string", "", "fromString$heidelpay_release", "heidelpay_release"})
    public static final class Companion {
        @NotNull
        public final CreditCardType fromString$heidelpay_release(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
            CharSequence charSequence = string;
            if (charSequence.length() == 0) {
                return Unknown;
            }
            char firstCharacter = StringsKt.first((CharSequence)string);
            switch (firstCharacter) {
                case '2': 
                case '5': {
                    return MasterCard;
                }
                case '3': {
                    return AmericanExpress;
                }
                case '4': {
                    return Visa;
                }
                case '6': 
                case '7': 
                case '9': {
                    return Maestro;
                }
            }
            return Unknown;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

