/*
 * Decompiled with CFR 0.152.
 */
package com.heidelpay.android.ui.model;

import com.heidelpay.android.ui.StringExtensionsKt;
import com.heidelpay.android.ui.model.FixedGroups;
import com.heidelpay.android.ui.model.GroupingStyle;
import com.heidelpay.android.ui.model.Input;
import com.heidelpay.android.ui.model.PaymentTypeInformationValidationResult;
import com.heidelpay.android.ui.model.PaymentTypeInformationValidator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0002R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lcom/heidelpay/android/ui/model/IBANInput;", "Lcom/heidelpay/android/ui/model/Input;", "iban", "", "(Ljava/lang/String;)V", "formattedValue", "getFormattedValue", "()Ljava/lang/String;", "groupingSeparator", "groupingStyle", "Lcom/heidelpay/android/ui/model/FixedGroups;", "heidelpayAllowedIbanAlphaCharacters", "heidelpayAllowedIbanNumberCharacters", "getIban", "maxLength", "", "trimmedValue", "getTrimmedValue", "valid", "", "getValid", "()Z", "validationResult", "Lcom/heidelpay/android/ui/model/PaymentTypeInformationValidationResult;", "getValidationResult", "()Lcom/heidelpay/android/ui/model/PaymentTypeInformationValidationResult;", "removeNotAllowedChars", "string", "heidelpay_release"})
public final class IBANInput
implements Input {
    @NotNull
    private final String iban;
    @NotNull
    private final PaymentTypeInformationValidationResult validationResult;
    private final String groupingSeparator = " ";
    private final int maxLength = 34;
    private final FixedGroups groupingStyle;
    private final String heidelpayAllowedIbanAlphaCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ ";
    private final String heidelpayAllowedIbanNumberCharacters = "01234567890 ";

    @NotNull
    public final String getIban() {
        return this.iban;
    }

    @NotNull
    public final PaymentTypeInformationValidationResult getValidationResult() {
        return this.validationResult;
    }

    @Override
    public boolean getValid() {
        return this.validationResult == PaymentTypeInformationValidationResult.ValidChecksum;
    }

    /*
     * WARNING - void declaration
     */
    private final String removeNotAllowedChars(String string) {
        String iban = "";
        int n = 0;
        int n2 = ((CharSequence)string).length();
        while (n < n2) {
            char c;
            char c2;
            CharSequence charSequence;
            void index;
            char character = string.charAt((int)index);
            if ((index >= 2 || StringsKt.contains$default((CharSequence)(charSequence = (CharSequence)this.heidelpayAllowedIbanAlphaCharacters), (char)(c2 = Character.toUpperCase(c = character)), (boolean)false, (int)2, null)) && (index < 2 || StringsKt.contains$default((CharSequence)(charSequence = (CharSequence)this.heidelpayAllowedIbanNumberCharacters), (char)(c2 = Character.toUpperCase(c = character)), (boolean)false, (int)2, null))) {
                iban = iban + character;
            }
            ++index;
        }
        return iban;
    }

    @Override
    @NotNull
    public String getFormattedValue() {
        return this.groupingStyle.groupString(this.iban, this.groupingSeparator);
    }

    @Override
    @NotNull
    public String getTrimmedValue() {
        return StringExtensionsKt.heidelpay_trim(this.getFormattedValue(), this.groupingSeparator);
    }

    public IBANInput(@NotNull String iban) {
        Intrinsics.checkParameterIsNotNull((Object)iban, (String)"iban");
        this.groupingSeparator = " ";
        this.maxLength = 34;
        this.groupingStyle = new FixedGroups(4, this.maxLength);
        this.heidelpayAllowedIbanAlphaCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ ";
        this.heidelpayAllowedIbanNumberCharacters = "01234567890 ";
        String condensedIban = GroupingStyle.Companion.ungroupString(iban, this.groupingSeparator);
        this.iban = this.removeNotAllowedChars(StringExtensionsKt.heidelpay_limitedString(condensedIban, this.maxLength));
        this.validationResult = PaymentTypeInformationValidator.INSTANCE.validateIBAN(iban);
    }
}

