/*
 * Decompiled with CFR 0.152.
 */
package com.heidelpay.android.ui.model;

import com.heidelpay.android.ui.StringExtensionsKt;
import com.heidelpay.android.ui.model.PaymentTypeInformationValidationResult;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J-\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00040\b2\u0006\u0010\u0006\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/heidelpay/android/ui/model/PaymentTypeInformationValidator;", "", "()V", "heidelpayIbanCharactersToConvert", "", "convertAlphaCharactersToDigitsIBAN", "iban", "nextModuloPart", "Lkotlin/Pair;", "", "modulo", "(Ljava/lang/String;Ljava/lang/Integer;)Lkotlin/Pair;", "normalizeIBAN", "reverseIBAN", "validateCreditCardNumber", "Lcom/heidelpay/android/ui/model/PaymentTypeInformationValidationResult;", "cardNumber", "validateIBAN", "heidelpay_release"})
public final class PaymentTypeInformationValidator {
    private static final String heidelpayIbanCharactersToConvert = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final PaymentTypeInformationValidator INSTANCE;

    @NotNull
    public final PaymentTypeInformationValidationResult validateIBAN(@NotNull String iban) {
        Intrinsics.checkParameterIsNotNull((Object)iban, (String)"iban");
        if (iban.length() < 9) {
            return PaymentTypeInformationValidationResult.InvalidLength;
        }
        String normalizedIban = this.normalizeIBAN(iban);
        if (!StringExtensionsKt.getHeidelpayStrictlyNumerical(normalizedIban)) {
            return PaymentTypeInformationValidationResult.InvalidCharacters;
        }
        int modulo = 0;
        String calculationString = normalizedIban;
        while (calculationString != null) {
            Pair<Integer, String> result = this.nextModuloPart(calculationString, modulo);
            modulo = ((Number)result.getFirst()).intValue();
            calculationString = (String)result.getSecond();
        }
        return modulo == 1 ? PaymentTypeInformationValidationResult.ValidChecksum : PaymentTypeInformationValidationResult.InvalidChecksum;
    }

    private final String normalizeIBAN(String iban) {
        String string;
        String string2 = string = iban;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        String cleanedIBAN = StringExtensionsKt.heidelpay_condensedString$default(string3, null, 1, null);
        String reversedIBAN = this.reverseIBAN(cleanedIBAN);
        return this.convertAlphaCharactersToDigitsIBAN(reversedIBAN);
    }

    private final String reverseIBAN(String iban) {
        String string = iban;
        int n = 0;
        int n2 = 4;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String startCharacters = string3;
        String string4 = iban;
        n2 = 4;
        String string5 = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        String remainder = string6;
        return remainder + startCharacters;
    }

    private final Pair<Integer, String> nextModuloPart(String iban, Integer modulo) {
        Pair pair;
        if (modulo != null) {
            if (iban.length() < 7) {
                Pair pair2;
                String string = modulo + iban;
                Pair pair3 = pair2;
                Pair pair4 = pair2;
                int n = Integer.parseInt(string);
                pair3((Object)(n % 97), null);
                return pair4;
            }
            CharSequence calculationString = iban.subSequence(0, 7);
            String string = "" + modulo + calculationString;
            int newModulo = Integer.parseInt(string) % 97;
            String remainder = ((Object)iban.subSequence(7, iban.length())).toString();
            return new Pair((Object)newModulo, (Object)(remainder.length() > 0 ? remainder : null));
        }
        String string = iban;
        int n = 0;
        int n2 = 9;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string3;
        int firstModulo = Integer.parseInt(string) % 97;
        string = iban;
        n = 9;
        Integer n3 = firstModulo;
        Pair pair5 = pair;
        Pair pair6 = pair;
        String string4 = string;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        String string6 = string5;
        pair5((Object)n3, (Object)string6);
        return pair6;
    }

    /*
     * WARNING - void declaration
     */
    private final String convertAlphaCharactersToDigitsIBAN(String iban) {
        String charsToConvert = heidelpayIbanCharactersToConvert;
        String convertedString = iban;
        int n = 0;
        int n2 = ((CharSequence)charsToConvert).length();
        while (n < n2) {
            void index;
            String character = String.valueOf(charsToConvert.charAt((int)index));
            convertedString = StringsKt.replace((String)convertedString, (String)character, (String)String.valueOf((int)(index + 10)), (boolean)true);
            ++index;
        }
        return convertedString;
    }

    @NotNull
    public final PaymentTypeInformationValidationResult validateCreditCardNumber(@NotNull String cardNumber) {
        Intrinsics.checkParameterIsNotNull((Object)cardNumber, (String)"cardNumber");
        String condensedCardNumber = StringExtensionsKt.heidelpay_condensedString$default(cardNumber, null, 1, null);
        boolean doublingDigit = true;
        int sum = 0;
        for (int index = condensedCardNumber.length() - 2; index >= 0; --index) {
            char character = condensedCardNumber.charAt(index);
            try {
                String string = String.valueOf(character);
                int intValueForCharacter = Integer.parseInt(string);
                int addedValue = intValueForCharacter * (doublingDigit ? 2 : 1);
                if (addedValue > 9) {
                    addedValue -= 9;
                }
                sum += addedValue;
            }
            catch (Exception exception) {
                return PaymentTypeInformationValidationResult.InvalidCharacters;
            }
            doublingDigit = !doublingDigit;
        }
        try {
            String string = String.valueOf(condensedCardNumber.charAt(condensedCardNumber.length() - 1));
            int checkDigitValue = Integer.parseInt(string);
            if ((sum + checkDigitValue) % 10 == 0) {
                return PaymentTypeInformationValidationResult.ValidChecksum;
            }
            return PaymentTypeInformationValidationResult.InvalidChecksum;
        }
        catch (Exception exception) {
            return PaymentTypeInformationValidationResult.InvalidCharacters;
        }
    }

    private PaymentTypeInformationValidator() {
    }

    static {
        PaymentTypeInformationValidator paymentTypeInformationValidator;
        INSTANCE = paymentTypeInformationValidator = new PaymentTypeInformationValidator();
        heidelpayIbanCharactersToConvert = heidelpayIbanCharactersToConvert;
    }
}

