/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc;

import com.heimuheimu.mysql.jdbc.net.SocketConfiguration;
import com.heimuheimu.mysql.jdbc.util.MysqlConnectionBuildUtil;
import com.heimuheimu.mysql.jdbc.util.StringUtil;
import java.net.MalformedURLException;
import java.util.Map;

public class ConnectionConfiguration {
    private final String host;
    private final String databaseName;
    private final String username;
    private final String password;
    private final int characterId;
    private final long capabilitiesFlags;
    private final int pingPeriod;
    private final SocketConfiguration socketConfiguration;

    public ConnectionConfiguration(String jdbcURL, String username, String password) throws IllegalArgumentException {
        try {
            Map<String, Object> properties = MysqlConnectionBuildUtil.parseURL(jdbcURL);
            this.host = (String)properties.get("host");
            this.databaseName = (String)properties.get("databaseName");
            this.username = username;
            this.password = password;
            this.characterId = (Integer)properties.getOrDefault("characterId", 45);
            this.capabilitiesFlags = (Long)properties.getOrDefault("capabilitiesFlags", 0L);
            this.pingPeriod = (Integer)properties.getOrDefault("pingPeriod", 30);
            this.socketConfiguration = null;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Create `ConnectionConfiguration` failed: `invalid jdbc url`. `jdbcURL`:`" + jdbcURL + "`.", e);
        }
    }

    public ConnectionConfiguration(String host, String databaseName, String username, String password) {
        this(host, databaseName, username, password, 45, 0L, 30, null);
    }

    public ConnectionConfiguration(String host, String databaseName, String username, String password, int characterId, long capabilitiesFlags, int pingPeriod, SocketConfiguration socketConfiguration) {
        this.host = host;
        this.databaseName = databaseName;
        this.username = username;
        this.password = password;
        this.characterId = characterId;
        this.capabilitiesFlags = capabilitiesFlags;
        this.pingPeriod = pingPeriod;
        this.socketConfiguration = socketConfiguration;
    }

    public String getHost() {
        return this.host;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getCharacterId() {
        return this.characterId;
    }

    public long getCapabilitiesFlags() {
        return this.capabilitiesFlags;
    }

    public int getPingPeriod() {
        return this.pingPeriod;
    }

    public SocketConfiguration getSocketConfiguration() {
        return this.socketConfiguration;
    }

    public String toString() {
        return "ConnectionConfiguration{host='" + this.host + '\'' + ", databaseName='" + this.databaseName + '\'' + ", username='" + this.username + '\'' + ", password='" + StringUtil.hidePassword(this.password) + '\'' + ", characterId=" + this.characterId + ", capabilitiesFlags=" + this.capabilitiesFlags + ", pingPeriod=" + this.pingPeriod + ", socketConfiguration=" + this.socketConfiguration + '}';
    }
}

