/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc;

import com.heimuheimu.mysql.jdbc.packet.CharsetMappingUtil;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionInfo.class);
    private final long connectionId;
    private final String serverVersion;
    private final int majorVersionNumber;
    private final int minorVersionNumber;
    private final int subMinorVersionNumber;
    private final int serverCharacterId;
    private final long serverCapabilitiesFlags;
    private final int serverStatusFlags;
    private final int characterId;
    private final long capabilitiesFlags;
    private final String databaseName;

    public ConnectionInfo(long connectionId, String serverVersion, int serverCharacterId, long serverCapabilitiesFlags, int serverStatusFlags, int characterId, long capabilitiesFlags, String databaseName) {
        this.connectionId = connectionId;
        this.serverVersion = serverVersion;
        this.serverCharacterId = serverCharacterId;
        this.serverCapabilitiesFlags = serverCapabilitiesFlags;
        this.serverStatusFlags = serverStatusFlags;
        this.characterId = characterId;
        this.capabilitiesFlags = capabilitiesFlags;
        this.databaseName = databaseName;
        int[] versionNumbers = this.parseServerVersion(serverVersion);
        this.majorVersionNumber = versionNumbers[0];
        this.minorVersionNumber = versionNumbers[1];
        this.subMinorVersionNumber = versionNumbers[2];
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public int getMajorVersionNumber() {
        return this.majorVersionNumber;
    }

    public int getMinorVersionNumber() {
        return this.minorVersionNumber;
    }

    public int getSubMinorVersionNumber() {
        return this.subMinorVersionNumber;
    }

    public int getServerCharacterId() {
        return this.serverCharacterId;
    }

    public long getServerCapabilitiesFlags() {
        return this.serverCapabilitiesFlags;
    }

    public int getServerStatusFlags() {
        return this.serverStatusFlags;
    }

    public int getCharacterId() {
        return this.characterId;
    }

    public Charset getJavaCharset() {
        return CharsetMappingUtil.getJavaCharset(this.characterId);
    }

    public long getCapabilitiesFlags() {
        return this.capabilitiesFlags;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean versionMeetsMinimum(int majorVersion, int minorVersion, int subMinorVersion) {
        if (this.majorVersionNumber > majorVersion) {
            return true;
        }
        if (this.majorVersionNumber == majorVersion) {
            if (this.minorVersionNumber > minorVersion) {
                return true;
            }
            if (this.minorVersionNumber == minorVersion) {
                return this.subMinorVersionNumber >= subMinorVersion;
            }
        }
        return false;
    }

    private int[] parseServerVersion(String serverVersion) {
        int majorVersionNumber = 0;
        int minorVersionNumber = 0;
        int subMinorVersionNumber = 0;
        try {
            int pointIndex = serverVersion.indexOf(46);
            if (pointIndex > 0) {
                majorVersionNumber = Integer.parseInt(serverVersion.substring(0, pointIndex));
                String remainingServerVersion = serverVersion.substring(pointIndex + 1);
                if ((pointIndex = remainingServerVersion.indexOf(46)) > 0) {
                    int digitLength;
                    minorVersionNumber = Integer.parseInt(remainingServerVersion.substring(0, pointIndex));
                    remainingServerVersion = remainingServerVersion.substring(pointIndex + 1);
                    for (digitLength = 0; digitLength < remainingServerVersion.length() && remainingServerVersion.charAt(digitLength) >= '0' && remainingServerVersion.charAt(digitLength) <= '9'; ++digitLength) {
                    }
                    if (digitLength > 0) {
                        subMinorVersionNumber = Integer.parseInt(remainingServerVersion.substring(0, digitLength));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Parse server version failed. `serverVersion`: `" + serverVersion + "`.", (Throwable)e);
        }
        return new int[]{majorVersionNumber, minorVersionNumber, subMinorVersionNumber};
    }

    public String toString() {
        return "ConnectionInfo{connectionId=" + this.connectionId + ", serverVersion='" + this.serverVersion + '\'' + ", majorVersionNumber=" + this.majorVersionNumber + ", minorVersionNumber=" + this.minorVersionNumber + ", subMinorVersionNumber=" + this.subMinorVersionNumber + ", serverCharacterId=" + this.serverCharacterId + ", serverCapabilitiesFlags=" + this.serverCapabilitiesFlags + ", serverStatusFlags=" + this.serverStatusFlags + ", characterId=" + this.characterId + ", capabilitiesFlags=" + this.capabilitiesFlags + ", databaseName='" + this.databaseName + '\'' + '}';
    }
}

