/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc;

import com.heimuheimu.mysql.jdbc.ConnectionConfiguration;
import com.heimuheimu.mysql.jdbc.ConnectionInfo;
import com.heimuheimu.mysql.jdbc.MysqlDatabaseMetaData;
import com.heimuheimu.mysql.jdbc.MysqlSavepoint;
import com.heimuheimu.mysql.jdbc.TextPreparedStatement;
import com.heimuheimu.mysql.jdbc.TextStatement;
import com.heimuheimu.mysql.jdbc.channel.MysqlChannel;
import com.heimuheimu.mysql.jdbc.command.MysqlServerStatusInfo;
import com.heimuheimu.mysql.jdbc.facility.SQLFeatureNotSupportedExceptionBuilder;
import com.heimuheimu.mysql.jdbc.facility.UnusableServiceNotifier;
import com.heimuheimu.mysql.jdbc.facility.parameter.ConstructorParameterChecker;
import com.heimuheimu.mysql.jdbc.facility.parameter.Parameters;
import com.heimuheimu.mysql.jdbc.monitor.DatabaseMonitor;
import com.heimuheimu.mysql.jdbc.monitor.DatabaseMonitorFactory;
import com.heimuheimu.mysql.jdbc.monitor.ExecutionMonitorFactory;
import com.heimuheimu.mysql.jdbc.net.BuildSocketException;
import com.heimuheimu.mysql.jdbc.util.LogBuildUtil;
import com.heimuheimu.naivemonitor.monitor.ExecutionMonitor;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlConnection
implements Connection {
    private static final Logger LOG = LoggerFactory.getLogger(MysqlConnection.class);
    protected final MysqlChannel mysqlChannel;
    protected volatile MysqlServerStatusInfo lastServerStatusInfo;
    protected final ExecutionMonitor executionMonitor;
    protected final DatabaseMonitor databaseMonitor;
    protected volatile long timeout;
    protected final long slowExecutionThreshold;
    protected volatile String currentDatabaseName;
    protected volatile int transactionIsolation = Integer.MIN_VALUE;
    protected volatile int readOnlyFlag = Integer.MIN_VALUE;

    public MysqlConnection(ConnectionConfiguration configuration, int timeout, int slowExecutionThreshold, UnusableServiceNotifier<MysqlConnection> unusableServiceNotifier) throws IllegalArgumentException, BuildSocketException {
        ConstructorParameterChecker checker = new ConstructorParameterChecker("MysqlConnection", LOG);
        checker.addParameter("configuration", configuration);
        checker.addParameter("timeout", timeout);
        checker.addParameter("slowExecutionThreshold", slowExecutionThreshold);
        checker.addParameter("unusableServiceNotifier", unusableServiceNotifier);
        checker.check("configuration", "isNull", Parameters::isNull);
        checker.check("timeout", "isLessThanZero", Parameters::isLessThanZero);
        checker.check("slowExecutionThreshold", "isEqualOrLessThanZero", Parameters::isEqualOrLessThanZero);
        this.mysqlChannel = new MysqlChannel(configuration, channel -> {
            if (unusableServiceNotifier != null) {
                unusableServiceNotifier.onClosed(this);
            }
        });
        this.mysqlChannel.init();
        this.lastServerStatusInfo = new MysqlServerStatusInfo(this.mysqlChannel.getConnectionInfo().getServerStatusFlags());
        this.executionMonitor = ExecutionMonitorFactory.get(configuration.getHost(), configuration.getDatabaseName());
        this.databaseMonitor = DatabaseMonitorFactory.get(configuration.getHost(), configuration.getDatabaseName());
        this.timeout = timeout;
        this.slowExecutionThreshold = TimeUnit.NANOSECONDS.convert(slowExecutionThreshold, TimeUnit.MILLISECONDS);
        this.currentDatabaseName = this.mysqlChannel.getConnectionInfo().getDatabaseName();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkClosed("setNetworkTimeout(Executor executor, int milliseconds)");
        this.timeout = milliseconds;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkClosed("getNetworkTimeout()");
        return this.timeout > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.timeout;
    }

    @Override
    public boolean isValid(int timeout) {
        return this.getMysqlChannel().isAvailable();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed("getMetaData()");
        return new MysqlDatabaseMetaData(this);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed("getSchema()");
        return this.currentDatabaseName != null ? this.currentDatabaseName : "";
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed("setSchema(String schema)");
        try (Statement statement = this.createStatement();){
            statement.execute("USE " + schema);
            this.currentDatabaseName = schema;
        }
        catch (Exception e) {
            this.executionMonitor.onError(-6);
            LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
            parameterMap.put("schema", schema);
            parameterMap.putAll(this.getCommonParameterMap());
            String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#setSchema(String schema)", "unexpected error", parameterMap);
            LOG.error(errorMessage, (Throwable)e);
            throw new SQLException(errorMessage, e);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed("createStatement()");
        TextStatement statement = new TextStatement(this, this.executionMonitor, this.databaseMonitor, this.slowExecutionThreshold);
        statement.setQueryMillisecondsTimeout(this.timeout);
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed("createStatement(int resultSetType, int resultSetConcurrency)");
        if (resultSetType != 1004 || resultSetConcurrency != 1007) {
            this.executionMonitor.onError(-6);
            LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
            parameterMap.put("resultSetType", resultSetType);
            parameterMap.put("resultSetConcurrency", resultSetConcurrency);
            parameterMap.putAll(this.getCommonParameterMap());
            String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#createStatement(int resultSetType, int resultSetConcurrency)", "invalid resultSetType or resultSetConcurrency", parameterMap);
            LOG.error(errorMessage);
            throw new SQLException(errorMessage);
        }
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed("prepareStatement(String sql)");
        TextPreparedStatement preparedStatement = new TextPreparedStatement(sql, this, this.executionMonitor, this.databaseMonitor, this.slowExecutionThreshold);
        preparedStatement.setQueryMillisecondsTimeout(this.timeout);
        return preparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed("prepareStatement(String sql, int autoGeneratedKeys)");
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed("prepareStatement(String sql, int resultSetType, int resultSetConcurrency)");
        if (resultSetType != 1004 || resultSetConcurrency != 1007) {
            this.executionMonitor.onError(-6);
            LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
            parameterMap.put("resultSetType", resultSetType);
            parameterMap.put("resultSetConcurrency", resultSetConcurrency);
            parameterMap.putAll(this.getCommonParameterMap());
            String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#prepareStatement(String sql, int resultSetType, int resultSetConcurrency)", "invalid resultSetType or resultSetConcurrency", parameterMap);
            LOG.error(errorMessage);
            throw new SQLException(errorMessage);
        }
        return this.prepareStatement(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed("nativeSQL(String sql)");
        return sql;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed("getAutoCommit()");
        return this.lastServerStatusInfo.isAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed("setAutoCommit(boolean autoCommit)");
        boolean currentIsAutoCommit = this.getAutoCommit();
        if (autoCommit != currentIsAutoCommit) {
            try (Statement statement = this.createStatement();){
                if (autoCommit) {
                    statement.execute("SET autocommit=1");
                } else {
                    statement.execute("SET autocommit=0");
                }
            }
            catch (Exception e) {
                this.executionMonitor.onError(-6);
                LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
                parameterMap.put("autoCommit", autoCommit);
                parameterMap.putAll(this.getCommonParameterMap());
                String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#setAutoCommit(boolean autoCommit)", "unexpected error", parameterMap);
                LOG.error(errorMessage, (Throwable)e);
                throw new SQLException(errorMessage, e);
            }
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed("isReadOnly()");
        if (this.mysqlChannel.getConnectionInfo().versionMeetsMinimum(5, 6, 5)) {
            if (this.readOnlyFlag == Integer.MIN_VALUE) {
                ConnectionInfo connection = this.mysqlChannel.getConnectionInfo();
                String variableName = connection.versionMeetsMinimum(8, 0, 3) || connection.versionMeetsMinimum(5, 7, 20) && !connection.versionMeetsMinimum(8, 0, 0) ? "@@session.transaction_read_only" : "@@session.tx_read_only";
                int transactionReadOnly = -1;
                try (Statement statement = this.createStatement();
                     ResultSet resultSet = statement.executeQuery("SELECT " + variableName);){
                    if (resultSet.next()) {
                        transactionReadOnly = resultSet.getInt(1);
                    }
                }
                catch (Exception e) {
                    this.executionMonitor.onError(-6);
                    String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#isReadOnly()", "unexpected error", this.getCommonParameterMap());
                    LOG.error(errorMessage, (Throwable)e);
                    throw new SQLException(errorMessage, e);
                }
                switch (transactionReadOnly) {
                    case 0: {
                        this.readOnlyFlag = 0;
                        break;
                    }
                    case 1: {
                        this.readOnlyFlag = 1;
                        break;
                    }
                    default: {
                        this.executionMonitor.onError(-6);
                        String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#isReadOnly()", "Could not map read-only flag '" + transactionReadOnly + "'", this.getCommonParameterMap());
                        LOG.error(errorMessage);
                        throw new SQLException(errorMessage);
                    }
                }
            }
            return this.readOnlyFlag == 1;
        }
        return false;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed("setReadOnly(boolean readOnly)");
        boolean currentIsReadOnly = this.isReadOnly();
        if (readOnly != currentIsReadOnly) {
            if (this.mysqlChannel.getConnectionInfo().versionMeetsMinimum(5, 6, 5)) {
                try (Statement statement = this.createStatement();){
                    if (readOnly) {
                        statement.execute("SET SESSION TRANSACTION READ ONLY");
                        this.readOnlyFlag = 1;
                    }
                    statement.execute("SET SESSION TRANSACTION READ WRITE");
                    this.readOnlyFlag = 0;
                }
                catch (Exception e) {
                    this.executionMonitor.onError(-6);
                    LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
                    parameterMap.put("readOnly", readOnly);
                    parameterMap.putAll(this.getCommonParameterMap());
                    String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#setReadOnly(boolean readOnly)", "unexpected error", parameterMap);
                    LOG.error(errorMessage, (Throwable)e);
                    throw new SQLException(errorMessage, e);
                }
            } else if (readOnly) {
                this.executionMonitor.onError(-6);
                LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
                parameterMap.put("readOnly", true);
                parameterMap.putAll(this.getCommonParameterMap());
                String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#setReadOnly(boolean readOnly)", "mysql version too low, minimal version: 5.6.5", parameterMap);
                LOG.error(errorMessage);
                throw new SQLException(errorMessage);
            }
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed("getTransactionIsolation()");
        if (this.transactionIsolation == Integer.MIN_VALUE) {
            ConnectionInfo connection = this.mysqlChannel.getConnectionInfo();
            String variableName = connection.versionMeetsMinimum(8, 0, 3) || connection.versionMeetsMinimum(5, 7, 20) && !connection.versionMeetsMinimum(8, 0, 0) ? "@@session.transaction_isolation" : "@@session.tx_isolation";
            String transactionIsolationName = "";
            try (Statement statement = this.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT " + variableName);){
                if (resultSet.next()) {
                    transactionIsolationName = resultSet.getString(1);
                }
            }
            catch (Exception e) {
                this.executionMonitor.onError(-6);
                String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#getTransactionIsolation()", "unexpected error", this.getCommonParameterMap());
                LOG.error(errorMessage, (Throwable)e);
                throw new SQLException(errorMessage, e);
            }
            switch (transactionIsolationName) {
                case "READ-UNCOMMITED": 
                case "READ-UNCOMMITTED": {
                    this.transactionIsolation = 1;
                    break;
                }
                case "READ-COMMITTED": {
                    this.transactionIsolation = 2;
                    break;
                }
                case "REPEATABLE-READ": {
                    this.transactionIsolation = 4;
                    break;
                }
                case "SERIALIZABLE": {
                    this.transactionIsolation = 8;
                    break;
                }
                default: {
                    this.executionMonitor.onError(-6);
                    String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#getTransactionIsolation()", "Could not map transaction isolation '" + transactionIsolationName + "' to a valid JDBC level", this.getCommonParameterMap());
                    LOG.error(errorMessage);
                    throw new SQLException(errorMessage);
                }
            }
        }
        return this.transactionIsolation;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed("setTransactionIsolation(int level)");
        if (level != this.transactionIsolation) {
            String sql;
            switch (level) {
                case 2: {
                    sql = "SET SESSION TRANSACTION ISOLATION LEVEL READ COMMITTED";
                    break;
                }
                case 1: {
                    sql = "SET SESSION TRANSACTION ISOLATION LEVEL READ UNCOMMITTED";
                    break;
                }
                case 4: {
                    sql = "SET SESSION TRANSACTION ISOLATION LEVEL REPEATABLE READ";
                    break;
                }
                case 8: {
                    sql = "SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE";
                    break;
                }
                default: {
                    this.executionMonitor.onError(-6);
                    LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
                    parameterMap.put("level", level);
                    parameterMap.putAll(this.getCommonParameterMap());
                    String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#setTransactionIsolation(int level)", "unsupported transaction isolation level '" + level + "'", parameterMap);
                    LOG.error(errorMessage);
                    throw new SQLException(errorMessage);
                }
            }
            try (Statement statement = this.createStatement();){
                statement.execute(sql);
            }
            catch (Exception e) {
                this.transactionIsolation = Integer.MIN_VALUE;
                this.executionMonitor.onError(-6);
                LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
                parameterMap.put("level", level);
                parameterMap.put("sql", sql);
                parameterMap.putAll(this.getCommonParameterMap());
                String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#setTransactionIsolation(int level)", "unexpected error", parameterMap);
                LOG.error(errorMessage, (Throwable)e);
                throw new SQLException(errorMessage, e);
            }
            this.transactionIsolation = level;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        String randomSavepointName = UUID.randomUUID().toString().replace("-", "");
        return this.setSavepoint(randomSavepointName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        String methodName = "setSavepoint(String name)";
        this.checkClosed(methodName);
        MysqlSavepoint savepoint = new MysqlSavepoint(name);
        this.checkSavepointName(methodName, savepoint);
        this.checkInAutoCommitMode(methodName, name);
        try (Statement statement = this.createStatement();){
            statement.execute("SAVEPOINT `" + name + "`");
            MysqlSavepoint mysqlSavepoint = savepoint;
            return mysqlSavepoint;
        }
        catch (Exception e) {
            this.executionMonitor.onError(-6);
            LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
            parameterMap.put("savepointName", name);
            parameterMap.putAll(this.getCommonParameterMap());
            String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#setSavepoint(String name)", "unexpected error", parameterMap);
            LOG.error(errorMessage, (Throwable)e);
            throw new SQLException(errorMessage, e);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        String methodName = "rollback(Savepoint savepoint)";
        this.checkClosed(methodName);
        this.checkSavepointName(methodName, savepoint);
        this.checkInAutoCommitMode(methodName, savepoint.getSavepointName());
        try (Statement statement = this.createStatement();){
            statement.execute("ROLLBACK TO SAVEPOINT `" + savepoint.getSavepointName() + "`");
        }
        catch (Exception e) {
            this.executionMonitor.onError(-6);
            LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
            parameterMap.put("savepointName", savepoint.getSavepointName());
            parameterMap.putAll(this.getCommonParameterMap());
            String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#rollback(Savepoint savepoint)", "unexpected error", parameterMap);
            LOG.error(errorMessage, (Throwable)e);
            throw new SQLException(errorMessage, e);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        String methodName = "releaseSavepoint(Savepoint savepoint)";
        this.checkClosed(methodName);
        this.checkSavepointName(methodName, savepoint);
        this.checkInAutoCommitMode(methodName, savepoint.getSavepointName());
        try (Statement statement = this.createStatement();){
            statement.execute("RELEASE SAVEPOINT `" + savepoint.getSavepointName() + "`");
        }
        catch (Exception e) {
            this.executionMonitor.onError(-6);
            LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
            parameterMap.put("savepointName", savepoint.getSavepointName());
            parameterMap.putAll(this.getCommonParameterMap());
            String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#releaseSavepoint(Savepoint savepoint)", "unexpected error", parameterMap);
            LOG.error(errorMessage, (Throwable)e);
            throw new SQLException(errorMessage, e);
        }
    }

    private void checkSavepointName(String methodName, Savepoint savepoint) throws SQLException {
        String savepointName = null;
        if (savepoint != null) {
            savepointName = savepoint.getSavepointName();
        }
        if (savepointName == null || savepointName.isEmpty()) {
            this.executionMonitor.onError(-6);
            LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
            parameterMap.put("savepointName", savepointName);
            parameterMap.putAll(this.getCommonParameterMap());
            String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#" + methodName, "savepoint name could not be empty", parameterMap);
            LOG.error(errorMessage);
            throw new SQLException(errorMessage);
        }
    }

    private void checkInAutoCommitMode(String methodName, String savepointName) throws SQLException {
        if (this.lastServerStatusInfo.isAutoCommit()) {
            this.executionMonitor.onError(-6);
            LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
            parameterMap.put("savepointName", savepointName);
            parameterMap.putAll(this.getCommonParameterMap());
            String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#" + methodName, "connection object is currently in auto-commit mode", parameterMap);
            LOG.error(errorMessage);
            throw new SQLException(errorMessage);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed("commit()");
        try (Statement statement = this.createStatement();){
            statement.execute("COMMIT");
        }
        catch (Exception e) {
            this.executionMonitor.onError(-6);
            String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#commit()", "unexpected error", this.getCommonParameterMap());
            LOG.error(errorMessage, (Throwable)e);
            throw new SQLException(errorMessage, e);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed("rollback()");
        try (Statement statement = this.createStatement();){
            statement.execute("ROLLBACK");
        }
        catch (Exception e) {
            this.executionMonitor.onError(-6);
            String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#rollback()", "unexpected error", this.getCommonParameterMap());
            LOG.error(errorMessage, (Throwable)e);
            throw new SQLException(errorMessage, e);
        }
    }

    @Override
    public void abort(Executor executor) {
        this.close();
    }

    @Override
    public void close() {
        this.mysqlChannel.close();
    }

    @Override
    public boolean isClosed() {
        return !this.mysqlChannel.isAvailable();
    }

    @Override
    public void setCatalog(String catalog) {
    }

    @Override
    public String getCatalog() {
        return "def";
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void setClientInfo(String name, String value) {
    }

    @Override
    public void setClientInfo(Properties properties) {
    }

    @Override
    public String getClientInfo(String name) {
        return null;
    }

    @Override
    public Properties getClientInfo() {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return MysqlConnection.class == iface;
    }

    public MysqlChannel getMysqlChannel() {
        return this.mysqlChannel;
    }

    public MysqlServerStatusInfo getLastServerStatusInfo() {
        return this.lastServerStatusInfo;
    }

    public void setLastServerStatusInfo(MysqlServerStatusInfo lastServerStatusInfo) {
        this.lastServerStatusInfo = lastServerStatusInfo;
    }

    public String toString() {
        return "MysqlConnection{mysqlChannel=" + this.mysqlChannel + ", lastServerStatusInfo=" + this.lastServerStatusInfo + ", executionMonitor=" + this.executionMonitor + ", databaseMonitor=" + this.databaseMonitor + ", timeout=" + this.timeout + ", slowExecutionThreshold=" + this.slowExecutionThreshold + ", currentDatabaseName='" + this.currentDatabaseName + '\'' + ", transactionIsolation=" + this.transactionIsolation + ", readOnlyFlag=" + this.readOnlyFlag + '}';
    }

    private void checkClosed(String methodName) throws SQLException {
        if (this.isClosed()) {
            this.executionMonitor.onError(-2);
            Map<String, Object> parameterMap = this.getCommonParameterMap();
            String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlConnection#" + methodName, "Mysql connection is closed", parameterMap);
            LOG.error(errorMessage);
            throw new SQLException(errorMessage);
        }
    }

    private Map<String, Object> getCommonParameterMap() {
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        parameterMap.put("timeout", this.timeout);
        parameterMap.put("slowExecutionThreshold", this.slowExecutionThreshold);
        parameterMap.put("mysqlChannel", this.mysqlChannel);
        return parameterMap;
    }

    @Override
    public Clob createClob() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#createClob()");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#createBlob()");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#createNClob()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#createSQLXML()");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#createArrayOf(String typeName, Object[] elements)");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#createStruct(String typeName, Object[] attributes)");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#setHoldability(int holdability)");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#getHoldability()");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#prepareStatement(String sql, int[] columnIndexes)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#prepareStatement(String sql, String[] columnNames)");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#prepareCall(String sql)");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#prepareCall(String sql, int resultSetType, int resultSetConcurrency)");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#getTypeMap()");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlConnection#setTypeMap(Map<String, Class<?>> map)");
    }
}

