/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc;

import com.heimuheimu.mysql.jdbc.facility.SQLFeatureNotSupportedExceptionBuilder;
import com.heimuheimu.mysql.jdbc.util.LogBuildUtil;
import com.heimuheimu.mysql.jdbc.util.MysqlConnectionBuildUtil;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlDriver
implements Driver {
    private static final Logger LOG = LoggerFactory.getLogger(MysqlDriver.class);

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (this.acceptsURL(url)) {
            try {
                return MysqlConnectionBuildUtil.build(url, info);
            }
            catch (Exception e) {
                LinkedHashMap<String, Object> parametersMap = new LinkedHashMap<String, Object>();
                parametersMap.put("url", url);
                parametersMap.put("info", info);
                String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlDriver#connect(String url, Properties info)", "get mysql connection failed", parametersMap);
                LOG.error(errorMessage, (Throwable)e);
                throw new SQLException(errorMessage, e);
            }
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) {
        return MysqlConnectionBuildUtil.acceptsURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlDriver#getParentLogger()");
    }

    static {
        try {
            DriverManager.registerDriver(new MysqlDriver());
        }
        catch (SQLException e) {
            throw new UnsupportedOperationException("Could not register `MysqlDriver`.", e);
        }
    }
}

