/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc;

import com.heimuheimu.mysql.jdbc.util.LogBuildUtil;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlSavepoint
implements Savepoint {
    private static final Logger LOG = LoggerFactory.getLogger(MysqlSavepoint.class);
    private final String savepointName;

    public MysqlSavepoint(String savepointName) {
        this.savepointName = savepointName;
    }

    @Override
    public int getSavepointId() throws SQLException {
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        parameterMap.put("savepointName", this.savepointName);
        String errorMessage = LogBuildUtil.buildMethodExecuteFailedLog("MysqlSavepoint#getSavepointId()", "this is a named savepoint", parameterMap);
        LOG.error(errorMessage);
        throw new SQLException(errorMessage);
    }

    @Override
    public String getSavepointName() {
        return this.savepointName;
    }

    public String toString() {
        return "MysqlSavepoint{savepointName='" + this.savepointName + '\'' + '}';
    }
}

