/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc;

import com.heimuheimu.mysql.jdbc.MysqlConnection;
import com.heimuheimu.mysql.jdbc.TextStatement;
import com.heimuheimu.mysql.jdbc.facility.SQLFeatureNotSupportedExceptionBuilder;
import com.heimuheimu.mysql.jdbc.monitor.DatabaseMonitor;
import com.heimuheimu.mysql.jdbc.util.BytesUtil;
import com.heimuheimu.mysql.jdbc.util.LogBuildUtil;
import com.heimuheimu.mysql.jdbc.util.StringUtil;
import com.heimuheimu.naivemonitor.monitor.ExecutionMonitor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextPreparedStatement
extends TextStatement
implements PreparedStatement {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSS");
    private static final long MYSQL_MIN_TIME = -30609705600000L;
    private static final long MYSQL_MAX_TIME = 253402214399000L;
    private static final Logger LOG = LoggerFactory.getLogger(TextPreparedStatement.class);
    private static final String NULL_VALUE = "NULL";
    private final String sqlTemplate;
    private final List<String> sqlParts;
    private final AtomicReferenceArray<String> parameterValues;

    public TextPreparedStatement(String sqlTemplate, MysqlConnection mysqlConnection, ExecutionMonitor executionMonitor, DatabaseMonitor databaseMonitor, long slowExecutionThreshold) {
        super(mysqlConnection, executionMonitor, databaseMonitor, slowExecutionThreshold);
        this.sqlTemplate = sqlTemplate;
        this.sqlParts = this.parseSqlTemplate(sqlTemplate);
        this.parameterValues = new AtomicReferenceArray(this.sqlParts.size() - 1);
    }

    private List<String> parseSqlTemplate(String sqlTemplate) {
        int questionMarkIndex;
        ArrayList<String> sqlParts = new ArrayList<String>();
        int fromIndex = 0;
        while ((questionMarkIndex = sqlTemplate.indexOf("?", fromIndex)) != -1) {
            sqlParts.add(sqlTemplate.substring(fromIndex, questionMarkIndex));
            fromIndex = questionMarkIndex + 1;
        }
        if (fromIndex < sqlTemplate.length()) {
            sqlParts.add(sqlTemplate.substring(fromIndex));
        } else {
            sqlParts.add("");
        }
        return sqlParts;
    }

    private String buildSql() throws SQLException {
        StringBuilder buffer = new StringBuilder(256);
        for (int i = 0; i < this.sqlParts.size() - 1; ++i) {
            buffer.append(this.sqlParts.get(i));
            String parameterValue = this.parameterValues.get(i);
            if (parameterValue == null) {
                this.executionMonitor.onError(-4);
                String errorMessage = this.buildSetParameterErrorMessage("buildSql()", i + 1, null, "build sql failed, parameter value has not been set", null);
                LOG.error(errorMessage);
                throw new SQLException(errorMessage);
            }
            buffer.append(parameterValue);
        }
        buffer.append(this.sqlParts.get(this.sqlParts.size() - 1));
        return buffer.toString();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkParameterIndex("setNull(int parameterIndex, int sqlType)", parameterIndex, null);
        this.parameterValues.set(parameterIndex - 1, NULL_VALUE);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkParameterIndex("setNull(int parameterIndex, int sqlType, String typeName)", parameterIndex, null);
        this.parameterValues.set(parameterIndex - 1, NULL_VALUE);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkParameterIndex("setBoolean(int parameterIndex, boolean x)", parameterIndex, x);
        this.parameterValues.set(parameterIndex - 1, x ? "1" : "0");
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkParameterIndex("setByte(int parameterIndex, byte x)", parameterIndex, x);
        String hex = BytesUtil.toHex(new byte[]{x});
        this.parameterValues.set(parameterIndex - 1, "X'" + hex + "'");
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkParameterIndex("setBytes(int parameterIndex, byte[] x)", parameterIndex, x);
        if (x != null) {
            String hex = BytesUtil.toHex(x);
            this.parameterValues.set(parameterIndex - 1, "X'" + hex + "'");
        } else {
            this.parameterValues.set(parameterIndex - 1, NULL_VALUE);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkParameterIndex("setShort(int parameterIndex, short x)", parameterIndex, x);
        this.parameterValues.set(parameterIndex - 1, String.valueOf(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkParameterIndex("setInt(int parameterIndex, int x)", parameterIndex, x);
        this.parameterValues.set(parameterIndex - 1, String.valueOf(x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkParameterIndex("setLong(int parameterIndex, long x)", parameterIndex, x);
        this.parameterValues.set(parameterIndex - 1, String.valueOf(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkParameterIndex("setFloat(int parameterIndex, float x)", parameterIndex, Float.valueOf(x));
        this.parameterValues.set(parameterIndex - 1, String.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkParameterIndex("setDouble(int parameterIndex, double x)", parameterIndex, x);
        this.parameterValues.set(parameterIndex - 1, String.valueOf(x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkParameterIndex("setBigDecimal(int parameterIndex, BigDecimal x)", parameterIndex, x);
        if (x != null) {
            this.parameterValues.set(parameterIndex - 1, x.toPlainString());
        } else {
            this.parameterValues.set(parameterIndex - 1, NULL_VALUE);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkParameterIndex("setString(int parameterIndex, String x)", parameterIndex, x);
        if (x != null) {
            this.parameterValues.set(parameterIndex - 1, "'" + StringUtil.escape(x) + "'");
        } else {
            this.parameterValues.set(parameterIndex - 1, NULL_VALUE);
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkParameterIndex("setURL(int parameterIndex, URL x)", parameterIndex, x);
        if (x != null) {
            this.parameterValues.set(parameterIndex - 1, "'" + StringUtil.escape(x.toString()) + "'");
        } else {
            this.parameterValues.set(parameterIndex - 1, NULL_VALUE);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, Calendar.getInstance());
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        String methodName = "setDate(int parameterIndex, Date x, Calendar cal)";
        this.checkParameterIndex(methodName, parameterIndex, x);
        if (x != null) {
            try {
                if (cal == null) {
                    cal = Calendar.getInstance();
                }
                cal.setTimeInMillis(this.getSafeTime(x));
                LocalDateTime ldt = LocalDateTime.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId());
                this.parameterValues.set(parameterIndex - 1, "'" + ldt.format(DATE_FORMATTER) + "'");
            }
            catch (Exception e) {
                this.executionMonitor.onError(-4);
                Calendar finalCal = cal;
                String errorMessage = this.buildSetParameterErrorMessage(methodName, parameterIndex, x, "set date parameter failed", parameterMap -> parameterMap.put("calendar", finalCal));
                LOG.error(errorMessage, (Throwable)e);
                throw new SQLException(errorMessage, e);
            }
        } else {
            this.parameterValues.set(parameterIndex - 1, NULL_VALUE);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, Calendar.getInstance());
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        String methodName = "setTime(int parameterIndex, Time x, Calendar cal)";
        this.checkParameterIndex(methodName, parameterIndex, x);
        if (x != null) {
            try {
                if (cal == null) {
                    cal = Calendar.getInstance();
                }
                cal.setTimeInMillis(this.getSafeTime(x));
                LocalDateTime ldt = LocalDateTime.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId());
                this.parameterValues.set(parameterIndex - 1, "'" + ldt.format(TIME_FORMATTER) + "'");
            }
            catch (Exception e) {
                this.executionMonitor.onError(-4);
                Calendar finalCal = cal;
                String errorMessage = this.buildSetParameterErrorMessage(methodName, parameterIndex, x, "set time parameter failed", parameterMap -> parameterMap.put("calendar", finalCal));
                LOG.error(errorMessage, (Throwable)e);
                throw new SQLException(errorMessage, e);
            }
        } else {
            this.parameterValues.set(parameterIndex - 1, NULL_VALUE);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, Calendar.getInstance());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        String methodName = "setTimestamp(int parameterIndex, Timestamp x, Calendar cal)";
        this.checkParameterIndex(methodName, parameterIndex, x);
        if (x != null) {
            try {
                if (cal == null) {
                    cal = Calendar.getInstance();
                }
                cal.setTimeInMillis(this.getSafeTime(x));
                LocalDateTime ldt = LocalDateTime.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId());
                this.parameterValues.set(parameterIndex - 1, "'" + ldt.format(TIMESTAMP_FORMATTER) + "'");
            }
            catch (Exception e) {
                this.executionMonitor.onError(-4);
                Calendar finalCal = cal;
                String errorMessage = this.buildSetParameterErrorMessage(methodName, parameterIndex, x, "set timestamp parameter failed", parameterMap -> parameterMap.put("calendar", finalCal));
                LOG.error(errorMessage, (Throwable)e);
                throw new SQLException(errorMessage, e);
            }
        } else {
            this.parameterValues.set(parameterIndex - 1, NULL_VALUE);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setAsciiStream(parameterIndex, x, -1);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (int)length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setInputStreamByName("AsciiStream", parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x, -1);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (int)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setInputStreamByName("BinaryStream", parameterIndex, x, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setInputStreamByName("UnicodeStream", parameterIndex, x, length);
    }

    private void setInputStreamByName(String streamName, int parameterIndex, InputStream x, int length) throws SQLException {
        String methodName = "set" + streamName + "(int parameterIndex, InputStream x, int length)";
        this.checkParameterIndex(methodName, parameterIndex, x);
        if (x != null) {
            try {
                byte[] bytes = this.readBytesFromInputStream(x, length);
                String hex = BytesUtil.toHex(bytes);
                this.parameterValues.set(parameterIndex - 1, "X'" + hex + "'");
            }
            catch (Exception e) {
                this.executionMonitor.onError(-4);
                String errorMessage = this.buildSetParameterErrorMessage(methodName, parameterIndex, x, "set " + streamName + " parameter failed", parameterMap -> parameterMap.put("length", length));
                LOG.error(errorMessage, (Throwable)e);
                throw new SQLException(errorMessage, e);
            }
        } else {
            this.parameterValues.set(parameterIndex - 1, NULL_VALUE);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, -1);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setReaderByName("CharacterStream", parameterIndex, reader, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setNCharacterStream(parameterIndex, value, -1L);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setReaderByName("NCharacterStream", parameterIndex, value, (int)length);
    }

    private void setReaderByName(String streamName, int parameterIndex, Reader reader, int length) throws SQLException {
        String methodName = "set" + streamName + "(int parameterIndex, Reader reader, int length)";
        this.checkParameterIndex(methodName, parameterIndex, reader);
        if (reader != null) {
            try {
                String value = this.readStringFromReader(reader, length);
                this.parameterValues.set(parameterIndex - 1, "'" + StringUtil.escape(value) + "'");
            }
            catch (Exception e) {
                this.executionMonitor.onError(-4);
                String errorMessage = this.buildSetParameterErrorMessage(methodName, parameterIndex, reader, "set " + streamName + " parameter failed", parameterMap -> parameterMap.put("length", length));
                LOG.error(errorMessage, (Throwable)e);
                throw new SQLException(errorMessage, e);
            }
        } else {
            this.parameterValues.set(parameterIndex - 1, NULL_VALUE);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        String methodName = "setObject(int parameterIndex, Object x)";
        this.checkParameterIndex(methodName, parameterIndex, x);
        if (x == null) {
            this.setNull(parameterIndex, 0);
            return;
        }
        if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
            return;
        }
        if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
            return;
        }
        if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
            return;
        }
        if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
            return;
        }
        if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
            return;
        }
        if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
            return;
        }
        if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
            return;
        }
        if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
            return;
        }
        if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
            return;
        }
        if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
            return;
        }
        if (x instanceof URL) {
            this.setURL(parameterIndex, (URL)x);
            return;
        }
        if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
            return;
        }
        if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
            return;
        }
        if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
            return;
        }
        if (x instanceof java.util.Date) {
            Timestamp t = new Timestamp(((java.util.Date)x).getTime());
            this.setTimestamp(parameterIndex, t);
            return;
        }
        if (x instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)x);
            return;
        }
        if (x instanceof Reader) {
            this.setCharacterStream(parameterIndex, (Reader)x);
            return;
        }
        this.executionMonitor.onError(-4);
        String errorMessage = this.buildSetParameterErrorMessage(methodName, parameterIndex, x, "set object parameter failed, unsupported java type", null);
        LOG.error(errorMessage);
        throw new SQLException(errorMessage);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void clearParameters() {
        for (int i = 0; i < this.parameterValues.length(); ++i) {
            this.parameterValues.set(i, null);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() {
        if (this.resultSet != null) {
            return this.resultSet.getMetaData();
        }
        return null;
    }

    @Override
    public boolean execute() throws SQLException {
        String sql = this.buildSql();
        return this.execute(sql);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        String sql = this.buildSql();
        return this.executeQuery(sql);
    }

    @Override
    public int executeUpdate() throws SQLException {
        String sql = this.buildSql();
        return this.executeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        String sql = this.buildSql();
        return this.executeLargeUpdate(sql);
    }

    private void checkParameterIndex(String methodName, int parameterIndex, Object parameterValue) throws SQLException {
        if (parameterIndex <= 0 || parameterIndex > this.parameterValues.length()) {
            this.executionMonitor.onError(-4);
            String errorMessage = this.buildSetParameterErrorMessage(methodName, parameterIndex, parameterValue, "parameter index out of range", null);
            LOG.error(errorMessage);
            throw new SQLException(errorMessage);
        }
    }

    private String buildSetParameterErrorMessage(String methodName, int parameterIndex, Object parameterValue, String desc, Consumer<Map<String, Object>> parameterMapConsumer) {
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        parameterMap.put("parameterIndex", parameterIndex);
        parameterMap.put("parameterValue", parameterValue);
        if (parameterMapConsumer != null) {
            parameterMapConsumer.accept(parameterMap);
        }
        parameterMap.put("sqlTemplate", this.sqlTemplate);
        parameterMap.put("parameterValues", this.parameterValues);
        parameterMap.put("mysqlChannel", this.mysqlChannel);
        return LogBuildUtil.buildMethodExecuteFailedLog("TextPreparedStatement#" + methodName, desc, parameterMap);
    }

    private long getSafeTime(java.util.Date date) {
        long time = date.getTime();
        if (time > 253402214399000L) {
            time = 253402214399000L;
        } else if (time < -30609705600000L) {
            time = -30609705600000L;
        }
        return time;
    }

    private byte[] readBytesFromInputStream(InputStream inputStream, int length) throws IOException {
        int count;
        int remainCount;
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int n = remainCount = length < 0 ? Integer.MAX_VALUE : length;
        while ((count = inputStream.read(buffer)) != -1) {
            os.write(buffer, 0, Math.min(count, remainCount));
            if ((remainCount -= count) > 0) continue;
            break;
        }
        return os.toByteArray();
    }

    private String readStringFromReader(Reader reader, int length) throws IOException {
        int count;
        int remainCount;
        StringBuilder builder = new StringBuilder(1024);
        char[] buffer = new char[1024];
        int n = remainCount = length < 0 ? Integer.MAX_VALUE : length;
        while ((count = reader.read(buffer)) != -1) {
            builder.append(buffer, 0, Math.min(count, remainCount));
            if ((remainCount -= count) > 0) continue;
            break;
        }
        return builder.toString();
    }

    @Override
    public void addBatch() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextPreparedStatement#addBatch()", "mysql-jdbc does not support batch statements.");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextPreparedStatement#setRef(int parameterIndex, Ref x)");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextPreparedStatement#setBlob(int parameterIndex, Blob x)");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextPreparedStatement#setBlob(int parameterIndex, InputStream inputStream)");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextPreparedStatement#setBlob(int parameterIndex, InputStream inputStream, long length)");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextPreparedStatement#setClob(int parameterIndex, Clob x)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextPreparedStatement#setClob(int parameterIndex, Reader reader)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextPreparedStatement#setClob(int parameterIndex, Reader reader, long length)");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextPreparedStatement#setNClob(int parameterIndex, NClob value)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextPreparedStatement#setNClob(int parameterIndex, Reader reader)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextPreparedStatement#setNClob(int parameterIndex, Reader reader, long length)");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextPreparedStatement#setArray(int parameterIndex, Array x)");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextPreparedStatement#setRowId(int parameterIndex, RowId x)");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextPreparedStatement#setSQLXML(int parameterIndex, SQLXML xmlObject)");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextPreparedStatement#getParameterMetaData()");
    }
}

