/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc;

import com.heimuheimu.mysql.jdbc.ConnectionInfo;
import com.heimuheimu.mysql.jdbc.MysqlConnection;
import com.heimuheimu.mysql.jdbc.channel.MysqlChannel;
import com.heimuheimu.mysql.jdbc.command.SQLCommand;
import com.heimuheimu.mysql.jdbc.facility.SQLFeatureNotSupportedExceptionBuilder;
import com.heimuheimu.mysql.jdbc.monitor.DatabaseMonitor;
import com.heimuheimu.mysql.jdbc.result.AutoGenerateKeysResultSet;
import com.heimuheimu.mysql.jdbc.result.ReadonlyTextResultSet;
import com.heimuheimu.mysql.jdbc.util.SQLUtil;
import com.heimuheimu.naivemonitor.monitor.ExecutionMonitor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextStatement
implements Statement {
    private static final Logger LOG = LoggerFactory.getLogger(TextStatement.class);
    private static final Logger MYSQL_SLOW_EXECUTION_LOG = LoggerFactory.getLogger((String)"MYSQL_SLOW_EXECUTION_LOG");
    private static final Logger MYSQL_EXECUTION_DEBUG_LOG = LoggerFactory.getLogger((String)"MYSQL_EXECUTION_DEBUG_LOG");
    protected final MysqlConnection mysqlConnection;
    protected final MysqlChannel mysqlChannel;
    protected final ConnectionInfo connectionInfo;
    protected final ExecutionMonitor executionMonitor;
    protected volatile ReadonlyTextResultSet resultSet = null;
    private final long slowExecutionThreshold;
    private volatile long queryMillisecondsTimeout = Long.MAX_VALUE;
    private volatile long affectedRows = -1L;
    private volatile long lastInsertId = -1L;
    private volatile int fetchDirection = 1000;
    private final DatabaseMonitor databaseMonitor;

    public TextStatement(MysqlConnection mysqlConnection, ExecutionMonitor executionMonitor, DatabaseMonitor databaseMonitor, long slowExecutionThreshold) {
        this.mysqlConnection = mysqlConnection;
        this.mysqlChannel = mysqlConnection.getMysqlChannel();
        this.connectionInfo = mysqlConnection.getMysqlChannel().getConnectionInfo();
        this.executionMonitor = executionMonitor;
        this.databaseMonitor = databaseMonitor;
        this.slowExecutionThreshold = slowExecutionThreshold;
    }

    @Override
    public long getLargeMaxRows() {
        return 0L;
    }

    @Override
    public int getMaxRows() {
        return 0;
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public int getQueryTimeout() {
        if (this.queryMillisecondsTimeout == Long.MAX_VALUE) {
            return 0;
        }
        long seconds = this.queryMillisecondsTimeout / 1000L;
        int intSeconds = seconds > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)seconds;
        return Math.max(1, intSeconds);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.setQueryMillisecondsTimeout((long)seconds * 1000L);
    }

    public long getQueryMillisecondsTimeout() {
        return this.queryMillisecondsTimeout;
    }

    public void setQueryMillisecondsTimeout(long queryMillisecondsTimeout) throws SQLException {
        if (queryMillisecondsTimeout > 0L) {
            this.queryMillisecondsTimeout = queryMillisecondsTimeout;
        } else if (queryMillisecondsTimeout == 0L) {
            this.queryMillisecondsTimeout = Long.MAX_VALUE;
        } else {
            this.executionMonitor.onError(-6);
            String errorMessage = "Set query timeout failed: `could not less than zero`. invalidQueryTimeout: `" + queryMillisecondsTimeout + "ms`. Connection info: `" + this.connectionInfo + "`. Host: `" + this.mysqlChannel.getConnectionConfiguration().getHost() + "`.";
            LOG.error(errorMessage);
            throw new SQLException(errorMessage);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        startTime = System.nanoTime();
        try {
            this.reset();
            sqlCommand = new SQLCommand(sql, this.connectionInfo);
            mysqlPacketList = this.mysqlChannel.send(sqlCommand, this.queryMillisecondsTimeout);
            errorPacket = sqlCommand.getErrorPacket();
            if (errorPacket != null) {
                errorMessage = "Execute sql failed: `" + errorPacket.getErrorMessage() + "`. Error code: `" + errorPacket.getErrorCode() + "`. Sql state: `" + errorPacket.getSqlState() + "`. Sql: `" + sql + "`. Connection info: `" + this.connectionInfo + "`. Host: `" + this.mysqlChannel.getConnectionConfiguration().getHost() + ".";
                throw new SQLException(errorMessage, errorPacket.getSqlState(), errorPacket.getErrorCode());
            }
            if (sqlCommand.hasTextResultSet()) {
                this.resultSet = new ReadonlyTextResultSet(mysqlPacketList, this.connectionInfo, this, this.executionMonitor);
                if (this.fetchDirection != 1000) {
                    this.resultSet.setFetchDirection(this.fetchDirection);
                }
                this.mysqlConnection.setLastServerStatusInfo(sqlCommand.getServerStatusInfo());
                this.databaseMonitor.onSelectExecuted(this.resultSet.getRowsSize());
                if (TextStatement.MYSQL_EXECUTION_DEBUG_LOG.isDebugEnabled()) {
                    queryResult = new StringBuilder();
                    columnCount = this.resultSet.getMetaData().getColumnCount();
                    while (this.resultSet.next()) {
                        queryResult.append("[");
                        for (i = 1; i <= columnCount; ++i) {
                            if (i > 1) {
                                queryResult.append(", ");
                            }
                            if ((value = this.resultSet.getObject(i)) == null) {
                                queryResult.append("null");
                                continue;
                            }
                            if (value instanceof byte[]) {
                                queryResult.append("`").append(Arrays.toString((byte[])value)).append("`");
                                continue;
                            }
                            queryResult.append("`").append(value).append("`");
                        }
                        queryResult.append("]\n\r");
                    }
                    this.resultSet.beforeFirst();
                    TextStatement.MYSQL_EXECUTION_DEBUG_LOG.debug("[{}] {}\n\r{}\n\rRows size: {}\n\r{}", new Object[]{this.mysqlConnection.getSchema(), sql.replace('\n', ' ').replace('\r', ' '), sqlCommand.getServerStatusInfo(), this.resultSet.getRowsSize(), queryResult.toString()});
                }
                var7_12 = true;
            }
            ** GOTO lbl-1000
        }
        catch (IllegalStateException e) {
            try {
                this.executionMonitor.onError(-2);
                errorMessage = "Execute sql failed: `illegal state`. Cost: `" + (System.nanoTime() - startTime) + "ns`. Sql: `" + sql + "`. Connection info: `" + this.connectionInfo + "`. Host: `" + this.mysqlChannel.getConnectionConfiguration().getHost() + "`.";
                TextStatement.LOG.error(errorMessage, (Throwable)e);
                throw new SQLException(errorMessage, e);
                catch (SQLTimeoutException e) {
                    this.executionMonitor.onError(-3);
                    TextStatement.LOG.error("Execute sql failed: `timeout`. Cost: `" + (System.nanoTime() - startTime) + "ns`. Sql: `" + sql + "`. Query timeout: `" + this.queryMillisecondsTimeout + "ms`. Connection info: `" + this.connectionInfo + "`. Host: `" + this.mysqlChannel.getConnectionConfiguration().getHost() + "`.", (Throwable)e);
                    throw e;
                }
                catch (SQLException e) {
                    this.executionMonitor.onError(-1);
                    TextStatement.LOG.error("Execute sql failed: `sql exception`. Cost: `" + (System.nanoTime() - startTime) + "ns`. Sql: `" + sql + "`. Connection info: `" + this.connectionInfo + "`. Host: `" + this.mysqlChannel.getConnectionConfiguration().getHost() + "`.", (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    this.executionMonitor.onError(-6);
                    errorMessage = "Execute sql failed: `unexpected exception`. Sql: `" + sql + "`. Connection info: `" + this.connectionInfo + "`. Host: `" + this.mysqlChannel.getConnectionConfiguration().getHost() + "`.";
                    TextStatement.LOG.error(errorMessage, (Throwable)e);
                    throw new SQLException(errorMessage, e);
                }
            }
            catch (Throwable var11_19) {
                executedNanoTime = System.nanoTime() - startTime;
                if (executedNanoTime > this.slowExecutionThreshold) {
                    this.executionMonitor.onError(-7);
                    TextStatement.MYSQL_SLOW_EXECUTION_LOG.info("`Cost`:`{}ns ({}ms)`. `Sql`:`{}`. `Database`:`{}`. `Host`:`{}`. `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), sql, this.mysqlChannel.getConnectionConfiguration().getDatabaseName(), this.mysqlChannel.getConnectionConfiguration().getHost(), this.mysqlConnection.getLastServerStatusInfo()});
                }
                this.executionMonitor.onExecuted(startTime);
                throw var11_19;
            }
        }
        executedNanoTime = System.nanoTime() - startTime;
        if (executedNanoTime > this.slowExecutionThreshold) {
            this.executionMonitor.onError(-7);
            TextStatement.MYSQL_SLOW_EXECUTION_LOG.info("`Cost`:`{}ns ({}ms)`. `Sql`:`{}`. `Database`:`{}`. `Host`:`{}`. `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), sql, this.mysqlChannel.getConnectionConfiguration().getDatabaseName(), this.mysqlChannel.getConnectionConfiguration().getHost(), this.mysqlConnection.getLastServerStatusInfo()});
        }
        this.executionMonitor.onExecuted(startTime);
        return var7_12;
lbl-1000:
        // 1 sources

        {
            this.affectedRows = sqlCommand.getAffectedRows();
            this.lastInsertId = sqlCommand.getLastInsertId();
            this.mysqlConnection.setLastServerStatusInfo(sqlCommand.getServerStatusInfo());
            this.databaseMonitor.onExecuted(SQLUtil.getSQLType(sql), sqlCommand.getAffectedRows());
            if (TextStatement.MYSQL_EXECUTION_DEBUG_LOG.isDebugEnabled()) {
                TextStatement.MYSQL_EXECUTION_DEBUG_LOG.debug("[{}] {}\n\r{}\n\rAffected rows: {}. Last insert id: {}.", new Object[]{this.mysqlConnection.getSchema(), sql.replace('\n', ' ').replace('\r', ' '), sqlCommand.getServerStatusInfo(), this.affectedRows, this.lastInsertId});
            }
            var7_13 = false;
        }
        executedNanoTime = System.nanoTime() - startTime;
        if (executedNanoTime > this.slowExecutionThreshold) {
            this.executionMonitor.onError(-7);
            TextStatement.MYSQL_SLOW_EXECUTION_LOG.info("`Cost`:`{}ns ({}ms)`. `Sql`:`{}`. `Database`:`{}`. `Host`:`{}`. `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), sql, this.mysqlChannel.getConnectionConfiguration().getDatabaseName(), this.mysqlChannel.getConnectionConfiguration().getHost(), this.mysqlConnection.getLastServerStatusInfo()});
        }
        this.executionMonitor.onExecuted(startTime);
        return var7_13;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    private void reset() {
        this.affectedRows = -1L;
        this.lastInsertId = -1L;
        this.resultSet = null;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql);
        if (this.resultSet == null) {
            this.executionMonitor.onError(-6);
            String errorMessage = "Execute query sql failed: `not query sql`. Sql: `" + sql + "`. Connection info: `" + this.connectionInfo + "`. Host: `" + this.mysqlChannel.getConnectionConfiguration().getHost() + "`.";
            LOG.error(errorMessage);
            throw new SQLException(errorMessage);
        }
        return this.resultSet;
    }

    @Override
    public ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.execute(sql);
        if (this.affectedRows == -1L) {
            this.executionMonitor.onError(-6);
            String errorMessage = "Execute update sql failed: `not update sql`. Sql: `" + sql + "`. Connection info: `" + this.connectionInfo + "`. Host: `" + this.mysqlChannel.getConnectionConfiguration().getHost() + "`.";
            LOG.error(errorMessage);
            throw new SQLException(errorMessage);
        }
        return this.affectedRows;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeLargeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        long affectedRows = this.executeLargeUpdate(sql);
        return affectedRows > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)affectedRows;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public ResultSet getGeneratedKeys() {
        return new AutoGenerateKeysResultSet(this.lastInsertId, this);
    }

    @Override
    public long getLargeUpdateCount() {
        return this.affectedRows;
    }

    @Override
    public int getUpdateCount() {
        return this.affectedRows > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.affectedRows;
    }

    @Override
    public void close() {
        this.reset();
    }

    @Override
    public void cancel() {
        this.reset();
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void setCursorName(String name) {
    }

    @Override
    public void setFetchDirection(int direction) {
        this.fetchDirection = direction == 1001 ? 1001 : 1000;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public int getFetchSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getResultSetConcurrency() {
        return 1007;
    }

    @Override
    public int getResultSetType() {
        return 1004;
    }

    @Override
    public Connection getConnection() {
        return this.mysqlConnection;
    }

    @Override
    public boolean getMoreResults() {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) {
        return false;
    }

    @Override
    public void closeOnCompletion() {
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public boolean isPoolable() {
        return false;
    }

    @Override
    public boolean isCloseOnCompletion() {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return TextStatement.class == iface;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextStatement#execute(String sql, int[] columnIndexes)");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextStatement#execute(String sql, String[] columnNames)");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextStatement#executeUpdate(String sql, int[] columnIndexes)");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextStatement#executeUpdate(String sql, String[] columnNames)");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextStatement#executeLargeUpdate(String sql, int[] columnIndexes)");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextStatement#executeLargeUpdate(String sql, String[] columnNames)");
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextStatement#executeLargeBatch()", "mysql-jdbc does not support batch statements.");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextStatement#addBatch(String sql)", "mysql-jdbc does not support batch statements.");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextStatement#clearBatch()", "mysql-jdbc does not support batch statements.");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextStatement#executeBatch()", "mysql-jdbc does not support batch statements.");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextStatement#setMaxRows(int max)");
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextStatement#setLargeMaxRows(long max)");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextStatement#setMaxFieldSize(int max)");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        if (poolable) {
            throw SQLFeatureNotSupportedExceptionBuilder.build("TextStatement#setPoolable(boolean poolable)", "Pool TextStatement could not improve any performance. Please don't do that.");
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("TextStatement#getResultSetHoldability()");
    }
}

