/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.channel;

import com.heimuheimu.mysql.jdbc.ConnectionConfiguration;
import com.heimuheimu.mysql.jdbc.ConnectionInfo;
import com.heimuheimu.mysql.jdbc.packet.CharsetMappingUtil;
import com.heimuheimu.mysql.jdbc.packet.MysqlPacket;
import com.heimuheimu.mysql.jdbc.packet.MysqlPacketReader;
import com.heimuheimu.mysql.jdbc.packet.connection.HandshakeResponse41Packet;
import com.heimuheimu.mysql.jdbc.packet.connection.HandshakeV10Packet;
import com.heimuheimu.mysql.jdbc.packet.connection.auth.AuthenticationPlugin;
import com.heimuheimu.mysql.jdbc.packet.connection.auth.AuthenticationPluginFactory;
import com.heimuheimu.mysql.jdbc.packet.generic.ErrorPacket;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandshakeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(HandshakeProcessor.class);
    private final ConnectionConfiguration connectionConfiguration;
    private final OutputStream outputStream;
    private final MysqlPacketReader reader;

    public HandshakeProcessor(ConnectionConfiguration connectionConfiguration, OutputStream outputStream, MysqlPacketReader reader) {
        this.connectionConfiguration = connectionConfiguration;
        this.outputStream = outputStream;
        this.reader = reader;
    }

    public ConnectionInfo doHandshake() throws IOException {
        MysqlPacket packet = this.reader.read();
        HandshakeV10Packet handshakeV10Packet = HandshakeV10Packet.parse(packet);
        LOG.debug("[handshake] receive HandshakeV10Packet: `{}`. Connection config: `{}`.", (Object)handshakeV10Packet, (Object)this.connectionConfiguration);
        AuthenticationPlugin plugin = AuthenticationPluginFactory.get(handshakeV10Packet.getAuthPluginName());
        byte[] authResponse = plugin.encode(this.connectionConfiguration.getPassword(), handshakeV10Packet.getAuthPluginData());
        HandshakeResponse41Packet handshakeResponse41Packet = new HandshakeResponse41Packet();
        handshakeResponse41Packet.setClientCharacterId(this.connectionConfiguration.getCharacterId());
        handshakeResponse41Packet.setCapabilitiesFlags(this.connectionConfiguration.getCapabilitiesFlags());
        handshakeResponse41Packet.setUsername(this.connectionConfiguration.getUsername());
        handshakeResponse41Packet.setAuthResponse(authResponse);
        handshakeResponse41Packet.setAuthPluginName(plugin.getName());
        handshakeResponse41Packet.setDatabaseName(this.connectionConfiguration.getDatabaseName());
        byte[] handshakeResponse41PacketBytes = handshakeResponse41Packet.buildMysqlPacketBytes(handshakeV10Packet.getCapabilitiesFlags());
        this.outputStream.write(handshakeResponse41PacketBytes);
        this.outputStream.flush();
        LOG.debug("[handshake] send HandshakeResponse41Packet: `{}`. Connection config: `{}`.", (Object)handshakeResponse41Packet, (Object)this.connectionConfiguration);
        packet = this.reader.read();
        if (ErrorPacket.isErrorPacket(packet)) {
            Charset charset = CharsetMappingUtil.getJavaCharset(handshakeResponse41Packet.getClientCharacterId());
            ErrorPacket errorPacket = ErrorPacket.parse(packet, charset);
            LOG.error("Connect to mysql failed: `handshake failed`. Error packet: `{}`. Connection config: `{}`.", (Object)errorPacket, (Object)this.connectionConfiguration);
            throw new IOException("Connect to mysql failed: `handshake failed`. Error packet: `" + errorPacket + "`. Connection config: `" + this.connectionConfiguration + "`.");
        }
        return new ConnectionInfo(handshakeV10Packet.getConnectionId(), handshakeV10Packet.getServerVersion(), handshakeV10Packet.getServerCharacterId(), handshakeV10Packet.getCapabilitiesFlags(), handshakeV10Packet.getServerStatusFlags(), handshakeResponse41Packet.getClientCharacterId(), handshakeResponse41Packet.getCapabilitiesFlags(), handshakeResponse41Packet.getDatabaseName());
    }
}

