/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.channel;

import com.heimuheimu.mysql.jdbc.ConnectionConfiguration;
import com.heimuheimu.mysql.jdbc.ConnectionInfo;
import com.heimuheimu.mysql.jdbc.channel.HandshakeProcessor;
import com.heimuheimu.mysql.jdbc.command.Command;
import com.heimuheimu.mysql.jdbc.command.PingCommand;
import com.heimuheimu.mysql.jdbc.command.SQLCommand;
import com.heimuheimu.mysql.jdbc.constant.BeanStatusEnum;
import com.heimuheimu.mysql.jdbc.facility.UnusableServiceNotifier;
import com.heimuheimu.mysql.jdbc.facility.parameter.ConstructorParameterChecker;
import com.heimuheimu.mysql.jdbc.facility.parameter.Parameters;
import com.heimuheimu.mysql.jdbc.monitor.SocketMonitorFactory;
import com.heimuheimu.mysql.jdbc.net.BuildSocketException;
import com.heimuheimu.mysql.jdbc.net.SocketBuilder;
import com.heimuheimu.mysql.jdbc.net.SocketConfiguration;
import com.heimuheimu.mysql.jdbc.packet.MysqlPacket;
import com.heimuheimu.mysql.jdbc.packet.MysqlPacketReader;
import com.heimuheimu.mysql.jdbc.packet.generic.ErrorPacket;
import com.heimuheimu.mysql.jdbc.util.LogBuildUtil;
import com.heimuheimu.naivemonitor.facility.MonitoredSocketOutputStream;
import com.heimuheimu.naivemonitor.monitor.SocketMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.sql.SQLTimeoutException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlChannel
implements Closeable {
    private static final Logger MYSQL_CONNECTION_LOG = LoggerFactory.getLogger((String)"MYSQL_CONNECTION_LOG");
    private static final Logger LOG = LoggerFactory.getLogger(MysqlChannel.class);
    private final ConnectionConfiguration connectionConfiguration;
    private final Socket socket;
    private final SocketMonitor socketMonitor;
    private final UnusableServiceNotifier<MysqlChannel> unusableServiceNotifier;
    private volatile BeanStatusEnum state = BeanStatusEnum.UNINITIALIZED;
    private volatile ConnectionInfo connectionInfo = null;
    private MysqlIOTask ioTask = null;
    private final LinkedBlockingQueue<Command> commandQueue = new LinkedBlockingQueue();

    public MysqlChannel(ConnectionConfiguration configuration, UnusableServiceNotifier<MysqlChannel> unusableServiceNotifier) throws IllegalArgumentException, BuildSocketException {
        ConstructorParameterChecker checker = new ConstructorParameterChecker("MysqlChannel", LOG);
        checker.addParameter("connectionConfiguration", configuration);
        checker.addParameter("unusableServiceNotifier", unusableServiceNotifier);
        checker.check("connectionConfiguration", "isNull", Parameters::isNull);
        this.connectionConfiguration = configuration;
        this.socket = SocketBuilder.create(configuration.getHost(), configuration.getSocketConfiguration());
        this.socketMonitor = SocketMonitorFactory.get(configuration.getHost(), configuration.getDatabaseName());
        this.unusableServiceNotifier = unusableServiceNotifier;
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public boolean isAvailable() {
        return this.state == BeanStatusEnum.NORMAL;
    }

    public List<MysqlPacket> send(Command command, long timeout) throws NullPointerException, IllegalStateException, SQLTimeoutException {
        if (command == null) {
            HashMap<String, Object> extendParameterMap = new HashMap<String, Object>();
            extendParameterMap.put("timeout", timeout);
            throw new NullPointerException("Execute mysql command failed: `command could not be null`." + this.buildLogForParameters(extendParameterMap));
        }
        if (this.state != BeanStatusEnum.NORMAL) {
            HashMap<String, Object> extendParameterMap = new HashMap<String, Object>();
            extendParameterMap.put("timeout", timeout);
            extendParameterMap.put("command", command);
            throw new IllegalStateException("Execute mysql command failed: `MysqlChannel is not initialized or has been closed`. `state`:`" + (Object)((Object)this.state) + "`." + this.buildLogForParameters(extendParameterMap));
        }
        this.commandQueue.add(command);
        try {
            return command.getResponsePacketList(timeout);
        }
        catch (SQLTimeoutException e) {
            HashMap<String, Object> extendParameterMap = new HashMap<String, Object>();
            extendParameterMap.put("timeout", timeout);
            extendParameterMap.put("command", command);
            String parametersLog = this.buildLogForParameters(extendParameterMap);
            MYSQL_CONNECTION_LOG.error("MysqlChannel need to be closed: `execute command timeout`.{}", (Object)parametersLog);
            LOG.error("Execute mysql command failed: `wait response packet timeout, MysqlChannel need to be closed`." + parametersLog, (Throwable)e);
            this.close(true);
            throw e;
        }
    }

    public synchronized void init() {
        if (this.state == BeanStatusEnum.UNINITIALIZED) {
            try {
                if (this.socket.isConnected() && !this.socket.isClosed()) {
                    this.state = BeanStatusEnum.NORMAL;
                    long startTime = System.currentTimeMillis();
                    SocketConfiguration config = SocketBuilder.getConfig(this.socket);
                    String socketAddress = this.connectionConfiguration.getHost() + "/" + this.socket.getLocalPort();
                    this.ioTask = new MysqlIOTask(config.getReceiveBufferSize());
                    this.ioTask.setName("mysql-io-" + socketAddress);
                    this.ioTask.start();
                    HashMap<String, Object> extendParameterMap = new HashMap<String, Object>();
                    extendParameterMap.put("localSocketPort", this.socket.getLocalPort());
                    extendParameterMap.put("socketConfig", config);
                    MYSQL_CONNECTION_LOG.info("MysqlChannel has benn initialized. `cost`:`{}ms`.{}", (Object)(System.currentTimeMillis() - startTime), (Object)this.buildLogForParameters(extendParameterMap));
                } else {
                    MYSQL_CONNECTION_LOG.error("Initialize MysqlChannel failed: `socket is not connected or has been closed`.{}", (Object)this.buildLogForParameters(null));
                    this.close();
                }
            }
            catch (Exception e) {
                String parametersLog = this.buildLogForParameters(null);
                MYSQL_CONNECTION_LOG.error("Initialize MysqlChannel failed: `{}`.{}", (Object)e.getMessage(), (Object)parametersLog);
                LOG.error("Initialize MysqlChannel failed: `" + e.getMessage() + "`." + parametersLog, (Throwable)e);
                this.close();
            }
        }
    }

    @Override
    public synchronized void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void close(boolean sendKillCommand) {
        if (this.state != BeanStatusEnum.CLOSED) {
            long startTime = System.currentTimeMillis();
            this.state = BeanStatusEnum.CLOSED;
            if (sendKillCommand) {
                MysqlChannelKillTask killTask = new MysqlChannelKillTask(this.connectionConfiguration, this.connectionInfo);
                killTask.setName("mysql-channel-kill-task");
                killTask.start();
            }
            try {
                this.socket.close();
                if (this.ioTask != null) {
                    this.ioTask.stopSignal = true;
                    this.ioTask.interrupt();
                }
                MYSQL_CONNECTION_LOG.info("MysqlChannel has been closed. `cost`:`{}ms`.{}", (Object)(System.currentTimeMillis() - startTime), (Object)this.buildLogForParameters(null));
            }
            catch (Exception e) {
                String parametersLog = this.buildLogForParameters(null);
                MYSQL_CONNECTION_LOG.error("Close MysqlChannel failed: `{}`.{}", (Object)e.getMessage(), (Object)parametersLog);
                LOG.error("Close MysqlChannel failed: `" + e.getMessage() + "`." + parametersLog, (Throwable)e);
            }
            finally {
                if (this.unusableServiceNotifier != null) {
                    this.unusableServiceNotifier.onClosed(this);
                }
                this.connectionInfo = null;
            }
        }
    }

    public String toString() {
        return "MysqlChannel{connectionConfiguration=" + this.connectionConfiguration + ", socket=" + this.socket + ", unusableServiceNotifier=" + this.unusableServiceNotifier + ", state=" + (Object)((Object)this.state) + ", connectionInfo=" + this.connectionInfo + '}';
    }

    private String buildLogForParameters(Map<String, Object> extendParameterMap) {
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        parameterMap.put("host", this.connectionConfiguration == null ? "" : this.connectionConfiguration.getHost());
        parameterMap.put("connectionId", this.connectionInfo == null ? "" : Long.valueOf(this.connectionInfo.getConnectionId()));
        if (extendParameterMap != null && !extendParameterMap.isEmpty()) {
            parameterMap.putAll(extendParameterMap);
        }
        parameterMap.put("connectionConfiguration", this.connectionConfiguration);
        parameterMap.put("connectionInfo", this.connectionInfo);
        return LogBuildUtil.build(parameterMap);
    }

    private static class MysqlChannelKillTask
    extends Thread {
        private final ConnectionConfiguration connectionConfiguration;
        private final ConnectionInfo connectionInfo;

        private MysqlChannelKillTask(ConnectionConfiguration connectionConfiguration, ConnectionInfo connectionInfo) {
            this.connectionConfiguration = connectionConfiguration;
            this.connectionInfo = connectionInfo;
        }

        @Override
        public void run() {
            if (this.connectionInfo != null) {
                long startTime = System.currentTimeMillis();
                ConnectionConfiguration temporaryConnectionConfiguration = new ConnectionConfiguration(this.connectionConfiguration.getHost(), this.connectionConfiguration.getDatabaseName(), this.connectionConfiguration.getUsername(), this.connectionConfiguration.getPassword());
                try (MysqlChannel channel = new MysqlChannel(temporaryConnectionConfiguration, null);){
                    channel.init();
                    SQLCommand killCommand = new SQLCommand("KILL " + this.connectionInfo.getConnectionId(), channel.getConnectionInfo());
                    channel.send(killCommand, 5000L);
                    ErrorPacket errorPacket = killCommand.getErrorPacket();
                    if (errorPacket != null) {
                        MYSQL_CONNECTION_LOG.error("Kill connection failed: `{}`. `cost`:`{}ms` `connectionId`:`{}`. `host`:`{}`. `databaseName`:`{}`.", new Object[]{errorPacket.getErrorMessage(), System.currentTimeMillis() - startTime, this.connectionInfo.getConnectionId(), temporaryConnectionConfiguration.getHost(), temporaryConnectionConfiguration.getDatabaseName()});
                        LOG.error("Kill connection failed: `{}`. `cost`:`{}ms` `connectionId`:`{}`. `host`:`{}`. `databaseName`:`{}`.", new Object[]{errorPacket.getErrorMessage(), System.currentTimeMillis() - startTime, this.connectionInfo.getConnectionId(), temporaryConnectionConfiguration.getHost(), temporaryConnectionConfiguration.getDatabaseName()});
                    } else {
                        MYSQL_CONNECTION_LOG.info("Kill connection success. `cost`:`{}ms`. `connectionId`:`{}`. `host`:`{}`. `databaseName`:`{}`.", new Object[]{System.currentTimeMillis() - startTime, this.connectionInfo.getConnectionId(), temporaryConnectionConfiguration.getHost(), temporaryConnectionConfiguration.getDatabaseName()});
                    }
                }
                catch (Exception e) {
                    String errorMessage = "Kill connection failed: `unexpected error`. `cost`:`" + (System.currentTimeMillis() - startTime) + "ms` `connectionId`:`" + this.connectionInfo.getConnectionId() + "`. `host`:`" + temporaryConnectionConfiguration.getHost() + "`. `databaseName`:`" + temporaryConnectionConfiguration.getDatabaseName() + "`.";
                    MYSQL_CONNECTION_LOG.error(errorMessage);
                    LOG.error(errorMessage, (Throwable)e);
                }
            } else {
                LOG.error("Kill connection failed: `null connection info`.");
            }
        }
    }

    private class MysqlIOTask
    extends Thread {
        private final MonitoredSocketOutputStream outputStream;
        private final MysqlPacketReader reader;
        private volatile boolean stopSignal = false;
        private final LinkedList<Command> waitingQueue = new LinkedList();

        private MysqlIOTask(Integer receiveBufferSize) throws IOException {
            this.outputStream = new MonitoredSocketOutputStream(MysqlChannel.this.socket.getOutputStream(), MysqlChannel.this.socketMonitor);
            receiveBufferSize = receiveBufferSize != null ? receiveBufferSize : 65536;
            this.reader = new MysqlPacketReader(MysqlChannel.this.socket.getInputStream(), receiveBufferSize, MysqlChannel.this.socketMonitor);
            HandshakeProcessor handshakeProcessor = new HandshakeProcessor(MysqlChannel.this.connectionConfiguration, (OutputStream)this.outputStream, this.reader);
            MysqlChannel.this.connectionInfo = handshakeProcessor.doHandshake();
        }

        @Override
        public void run() {
            int pingPeriod = MysqlChannel.this.connectionConfiguration.getPingPeriod();
            Command command = null;
            while (!this.stopSignal) {
                try {
                    if (pingPeriod <= 0) {
                        command = (Command)MysqlChannel.this.commandQueue.take();
                    } else {
                        command = (Command)MysqlChannel.this.commandQueue.poll(pingPeriod, TimeUnit.SECONDS);
                        if (command == null) {
                            long pingCommandStartTime = System.currentTimeMillis();
                            PingCommand pingCommand = new PingCommand();
                            Thread pingCheckThread = new Thread(() -> {
                                block5: {
                                    try {
                                        if (pingCommand.isSuccess(5000L)) {
                                            LOG.debug("Execute `PingCommand` success. `cost`:`{}ms`.{}", (Object)(System.currentTimeMillis() - pingCommandStartTime), (Object)MysqlChannel.this.buildLogForParameters(null));
                                        } else if (MysqlChannel.this.state != BeanStatusEnum.CLOSED) {
                                            String parametersLog = MysqlChannel.this.buildLogForParameters(null);
                                            MYSQL_CONNECTION_LOG.info("MysqlChannel need to be closed: `execute PingCommand failed`.{}", (Object)parametersLog);
                                            LOG.error("MysqlChannel need to be closed: `execute PingCommand failed`.{}", (Object)parametersLog);
                                            MysqlChannel.this.close();
                                        }
                                    }
                                    catch (Exception e) {
                                        if (MysqlChannel.this.state == BeanStatusEnum.CLOSED) break block5;
                                        String parametersLog = MysqlChannel.this.buildLogForParameters(null);
                                        MYSQL_CONNECTION_LOG.info("MysqlChannel need to be closed: `execute PingCommand failed`.{}", (Object)parametersLog);
                                        LOG.error("MysqlChannel need to be closed: `execute PingCommand failed`." + parametersLog, (Throwable)e);
                                        MysqlChannel.this.close();
                                    }
                                }
                            });
                            String socketAddress = MysqlChannel.this.connectionConfiguration.getHost() + "/" + MysqlChannel.this.socket.getLocalPort();
                            pingCheckThread.setName("mysql-ping-check-" + socketAddress);
                            pingCheckThread.start();
                            command = pingCommand;
                        }
                    }
                    byte[] requestPacket = command.getRequestByteArray();
                    this.outputStream.write(requestPacket);
                    this.outputStream.flush();
                    if (command.hasResponsePacket()) {
                        this.waitingQueue.add(command);
                    }
                    while (this.waitingQueue.size() > 0) {
                        command = this.waitingQueue.peek();
                        MysqlPacket responsePacket = this.reader.read();
                        if (responsePacket != null) {
                            command.receiveResponsePacket(responsePacket);
                            if (command.hasResponsePacket()) continue;
                            this.waitingQueue.poll();
                            continue;
                        }
                        MYSQL_CONNECTION_LOG.info("MysqlChannel need to be closed: `end of the input stream has been reached`.{}", (Object)MysqlChannel.this.buildLogForParameters(null));
                        MysqlChannel.this.close();
                    }
                }
                catch (InterruptedException requestPacket) {
                }
                catch (Exception e) {
                    if (MysqlChannel.this.state == BeanStatusEnum.CLOSED) continue;
                    String parametersLog = MysqlChannel.this.buildLogForParameters(null);
                    MYSQL_CONNECTION_LOG.error("MysqlChannel need to be closed: `{}`.{}", (Object)e.getMessage(), (Object)parametersLog);
                    LOG.error("MysqlChannel need to be closed: `" + e.getMessage() + "`." + parametersLog, (Throwable)e);
                    MysqlChannel.this.close();
                }
            }
            if (command != null) {
                command.close();
            }
            while ((command = this.waitingQueue.poll()) != null) {
                command.close();
            }
            while ((command = (Command)MysqlChannel.this.commandQueue.poll()) != null) {
                command.close();
            }
        }
    }
}

