/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.command;

import com.heimuheimu.mysql.jdbc.command.Command;
import com.heimuheimu.mysql.jdbc.command.MysqlServerStatusInfo;
import com.heimuheimu.mysql.jdbc.packet.MysqlPacket;
import java.sql.SQLTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class AbstractCommand
implements Command {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final List<MysqlPacket> responsePacketList = new ArrayList<MysqlPacket>();
    private final Object responseLock = new Object();
    private volatile boolean isCompleted = false;

    @Override
    public boolean hasResponsePacket() {
        return !this.isCompleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveResponsePacket(MysqlPacket responsePacket) throws IllegalStateException {
        boolean isLastPacket = this.isLastPacket(responsePacket);
        Object object = this.responseLock;
        synchronized (object) {
            this.responsePacketList.add(responsePacket);
        }
        if (isLastPacket) {
            this.isCompleted = true;
            this.latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MysqlPacket> getResponsePacketList(long timeout) throws IllegalStateException, SQLTimeoutException {
        boolean latchFlag;
        try {
            latchFlag = this.latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Get mysql command response packet failed: `command has been interrupted`. Timeout: `" + timeout + "ms`. Command: `" + this + "`.", e);
        }
        if (latchFlag) {
            if (this.isCompleted) {
                Object object = this.responseLock;
                synchronized (object) {
                    return this.responsePacketList;
                }
            }
            throw new IllegalStateException("Get mysql command response packet failed: `command has been closed`. Timeout: `" + timeout + "ms`. Command: `" + this + "`.");
        }
        throw new SQLTimeoutException("Get mysql command response packet failed: `wait response timeout`. Timeout: `" + timeout + "ms`. Command: `" + this + "`.");
    }

    @Override
    public void close() {
        this.latch.countDown();
    }

    @Override
    public MysqlServerStatusInfo getServerStatusInfo() {
        return null;
    }

    protected boolean isCompleted() {
        return this.isCompleted;
    }

    protected abstract boolean isLastPacket(MysqlPacket var1) throws IllegalStateException;
}

