/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.command;

import com.heimuheimu.mysql.jdbc.command.AbstractCommand;
import com.heimuheimu.mysql.jdbc.packet.MysqlPacket;
import com.heimuheimu.mysql.jdbc.packet.command.utility.CommandPingPacket;
import com.heimuheimu.mysql.jdbc.packet.generic.OKPacket;
import java.sql.SQLException;

public class PingCommand
extends AbstractCommand {
    private final byte[] requestByteArray;

    public PingCommand() throws NullPointerException {
        CommandPingPacket pingPacket = new CommandPingPacket();
        this.requestByteArray = pingPacket.buildMysqlPacketBytes();
    }

    public boolean isSuccess(long timeout) throws SQLException {
        this.getResponsePacketList(timeout);
        return true;
    }

    @Override
    protected boolean isLastPacket(MysqlPacket responsePacket) throws IllegalStateException {
        if (OKPacket.isOkPacket(responsePacket)) {
            return true;
        }
        throw new IllegalStateException("Receive response packet for `PingCommand` failed: `invalid OK_Packet`. Invalid response packet:`" + responsePacket + "`.");
    }

    @Override
    public byte[] getRequestByteArray() {
        return this.requestByteArray;
    }
}

