/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.command;

import com.heimuheimu.mysql.jdbc.ConnectionInfo;
import com.heimuheimu.mysql.jdbc.command.AbstractCommand;
import com.heimuheimu.mysql.jdbc.command.MysqlServerStatusInfo;
import com.heimuheimu.mysql.jdbc.packet.MysqlPacket;
import com.heimuheimu.mysql.jdbc.packet.command.text.CommandQueryPacket;
import com.heimuheimu.mysql.jdbc.packet.generic.EOFPacket;
import com.heimuheimu.mysql.jdbc.packet.generic.ErrorPacket;
import com.heimuheimu.mysql.jdbc.packet.generic.OKPacket;

public class SQLCommand
extends AbstractCommand {
    private final String sql;
    private final ConnectionInfo connectionInfo;
    private final byte[] requestByteArray;
    private volatile int receivedPacketCount = 0;
    private volatile int receivedEOFPacketCount = 0;
    private volatile boolean hasTextResultSet = false;
    private volatile long affectedRows = 0L;
    private volatile long lastInsertId = -1L;
    private volatile ErrorPacket errorPacket = null;
    private volatile MysqlServerStatusInfo serverStatusInfo = null;

    public SQLCommand(String sql, ConnectionInfo connectionInfo) throws IllegalArgumentException {
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("Create SQLCommand failed: `sql is null or empty`. Sql: `" + sql + "`. Connection info: `" + connectionInfo + "`.");
        }
        if (connectionInfo == null) {
            throw new IllegalArgumentException("Create SQLCommand failed: `connectionInfo is null`. Sql: `" + sql + "`. Connection info: `null`.");
        }
        this.sql = sql;
        this.connectionInfo = connectionInfo;
        CommandQueryPacket commandQueryPacket = new CommandQueryPacket(sql);
        this.requestByteArray = commandQueryPacket.buildMysqlPacketBytes(connectionInfo.getJavaCharset());
    }

    @Override
    public byte[] getRequestByteArray() {
        return this.requestByteArray;
    }

    public boolean hasTextResultSet() throws IllegalStateException {
        if (!this.isCompleted()) {
            throw new IllegalStateException("Check has text result set failed: `command is not finished`. Sql: `" + this.sql + "`. ConnectionInfo:`" + this.connectionInfo + "`.");
        }
        return this.hasTextResultSet;
    }

    public long getAffectedRows() throws IllegalStateException {
        if (!this.isCompleted()) {
            throw new IllegalStateException("Get affected rows failed: `command is not finished`. Sql: `" + this.sql + "`. ConnectionInfo:`" + this.connectionInfo + "`.");
        }
        return this.affectedRows;
    }

    public long getLastInsertId() throws IllegalStateException {
        if (!this.isCompleted()) {
            throw new IllegalStateException("Get last insert id failed: `command is not finished`. Sql: `" + this.sql + "`. ConnectionInfo:`" + this.connectionInfo + "`.");
        }
        return this.lastInsertId;
    }

    public ErrorPacket getErrorPacket() throws IllegalStateException {
        if (!this.isCompleted()) {
            throw new IllegalStateException("Get error packet failed: `command is not finished`. Sql: `" + this.sql + "`. ConnectionInfo:`" + this.connectionInfo + "`.");
        }
        return this.errorPacket;
    }

    @Override
    protected boolean isLastPacket(MysqlPacket responsePacket) throws IllegalStateException {
        ++this.receivedPacketCount;
        if (this.receivedPacketCount == 1) {
            if ((responsePacket.getPayload()[0] & 0xFF) == 251) {
                throw new IllegalStateException("Receive response packet for `SQLCommand` failed: `LOCAL INFILE Request is not supported`. Sql: `" + this.sql + "`. ConnectionInfo:`" + this.connectionInfo + "`. Invalid response packet:`" + responsePacket + "`.");
            }
            if (OKPacket.isOkPacket(responsePacket)) {
                OKPacket okPacket = OKPacket.parse(responsePacket, this.connectionInfo.getCapabilitiesFlags(), this.connectionInfo.getJavaCharset());
                this.affectedRows = okPacket.getAffectedRows();
                this.lastInsertId = okPacket.getLastInsertId();
                if (okPacket.getServerStatusFlags() != -1) {
                    this.serverStatusInfo = new MysqlServerStatusInfo(okPacket.getServerStatusFlags());
                }
                return true;
            }
            if (ErrorPacket.isErrorPacket(responsePacket)) {
                this.errorPacket = ErrorPacket.parse(responsePacket, this.connectionInfo.getJavaCharset());
                return true;
            }
            this.hasTextResultSet = true;
            return false;
        }
        if (EOFPacket.isEOFPacket(responsePacket)) {
            ++this.receivedEOFPacketCount;
            if (this.receivedEOFPacketCount == 2) {
                EOFPacket eofPacket = EOFPacket.parse(responsePacket, this.connectionInfo.getCapabilitiesFlags());
                if (eofPacket.getServerStatusFlags() != -1) {
                    this.serverStatusInfo = new MysqlServerStatusInfo(eofPacket.getServerStatusFlags());
                }
                return true;
            }
            return false;
        }
        if (this.receivedEOFPacketCount == 1 && ErrorPacket.isErrorPacket(responsePacket)) {
            this.errorPacket = ErrorPacket.parse(responsePacket, this.connectionInfo.getJavaCharset());
            return true;
        }
        return false;
    }

    @Override
    public MysqlServerStatusInfo getServerStatusInfo() {
        return this.serverStatusInfo;
    }

    public String toString() {
        return "SQLCommand{sql='" + this.sql + '\'' + ", receivedPacketCount=" + this.receivedPacketCount + ", receivedEOFPacketCount=" + this.receivedEOFPacketCount + ", hasTextResultSet=" + this.hasTextResultSet + ", affectedRows=" + this.affectedRows + ", lastInsertId=" + this.lastInsertId + ", errorPacket=" + this.errorPacket + ", serverStatusInfo=" + this.serverStatusInfo + '}';
    }
}

