/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.datasource;

import com.heimuheimu.mysql.jdbc.util.LogBuildUtil;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceConfiguration.class);
    private final int poolSize;
    private final long checkoutTimeout;
    private final int maxOccupyTime;
    private final int timeout;
    private final int slowExecutionThreshold;

    public DataSourceConfiguration(int poolSize, long checkoutTimeout, int maxOccupyTime, int timeout, int slowExecutionThreshold) throws IllegalArgumentException {
        this.poolSize = poolSize;
        this.checkoutTimeout = checkoutTimeout;
        this.maxOccupyTime = maxOccupyTime;
        this.timeout = timeout;
        this.slowExecutionThreshold = slowExecutionThreshold;
        if (poolSize <= 0) {
            String errorLog = "Create `DataSourceConfiguration` failed: `poolSize could not be equal or less than 0`." + this.buildLogForParameters();
            LOG.error(errorLog);
            throw new IllegalArgumentException(errorLog);
        }
        if (checkoutTimeout < 0L) {
            String errorLog = "Create `DataSourceConfiguration` failed: `checkoutTimeout could not be less than 0`." + this.buildLogForParameters();
            LOG.error(errorLog);
            throw new IllegalArgumentException(errorLog);
        }
        if (maxOccupyTime < 0) {
            String errorLog = "Create `DataSourceConfiguration` failed: `maxOccupyTime could not be less than 0`." + this.buildLogForParameters();
            LOG.error(errorLog);
            throw new IllegalArgumentException(errorLog);
        }
        if (timeout < 0) {
            String errorLog = "Create `DataSourceConfiguration` failed: `timeout could not be less than 0`." + this.buildLogForParameters();
            LOG.error(errorLog);
            throw new IllegalArgumentException(errorLog);
        }
        if (slowExecutionThreshold <= 0) {
            String errorLog = "Create `DataSourceConfiguration` failed: `slowExecutionThreshold could not be equal or less than 0`." + this.buildLogForParameters();
            LOG.error(errorLog);
            throw new IllegalArgumentException(errorLog);
        }
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public long getCheckoutTimeout() {
        return this.checkoutTimeout;
    }

    public int getMaxOccupyTime() {
        return this.maxOccupyTime;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getSlowExecutionThreshold() {
        return this.slowExecutionThreshold;
    }

    private String buildLogForParameters() {
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        parameterMap.put("poolSize", this.poolSize);
        parameterMap.put("checkoutTimeout", this.checkoutTimeout);
        parameterMap.put("maxOccupyTime", this.maxOccupyTime);
        parameterMap.put("timeout", this.timeout);
        parameterMap.put("slowExecutionThreshold", this.slowExecutionThreshold);
        return LogBuildUtil.build(parameterMap);
    }

    public String toString() {
        return "DataSourceConfiguration{poolSize=" + this.poolSize + ", checkoutTimeout=" + this.checkoutTimeout + ", maxOccupyTime=" + this.maxOccupyTime + ", timeout=" + this.timeout + ", slowExecutionThreshold=" + this.slowExecutionThreshold + '}';
    }
}

