/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.datasource;

import com.heimuheimu.mysql.jdbc.ConnectionConfiguration;
import com.heimuheimu.mysql.jdbc.ConnectionInfo;
import com.heimuheimu.mysql.jdbc.datasource.MysqlDataSource;
import com.heimuheimu.mysql.jdbc.datasource.MysqlPooledConnection;
import com.heimuheimu.mysql.jdbc.monitor.DataSourceMonitor;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeakedConnectionDetector {
    private static final Logger LOG = LoggerFactory.getLogger(LeakedConnectionDetector.class);
    private static final Logger MYSQL_CONNECTION_LOG = LoggerFactory.getLogger((String)"MYSQL_CONNECTION_LOG");
    private static final CopyOnWriteArrayList<MysqlDataSource> DATASOURCE_LIST = new CopyOnWriteArrayList();
    private static final Object LOCK = new Object();
    private static volatile boolean IS_DETECT_TASK_RUNNING = false;

    public static void register(MysqlDataSource dataSource) {
        DATASOURCE_LIST.add(dataSource);
        LeakedConnectionDetector.startDetectTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startDetectTask() {
        Object object = LOCK;
        synchronized (object) {
            if (!IS_DETECT_TASK_RUNNING) {
                IS_DETECT_TASK_RUNNING = true;
                LeakedConnectionDetectTask detectTask = new LeakedConnectionDetectTask();
                detectTask.setName("leaked-mysql-connection-detector");
                detectTask.setDaemon(true);
                detectTask.start();
            }
        }
    }

    private static class LeakedConnectionDetectTask
    extends Thread {
        private LeakedConnectionDetectTask() {
        }

        @Override
        public void run() {
            MYSQL_CONNECTION_LOG.info("Leaked connection detect task started.");
            try {
                while (true) {
                    for (MysqlDataSource dataSource : DATASOURCE_LIST) {
                        List<MysqlPooledConnection> connectionList = dataSource.getConnectionList();
                        DataSourceMonitor dataSourceMonitor = dataSource.getDataSourceMonitor();
                        for (int i = 0; i < connectionList.size(); ++i) {
                            try {
                                MysqlPooledConnection connection = connectionList.get(i);
                                if (connection == null || !connection.isLeaked()) continue;
                                ConnectionInfo connectionInfo = connection.getMysqlChannel().getConnectionInfo();
                                ConnectionConfiguration connectionConfiguration = connection.getMysqlChannel().getConnectionConfiguration();
                                MYSQL_CONNECTION_LOG.warn("Found leaked connection. `connectionId`:`{}`. `host`:`{}`. `databaseName`:`{}`.", new Object[]{connectionInfo != null ? Long.valueOf(connectionInfo.getConnectionId()) : "", connectionConfiguration.getHost(), connectionConfiguration.getDatabaseName()});
                                dataSourceMonitor.onConnectionLeaked();
                                connection.closePhysicalConnection();
                                continue;
                            }
                            catch (Exception e) {
                                LOG.error("Leaked connection detect failed: `unexpected error`.", (Throwable)e);
                            }
                        }
                    }
                    Thread.sleep(5000L);
                }
            }
            catch (Exception e) {
                LOG.error("Leaked connection detect task execute failed: `unexpected error`.", (Throwable)e);
                MYSQL_CONNECTION_LOG.error("Leaked connection detect task stopped: `unexpected error`.");
                return;
            }
        }
    }
}

