/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.datasource;

import com.heimuheimu.mysql.jdbc.ConnectionConfiguration;
import com.heimuheimu.mysql.jdbc.MysqlConnection;
import com.heimuheimu.mysql.jdbc.constant.BeanStatusEnum;
import com.heimuheimu.mysql.jdbc.datasource.DataSourceConfiguration;
import com.heimuheimu.mysql.jdbc.datasource.LeakedConnectionDetector;
import com.heimuheimu.mysql.jdbc.datasource.MysqlPooledConnection;
import com.heimuheimu.mysql.jdbc.datasource.listener.MysqlDataSourceListener;
import com.heimuheimu.mysql.jdbc.datasource.listener.SilentMysqlDataSourceListener;
import com.heimuheimu.mysql.jdbc.facility.SQLFeatureNotSupportedExceptionBuilder;
import com.heimuheimu.mysql.jdbc.facility.parameter.ConstructorParameterChecker;
import com.heimuheimu.mysql.jdbc.facility.parameter.Parameters;
import com.heimuheimu.mysql.jdbc.monitor.DataSourceMonitor;
import com.heimuheimu.mysql.jdbc.monitor.DataSourceMonitorFactory;
import com.heimuheimu.mysql.jdbc.net.SocketConfiguration;
import com.heimuheimu.mysql.jdbc.util.LogBuildUtil;
import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlDataSource
implements DataSource,
Closeable {
    private static final Logger MYSQL_CONNECTION_LOG = LoggerFactory.getLogger((String)"MYSQL_CONNECTION_LOG");
    private static final Logger LOG = LoggerFactory.getLogger(MysqlDataSource.class);
    private final ConnectionConfiguration connectionConfiguration;
    private final DataSourceConfiguration dataSourceConfiguration;
    private final MysqlDataSourceListener listener;
    private final DataSourceMonitor dataSourceMonitor;
    private final CopyOnWriteArrayList<MysqlPooledConnection> connectionList = new CopyOnWriteArrayList();
    private final Object connectionListUpdateLock = new Object();
    private final LinkedBlockingQueue<Integer> availableConnectionIndexQueue = new LinkedBlockingQueue();
    private boolean isRescueTaskRunning = false;
    private final Object rescueTaskLock = new Object();
    private volatile BeanStatusEnum state = BeanStatusEnum.NORMAL;

    public MysqlDataSource(ConnectionConfiguration connectionConfiguration, DataSourceConfiguration dataSourceConfiguration, MysqlDataSourceListener listener) throws IllegalArgumentException {
        ConstructorParameterChecker checker = new ConstructorParameterChecker("MysqlDataSource", LOG);
        checker.addParameter("connectionConfiguration", connectionConfiguration);
        checker.addParameter("dataSourceConfiguration", dataSourceConfiguration);
        checker.check("connectionConfiguration", "isNull", Parameters::isNull);
        checker.check("dataSourceConfiguration", "isNull", Parameters::isNull);
        this.connectionConfiguration = connectionConfiguration;
        this.dataSourceConfiguration = dataSourceConfiguration;
        this.listener = new SilentMysqlDataSourceListener(listener);
        this.dataSourceMonitor = DataSourceMonitorFactory.get(connectionConfiguration.getHost(), connectionConfiguration.getDatabaseName());
        boolean hasAvailableClient = false;
        for (int i = 0; i < dataSourceConfiguration.getPoolSize(); ++i) {
            boolean isSuccess = this.createConnection(-1);
            if (isSuccess) {
                hasAvailableClient = true;
                MYSQL_CONNECTION_LOG.info("Add `MysqlConnection` success. `clientIndex`:`{}`. `host`:`{}`. `databaseName`:`{}`.", new Object[]{i, connectionConfiguration.getHost(), connectionConfiguration.getDatabaseName()});
                this.listener.onCreated(connectionConfiguration.getHost(), connectionConfiguration.getDatabaseName());
                continue;
            }
            MYSQL_CONNECTION_LOG.error("Add `MysqlConnection` failed. `clientIndex`:`{}`. `host`:`{}`. `databaseName`:`{}`.", new Object[]{i, connectionConfiguration.getHost(), connectionConfiguration.getDatabaseName()});
            this.listener.onClosed(connectionConfiguration.getHost(), connectionConfiguration.getDatabaseName());
        }
        if (!hasAvailableClient) {
            String errorMessage = "There is no available `MysqlConnection`. `host`:`" + connectionConfiguration.getHost() + "`. `databaseName`:`" + connectionConfiguration.getDatabaseName() + "`.";
            LOG.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        LeakedConnectionDetector.register(this);
    }

    @Override
    public Connection getConnection() throws SQLException {
        MysqlPooledConnection connection = null;
        try {
            long checkoutTimeout;
            long leftCheckoutTimeout = checkoutTimeout = this.dataSourceConfiguration.getCheckoutTimeout();
            int retryTimes = 0;
            while (connection == null && retryTimes < this.dataSourceConfiguration.getPoolSize()) {
                Integer connectionIndex;
                ++retryTimes;
                if (checkoutTimeout == 0L) {
                    connectionIndex = this.availableConnectionIndexQueue.take();
                } else {
                    long startTime = System.currentTimeMillis();
                    if (leftCheckoutTimeout > 0L) {
                        connectionIndex = this.availableConnectionIndexQueue.poll(leftCheckoutTimeout, TimeUnit.MILLISECONDS);
                        leftCheckoutTimeout -= System.currentTimeMillis() - startTime;
                    } else {
                        connectionIndex = this.availableConnectionIndexQueue.poll();
                    }
                }
                if (connectionIndex == null) continue;
                connection = this.connectionList.get(connectionIndex);
                if (connection != null) {
                    if (connection.acquire(this.dataSourceConfiguration.getMaxOccupyTime())) continue;
                    connection = null;
                    continue;
                }
                this.startRescueTask();
            }
        }
        catch (Exception e) {
            String errorMessage = "Get available `MysqlConnection` failed: `unexpected error`." + this.buildLogForParameters();
            LOG.error(errorMessage, (Throwable)e);
            throw new SQLException(errorMessage, e);
        }
        if (connection != null) {
            this.dataSourceMonitor.onConnectionAcquired();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Get `MysqlConnection` success. `clientIndex`:`{}`. `host`:`{}`. `databaseName`:`{}`.", new Object[]{connection.getConnectionIndex(), this.connectionConfiguration.getHost(), this.connectionConfiguration.getDatabaseName()});
            }
            return connection;
        }
        this.dataSourceMonitor.onGetConnectionFailed();
        String errorMessage = "Get available `MysqlConnection` failed: `no available connection`." + this.buildLogForParameters();
        LOG.error(errorMessage);
        throw new SQLException(errorMessage);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public int getLoginTimeout() {
        SocketConfiguration socketConfiguration = this.connectionConfiguration.getSocketConfiguration();
        if (socketConfiguration == null) {
            return SocketConfiguration.DEFAULT.getConnectionTimeout() / 1000;
        }
        return socketConfiguration.getConnectionTimeout() / 1000;
    }

    @Override
    public synchronized void close() {
        if (this.state != BeanStatusEnum.CLOSED) {
            this.state = BeanStatusEnum.CLOSED;
            for (MysqlPooledConnection connection : this.connectionList) {
                if (connection == null) continue;
                connection.closePhysicalConnection();
            }
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return MysqlDataSource.class == iface;
    }

    List<MysqlPooledConnection> getConnectionList() {
        return this.connectionList;
    }

    DataSourceMonitor getDataSourceMonitor() {
        return this.dataSourceMonitor;
    }

    protected void prepareConnection(MysqlPooledConnection pooledConnection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createConnection(int connectionIndex) {
        MysqlConnection connection = null;
        if (connectionIndex < 0) {
            connectionIndex = this.connectionList.size();
        }
        try {
            connection = new MysqlPooledConnection(connectionIndex, this.connectionConfiguration, this.dataSourceConfiguration.getTimeout(), this.dataSourceConfiguration.getSlowExecutionThreshold(), this::removeUnavailableClient, this::onPooledConnectionClosed);
            this.prepareConnection((MysqlPooledConnection)connection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.connectionListUpdateLock;
        synchronized (object) {
            if (connection != null && !connection.isClosed()) {
                if (connectionIndex < this.connectionList.size()) {
                    this.connectionList.set(connectionIndex, (MysqlPooledConnection)connection);
                } else {
                    this.connectionList.add((MysqlPooledConnection)connection);
                }
                this.availableConnectionIndexQueue.add(connectionIndex);
                return true;
            }
            if (connectionIndex < this.connectionList.size()) {
                this.connectionList.set(connectionIndex, null);
            } else {
                this.connectionList.add(null);
            }
            return false;
        }
    }

    private void onPooledConnectionClosed(MysqlPooledConnection pooledConnection) {
        this.dataSourceMonitor.onConnectionReleased();
        this.availableConnectionIndexQueue.add(pooledConnection.getConnectionIndex());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Return `MysqlConnection` success. `clientIndex`:`{}`. `host`:`{}`. `databaseName`:`{}`.", new Object[]{pooledConnection.getConnectionIndex(), this.connectionConfiguration.getHost(), this.connectionConfiguration.getDatabaseName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnavailableClient(MysqlConnection unavailableConnection) {
        if (unavailableConnection == null) {
            String errorMessage = "Remove unavailable mysql connection failed: `null client`." + this.buildLogForParameters();
            LOG.error(errorMessage);
            throw new NullPointerException(errorMessage);
        }
        boolean isRemoveSuccess = false;
        Object object = this.connectionListUpdateLock;
        synchronized (object) {
            int clientIndex = this.connectionList.indexOf(unavailableConnection);
            if (clientIndex >= 0) {
                this.connectionList.set(clientIndex, null);
                isRemoveSuccess = true;
                MysqlPooledConnection unavailablePooledConnection = (MysqlPooledConnection)unavailableConnection;
                unavailablePooledConnection.close();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Remove `MysqlConnection` from connection list success. `clientIndex`:`{}`.{}", (Object)clientIndex, (Object)this.buildLogForParameters());
                }
            }
        }
        if (isRemoveSuccess && this.state != BeanStatusEnum.CLOSED) {
            this.startRescueTask();
            this.listener.onClosed(this.connectionConfiguration.getHost(), this.connectionConfiguration.getDatabaseName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRescueTask() {
        if (this.state == BeanStatusEnum.NORMAL) {
            Object object = this.rescueTaskLock;
            synchronized (object) {
                if (!this.isRescueTaskRunning) {
                    Thread rescueThread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            long startTime = System.currentTimeMillis();
                            MYSQL_CONNECTION_LOG.info("MysqlConnection rescue task has been started. `host`:`{}`. `databaseName`:`{}`.", (Object)MysqlDataSource.this.connectionConfiguration.getHost(), (Object)MysqlDataSource.this.connectionConfiguration.getDatabaseName());
                            try {
                                while (MysqlDataSource.this.state == BeanStatusEnum.NORMAL) {
                                    boolean hasRecovered = true;
                                    for (int i = 0; i < MysqlDataSource.this.connectionList.size(); ++i) {
                                        if (MysqlDataSource.this.connectionList.get(i) != null) continue;
                                        boolean isSuccess = MysqlDataSource.this.createConnection(i);
                                        if (isSuccess) {
                                            MYSQL_CONNECTION_LOG.info("Rescue MysqlConnection success. `clientIndex`:`{}`. `host`:`{}`. `databaseName`:`{}`.", new Object[]{i, MysqlDataSource.this.connectionConfiguration.getHost(), MysqlDataSource.this.connectionConfiguration.getDatabaseName()});
                                            MysqlDataSource.this.listener.onRecovered(MysqlDataSource.this.connectionConfiguration.getHost(), MysqlDataSource.this.connectionConfiguration.getDatabaseName());
                                            continue;
                                        }
                                        hasRecovered = false;
                                        MYSQL_CONNECTION_LOG.warn("Rescue MysqlConnection failed. `clientIndex`:`{}`. `host`:`{}`. `databaseName`:`{}`.", new Object[]{i, MysqlDataSource.this.connectionConfiguration.getHost(), MysqlDataSource.this.connectionConfiguration.getDatabaseName()});
                                    }
                                    if (hasRecovered) break;
                                    Thread.sleep(500L);
                                }
                                MYSQL_CONNECTION_LOG.info("MysqlConnection rescue task has been finished. `cost`: {}ms. `host`:`{}`. `databaseName`:`{}`.", new Object[]{System.currentTimeMillis() - startTime, MysqlDataSource.this.connectionConfiguration.getHost(), MysqlDataSource.this.connectionConfiguration.getDatabaseName()});
                            }
                            catch (Exception e) {
                                MYSQL_CONNECTION_LOG.error("MysqlConnection rescue task execute failed: `{}`. `cost`:`{}ms`. `host`:`{}`. `databaseName`:`{}`.", new Object[]{e.getMessage(), System.currentTimeMillis() - startTime, MysqlDataSource.this.connectionConfiguration.getHost(), MysqlDataSource.this.connectionConfiguration.getDatabaseName()});
                                LOG.error("MysqlConnection rescue task execute failed. `cost`:`" + (System.currentTimeMillis() - startTime) + "ms`. `host`:`" + MysqlDataSource.this.connectionConfiguration.getHost() + "`. `databaseName`:`" + MysqlDataSource.this.connectionConfiguration.getDatabaseName() + "`.", (Throwable)e);
                            }
                            finally {
                                this.rescueOver();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private void rescueOver() {
                            Object object = MysqlDataSource.this.rescueTaskLock;
                            synchronized (object) {
                                MysqlDataSource.this.isRescueTaskRunning = false;
                            }
                        }
                    };
                    rescueThread.setName("mysql-connection-rescue-task");
                    rescueThread.setDaemon(true);
                    rescueThread.start();
                    this.isRescueTaskRunning = true;
                }
            }
        }
    }

    private String buildLogForParameters() {
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        parameterMap.put("connectionConfiguration", this.connectionConfiguration);
        parameterMap.put("dataSourceConfiguration", this.dataSourceConfiguration);
        return LogBuildUtil.build(parameterMap);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlDataSource#getLogWriter()");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlDataSource#setLogWriter(PrintWriter out)");
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlDataSource#getParentLogger()");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("MysqlDataSource#setLoginTimeout(int seconds)", "You should use SocketConfiguration#setConnectionTimeout(int connectionTimeout)");
    }
}

