/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.datasource;

import com.heimuheimu.mysql.jdbc.ConnectionConfiguration;
import com.heimuheimu.mysql.jdbc.MysqlConnection;
import com.heimuheimu.mysql.jdbc.datasource.PooledConnectionClosedNotifier;
import com.heimuheimu.mysql.jdbc.facility.UnusableServiceNotifier;
import com.heimuheimu.mysql.jdbc.net.BuildSocketException;

public class MysqlPooledConnection
extends MysqlConnection {
    private final int connectionIndex;
    private final PooledConnectionClosedNotifier closedNotifier;
    private boolean isAcquired = false;
    private long lastAcquiredTimestamp = 0L;
    private long maxOccupyTime = 0L;
    private final Object acquireLock = new Object();

    public MysqlPooledConnection(int connectionIndex, ConnectionConfiguration configuration, int timeout, int slowExecutionThreshold, UnusableServiceNotifier<MysqlConnection> unusableServiceNotifier, PooledConnectionClosedNotifier closedNotifier) throws IllegalArgumentException, BuildSocketException {
        super(configuration, timeout, slowExecutionThreshold, unusableServiceNotifier);
        this.connectionIndex = connectionIndex;
        this.closedNotifier = closedNotifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquire(long maxOccupyTime) {
        if (this.isClosed()) {
            return false;
        }
        Object object = this.acquireLock;
        synchronized (object) {
            if (!this.isAcquired) {
                this.isAcquired = true;
                this.lastAcquiredTimestamp = System.currentTimeMillis();
                this.maxOccupyTime = maxOccupyTime;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLeaked() {
        Object object = this.acquireLock;
        synchronized (object) {
            if (this.isAcquired && this.maxOccupyTime > 0L) {
                return System.currentTimeMillis() - this.lastAcquiredTimestamp > this.maxOccupyTime;
            }
            return false;
        }
    }

    public int getConnectionIndex() {
        return this.connectionIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.acquireLock;
        synchronized (object) {
            if (this.isAcquired) {
                this.isAcquired = false;
                if (this.closedNotifier != null) {
                    this.closedNotifier.onClosed(this);
                }
            }
        }
    }

    public void closePhysicalConnection() {
        super.close();
    }

    @Override
    public String toString() {
        return "MysqlPooledConnection{connectionIndex=" + this.connectionIndex + ", isAcquired=" + this.isAcquired + ", lastAcquiredTimestamp=" + this.lastAcquiredTimestamp + ", maxOccupyTime=" + this.maxOccupyTime + ", mysqlChannel=" + this.mysqlChannel + ", lastServerStatusInfo=" + this.lastServerStatusInfo + ", executionMonitor=" + this.executionMonitor + ", databaseMonitor=" + this.databaseMonitor + ", timeout=" + this.timeout + ", slowExecutionThreshold=" + this.slowExecutionThreshold + ", currentDatabaseName='" + this.currentDatabaseName + '\'' + ", transactionIsolation=" + this.transactionIsolation + ", readOnlyFlag=" + this.readOnlyFlag + '}';
    }
}

