/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.datasource.listener;

import com.heimuheimu.mysql.jdbc.datasource.listener.MysqlDataSourceListener;
import com.heimuheimu.naivemonitor.alarm.NaiveServiceAlarm;
import com.heimuheimu.naivemonitor.alarm.ServiceAlarmMessageNotifier;
import com.heimuheimu.naivemonitor.alarm.ServiceContext;
import com.heimuheimu.naivemonitor.util.MonitorUtil;
import java.util.List;
import java.util.Map;

public class NoticeableMysqlDataSourceListener
implements MysqlDataSourceListener {
    private final String project;
    private final String host;
    private final NaiveServiceAlarm naiveServiceAlarm;

    public NoticeableMysqlDataSourceListener(String project, List<ServiceAlarmMessageNotifier> notifierList) throws IllegalArgumentException {
        this(project, notifierList, null);
    }

    public NoticeableMysqlDataSourceListener(String project, List<ServiceAlarmMessageNotifier> notifierList, Map<String, String> hostAliasMap) throws IllegalArgumentException {
        this.project = project;
        this.naiveServiceAlarm = new NaiveServiceAlarm(notifierList);
        String host = MonitorUtil.getLocalHostName();
        this.host = hostAliasMap != null && hostAliasMap.containsKey(host) ? hostAliasMap.get(host) : host;
    }

    @Override
    public void onCreated(String host, String databaseName) {
    }

    @Override
    public void onRecovered(String host, String databaseName) {
        this.naiveServiceAlarm.onRecovered(this.getServiceContext(host, databaseName));
    }

    @Override
    public void onClosed(String host, String databaseName) {
        this.naiveServiceAlarm.onCrashed(this.getServiceContext(host, databaseName));
    }

    protected ServiceContext getServiceContext(String databaseHost, String databaseName) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setName("MySQL Connection");
        serviceContext.setHost(this.host);
        serviceContext.setProject(this.project);
        serviceContext.setRemoteHost(databaseHost + "/" + databaseName);
        return serviceContext;
    }

    public String toString() {
        return "NoticeableMysqlDataSourceListener{project='" + this.project + '\'' + ", host='" + this.host + '\'' + ", naiveServiceAlarm=" + this.naiveServiceAlarm + '}';
    }
}

