/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.datasource.listener;

import com.heimuheimu.mysql.jdbc.datasource.listener.MysqlDataSourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SilentMysqlDataSourceListener
implements MysqlDataSourceListener {
    private static final Logger LOG = LoggerFactory.getLogger(SilentMysqlDataSourceListener.class);
    private final MysqlDataSourceListener target;

    public SilentMysqlDataSourceListener(MysqlDataSourceListener target) {
        this.target = target;
    }

    @Override
    public void onCreated(String host, String databaseName) {
        if (this.target != null) {
            try {
                this.target.onCreated(host, databaseName);
            }
            catch (Exception e) {
                LOG.error("Execute `MysqlDataSourceListener#onCreated(String host, String databaseName)` failed: `unexpected error`. `host`:`" + host + "`. `databaseName`:`" + databaseName + "`.", (Throwable)e);
            }
        }
    }

    @Override
    public void onRecovered(String host, String databaseName) {
        if (this.target != null) {
            try {
                this.target.onRecovered(host, databaseName);
            }
            catch (Exception e) {
                LOG.error("Execute `MysqlDataSourceListener#onRecovered(String host, String databaseName)` failed: `unexpected error`. `host`:`" + host + "`. `databaseName`:`" + databaseName + "`.", (Throwable)e);
            }
        }
    }

    @Override
    public void onClosed(String host, String databaseName) {
        if (this.target != null) {
            try {
                this.target.onClosed(host, databaseName);
            }
            catch (Exception e) {
                LOG.error("Execute `MysqlDataSourceListener#onClosed(String host, String databaseName)` failed: `unexpected error`. `host`:`" + host + "`. `databaseName`:`" + databaseName + "`.", (Throwable)e);
            }
        }
    }
}

