/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.facility.parameter;

import com.heimuheimu.mysql.jdbc.facility.parameter.Parameters;
import com.heimuheimu.mysql.jdbc.util.LogBuildUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructorParameterChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstructorParameterChecker.class);
    private final String className;
    private final Logger targetLogger;
    private final Map<String, Object> parameterMap = new LinkedHashMap<String, Object>();

    public ConstructorParameterChecker(String className, Logger targetLogger) {
        this.className = className != null ? className : "";
        this.targetLogger = targetLogger;
    }

    public void addParameter(String parameterName, Object parameterValue) {
        this.parameterMap.put(parameterName, parameterValue);
    }

    public <T> void check(String parameterName, String errorMessage, Predicate<T> predicate) throws IllegalArgumentException {
        boolean isIllegalArgument;
        try {
            Object parameterValue = this.parameterMap.get(parameterName);
            isIllegalArgument = predicate.test(parameterValue);
        }
        catch (Exception e) {
            LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
            parameterMap.put("className", this.className);
            parameterMap.put("parameterName", parameterName);
            parameterMap.put("parameterMap", this.parameterMap);
            LOGGER.error(LogBuildUtil.buildMethodExecuteFailedLog("ConstructorParameterChecker#check(String parameterName, String errorMessage, Predicate<T> predicate)", "check constructor parameter error", parameterMap), (Throwable)e);
            isIllegalArgument = true;
        }
        if (isIllegalArgument) {
            errorMessage = Parameters.getErrorMessage(parameterName, errorMessage);
            String errorLog = "Create `" + this.className + "` failed: `" + errorMessage + "`." + LogBuildUtil.build(this.parameterMap);
            if (this.targetLogger != null) {
                this.targetLogger.error(errorLog);
            }
            throw new IllegalArgumentException(errorLog);
        }
    }

    public Map<String, Object> getParameterMap() {
        return this.parameterMap;
    }

    public String toString() {
        return "ConstructorParameterChecker{className='" + this.className + '\'' + ", parameterMap=" + this.parameterMap + '}';
    }
}

