/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.facility.parameter;

import com.heimuheimu.mysql.jdbc.facility.parameter.IllegalMethodParameterCallback;
import com.heimuheimu.mysql.jdbc.facility.parameter.Parameters;
import com.heimuheimu.mysql.jdbc.util.LogBuildUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodParameterChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodParameterChecker.class);
    private final String methodName;
    private final Logger targetLogger;
    private final IllegalMethodParameterCallback illegalMethodParameterCallback;
    private final Map<String, Object> parameterMap = new LinkedHashMap<String, Object>();

    public MethodParameterChecker(String methodName, Logger targetLogger, IllegalMethodParameterCallback illegalMethodParameterCallback) {
        this.methodName = methodName != null ? methodName : "";
        this.targetLogger = targetLogger;
        this.illegalMethodParameterCallback = illegalMethodParameterCallback;
    }

    public void addParameter(String parameterName, Object parameterValue) {
        this.parameterMap.put(parameterName, parameterValue);
    }

    public <T> void check(String parameterName, String errorMessage, Predicate<T> predicate) throws IllegalArgumentException {
        boolean isIllegalArgument;
        try {
            Object parameterValue = this.parameterMap.get(parameterName);
            isIllegalArgument = predicate.test(parameterValue);
        }
        catch (Exception e) {
            LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
            parameterMap.put("methodName", this.methodName);
            parameterMap.put("parameterName", parameterName);
            parameterMap.put("parameterMap", this.parameterMap);
            LOGGER.error(LogBuildUtil.buildMethodExecuteFailedLog("MethodParameterChecker#check(String parameterName, String errorMessage, Predicate<T> predicate)", "check method parameter error", parameterMap), (Throwable)e);
            isIllegalArgument = true;
        }
        if (isIllegalArgument) {
            errorMessage = Parameters.getErrorMessage(parameterName, errorMessage);
            String errorLog = LogBuildUtil.buildMethodExecuteFailedLog(this.methodName, errorMessage, this.parameterMap);
            if (this.targetLogger != null) {
                this.targetLogger.error(errorLog);
            }
            if (this.illegalMethodParameterCallback != null) {
                this.illegalMethodParameterCallback.call(parameterName);
            }
            throw new IllegalArgumentException(errorLog);
        }
    }

    public Map<String, Object> getParameterMap() {
        return this.parameterMap;
    }

    public String toString() {
        return "MethodParameterChecker{methodName='" + this.methodName + '\'' + ", parameterMap=" + this.parameterMap + '}';
    }
}

