/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.monitor;

import java.util.concurrent.atomic.AtomicLong;

public class DataSourceMonitor {
    private final AtomicLong connectionLeakedCount = new AtomicLong(0L);
    private final AtomicLong getConnectionFailedCount = new AtomicLong(0L);
    private final AtomicLong acquiredConnectionCount = new AtomicLong(0L);
    private volatile long maxAcquiredConnectionCount = 0L;

    public void onConnectionLeaked() {
        this.connectionLeakedCount.incrementAndGet();
    }

    public void onGetConnectionFailed() {
        this.getConnectionFailedCount.incrementAndGet();
    }

    public void onConnectionAcquired() {
        long currentAcquiredCount = this.acquiredConnectionCount.incrementAndGet();
        if (currentAcquiredCount > this.maxAcquiredConnectionCount) {
            this.maxAcquiredConnectionCount = currentAcquiredCount;
        }
    }

    public void onConnectionReleased() {
        this.acquiredConnectionCount.decrementAndGet();
    }

    public void resetMaxAcquiredConnectionCount() {
        this.maxAcquiredConnectionCount = 0L;
    }

    public long getConnectionLeakedCount() {
        return this.connectionLeakedCount.get();
    }

    public long getGetConnectionFailedCount() {
        return this.getConnectionFailedCount.get();
    }

    public long getAcquiredConnectionCount() {
        return this.acquiredConnectionCount.get();
    }

    public long getMaxAcquiredConnectionCount() {
        return this.maxAcquiredConnectionCount;
    }

    public String toString() {
        return "DataSourceMonitor{connectionLeakedCount=" + this.connectionLeakedCount + ", getConnectionFailedCount=" + this.getConnectionFailedCount + ", acquiredConnectionCount=" + this.acquiredConnectionCount + ", maxAcquiredConnectionCount=" + this.maxAcquiredConnectionCount + '}';
    }
}

