/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.monitor;

import com.heimuheimu.mysql.jdbc.constant.SQLType;
import java.util.concurrent.atomic.AtomicLong;

public class DatabaseMonitor {
    private final AtomicLong selectRowsCount = new AtomicLong(0L);
    private volatile long maxSelectRowsCount = 0L;
    private final AtomicLong insertRowsCount = new AtomicLong(0L);
    private volatile long maxInsertRowsCount = 0L;
    private final AtomicLong updateRowsCount = new AtomicLong(0L);
    private volatile long maxUpdateRowsCount = 0L;
    private final AtomicLong deleteRowsCount = new AtomicLong(0L);
    private volatile long maxDeleteRowsCount = 0L;

    public void onSelectExecuted(long rowsCount) {
        this.selectRowsCount.addAndGet(rowsCount);
        if (this.maxSelectRowsCount < rowsCount) {
            this.maxSelectRowsCount = rowsCount;
        }
    }

    public void onExecuted(SQLType sqlType, long rowsCount) {
        switch (sqlType) {
            case INSERT: {
                this.insertRowsCount.addAndGet(rowsCount);
                if (this.maxInsertRowsCount >= rowsCount) break;
                this.maxInsertRowsCount = rowsCount;
                break;
            }
            case UPDATE: {
                this.updateRowsCount.addAndGet(rowsCount);
                if (this.maxUpdateRowsCount >= rowsCount) break;
                this.maxUpdateRowsCount = rowsCount;
                break;
            }
            case DELETE: {
                this.deleteRowsCount.addAndGet(rowsCount);
                if (this.maxDeleteRowsCount >= rowsCount) break;
                this.maxDeleteRowsCount = rowsCount;
                break;
            }
            case SELECT: {
                this.onSelectExecuted(rowsCount);
                break;
            }
        }
    }

    public long getSelectRowsCount() {
        return this.selectRowsCount.get();
    }

    public long getMaxSelectRowsCount() {
        return this.maxSelectRowsCount;
    }

    public void resetMaxSelectRowsCount() {
        this.maxSelectRowsCount = 0L;
    }

    public long getInsertRowsCount() {
        return this.insertRowsCount.get();
    }

    public long getMaxInsertRowsCount() {
        return this.maxInsertRowsCount;
    }

    public void resetMaxInsertRowsCount() {
        this.maxInsertRowsCount = 0L;
    }

    public long getUpdateRowsCount() {
        return this.updateRowsCount.get();
    }

    public long getMaxUpdateRowsCount() {
        return this.maxUpdateRowsCount;
    }

    public void resetMaxUpdateRowsCount() {
        this.maxUpdateRowsCount = 0L;
    }

    public long getDeleteRowsCount() {
        return this.deleteRowsCount.get();
    }

    public long getMaxDeleteRowsCount() {
        return this.maxDeleteRowsCount;
    }

    public void resetMaxDeleteRowsCount() {
        this.maxDeleteRowsCount = 0L;
    }

    public String toString() {
        return "DatabaseMonitor{selectRowsCount=" + this.selectRowsCount + ", maxSelectRowsCount=" + this.maxSelectRowsCount + ", insertRowsCount=" + this.insertRowsCount + ", maxInsertRowsCount=" + this.maxInsertRowsCount + ", updateRowsCount=" + this.updateRowsCount + ", maxUpdateRowsCount=" + this.maxUpdateRowsCount + ", deleteRowsCount=" + this.deleteRowsCount + ", maxDeleteRowsCount=" + this.maxDeleteRowsCount + '}';
    }
}

