/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.monitor;

import com.heimuheimu.naivemonitor.monitor.ExecutionMonitor;
import java.util.concurrent.ConcurrentHashMap;

public class ExecutionMonitorFactory {
    public static final int ERROR_CODE_MYSQL_ERROR = -1;
    public static final int ERROR_CODE_ILLEGAL_STATE = -2;
    public static final int ERROR_CODE_TIMEOUT = -3;
    public static final int ERROR_CODE_INVALID_PARAMETER = -4;
    public static final int ERROR_CODE_RESULTSET_ERROR = -5;
    public static final int ERROR_CODE_UNEXPECTED_ERROR = -6;
    public static final int ERROR_CODE_SLOW_EXECUTION = -7;
    private static final ConcurrentHashMap<String, ExecutionMonitor> MYSQL_EXECUTION_MONITOR_MAP = new ConcurrentHashMap();
    private static final Object lock = new Object();

    private ExecutionMonitorFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionMonitor get(String host, String databaseName) {
        ExecutionMonitor monitor;
        String key = host;
        if (databaseName != null && !databaseName.isEmpty()) {
            key = key + "/" + databaseName;
        }
        if ((monitor = MYSQL_EXECUTION_MONITOR_MAP.get(key)) == null) {
            Object object = lock;
            synchronized (object) {
                monitor = MYSQL_EXECUTION_MONITOR_MAP.get(key);
                if (monitor == null) {
                    monitor = new ExecutionMonitor();
                    MYSQL_EXECUTION_MONITOR_MAP.put(key, monitor);
                }
            }
        }
        return monitor;
    }
}

