/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.monitor.falcon;

import com.heimuheimu.mysql.jdbc.monitor.DataSourceMonitor;
import com.heimuheimu.mysql.jdbc.monitor.DataSourceMonitorFactory;
import com.heimuheimu.mysql.jdbc.monitor.DatabaseMonitor;
import com.heimuheimu.mysql.jdbc.monitor.DatabaseMonitorFactory;
import com.heimuheimu.mysql.jdbc.monitor.falcon.DatabaseExecutionDataCollector;
import com.heimuheimu.mysql.jdbc.monitor.falcon.DatabaseSocketDataCollector;
import com.heimuheimu.mysql.jdbc.util.MysqlConnectionBuildUtil;
import com.heimuheimu.naivemonitor.falcon.FalconData;
import com.heimuheimu.naivemonitor.falcon.support.AbstractFalconDataCollector;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DatabaseDataCollector
extends AbstractFalconDataCollector {
    private final DatabaseSocketDataCollector databaseSocketDataCollector;
    private final DatabaseExecutionDataCollector databaseExecutionDataCollector;
    private final DatabaseMonitor databaseMonitor;
    private final String collectorName;
    private volatile long lastSelectRowsCount = 0L;
    private volatile long lastInsertRowsCount = 0L;
    private volatile long lastUpdateRowsCount = 0L;
    private volatile long lastDeleteRowsCount = 0L;
    private final DataSourceMonitor dataSourceMonitor;
    private volatile long lastConnectionLeakedCount = 0L;
    private volatile long lastGetConnectionFailedCount = 0L;

    public DatabaseDataCollector(String jdbcURL, String collectorName) throws IllegalArgumentException {
        try {
            Map<String, Object> properties = MysqlConnectionBuildUtil.parseURL(jdbcURL);
            String host = (String)properties.get("host");
            String databaseName = (String)properties.get("databaseName");
            this.collectorName = collectorName;
            this.databaseSocketDataCollector = new DatabaseSocketDataCollector(host, databaseName, this.collectorName);
            this.databaseExecutionDataCollector = new DatabaseExecutionDataCollector(host, databaseName, this.collectorName);
            this.databaseMonitor = DatabaseMonitorFactory.get(host, databaseName);
            this.dataSourceMonitor = DataSourceMonitorFactory.get(host, databaseName);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Create `DatabaseDataCollector` failed: `invalid jdbc url`. `jdbcURL`:`" + jdbcURL + "`.", e);
        }
    }

    public DatabaseDataCollector(String host, String databaseName, String collectorName) {
        this.collectorName = collectorName;
        this.databaseSocketDataCollector = new DatabaseSocketDataCollector(host, databaseName, this.collectorName);
        this.databaseExecutionDataCollector = new DatabaseExecutionDataCollector(host, databaseName, this.collectorName);
        this.databaseMonitor = DatabaseMonitorFactory.get(host, databaseName);
        this.dataSourceMonitor = DataSourceMonitorFactory.get(host, databaseName);
    }

    public List<FalconData> getList() {
        ArrayList<FalconData> falconDataList = new ArrayList<FalconData>();
        falconDataList.addAll(this.databaseSocketDataCollector.getList());
        falconDataList.addAll(this.databaseExecutionDataCollector.getList());
        long selectRowsCount = this.databaseMonitor.getSelectRowsCount();
        falconDataList.add(this.create("_select_rows_count", selectRowsCount - this.lastSelectRowsCount));
        this.lastSelectRowsCount = selectRowsCount;
        long maxSelectRowsCount = this.databaseMonitor.getMaxSelectRowsCount();
        this.databaseMonitor.resetMaxSelectRowsCount();
        falconDataList.add(this.create("_max_select_rows_count", maxSelectRowsCount));
        long insertRowsCount = this.databaseMonitor.getInsertRowsCount();
        falconDataList.add(this.create("_insert_rows_count", insertRowsCount - this.lastInsertRowsCount));
        this.lastInsertRowsCount = insertRowsCount;
        long maxInsertRowsCount = this.databaseMonitor.getMaxInsertRowsCount();
        this.databaseMonitor.resetMaxInsertRowsCount();
        falconDataList.add(this.create("_max_insert_rows_count", maxInsertRowsCount));
        long updateRowsCount = this.databaseMonitor.getUpdateRowsCount();
        falconDataList.add(this.create("_update_rows_count", updateRowsCount - this.lastUpdateRowsCount));
        this.lastUpdateRowsCount = updateRowsCount;
        long maxUpdateRowsCount = this.databaseMonitor.getMaxUpdateRowsCount();
        this.databaseMonitor.resetMaxUpdateRowsCount();
        falconDataList.add(this.create("_max_update_rows_count", maxUpdateRowsCount));
        long deleteRowsCount = this.databaseMonitor.getDeleteRowsCount();
        falconDataList.add(this.create("_delete_rows_count", deleteRowsCount - this.lastDeleteRowsCount));
        this.lastDeleteRowsCount = deleteRowsCount;
        long maxDeleteRowsCount = this.databaseMonitor.getMaxDeleteRowsCount();
        this.databaseMonitor.resetMaxDeleteRowsCount();
        falconDataList.add(this.create("_max_delete_rows_count", maxDeleteRowsCount));
        long acquiredConnectionCount = this.dataSourceMonitor.getAcquiredConnectionCount();
        falconDataList.add(this.create("_datasource_acquired_connection_count", acquiredConnectionCount));
        long maxAcquiredConnectionCount = this.dataSourceMonitor.getMaxAcquiredConnectionCount();
        this.dataSourceMonitor.resetMaxAcquiredConnectionCount();
        falconDataList.add(this.create("_datasource_max_acquired_connection_count", maxAcquiredConnectionCount));
        long connectionLeakedCount = this.dataSourceMonitor.getConnectionLeakedCount();
        falconDataList.add(this.create("_datasource_connection_leaked_count", connectionLeakedCount - this.lastConnectionLeakedCount));
        this.lastConnectionLeakedCount = connectionLeakedCount;
        long getConnectionFailedCount = this.dataSourceMonitor.getGetConnectionFailedCount();
        falconDataList.add(this.create("_datasource_get_connection_failed_count", getConnectionFailedCount - this.lastGetConnectionFailedCount));
        this.lastGetConnectionFailedCount = getConnectionFailedCount;
        return falconDataList;
    }

    protected String getModuleName() {
        return "mysql_jdbc";
    }

    protected String getCollectorName() {
        return this.collectorName;
    }

    public int getPeriod() {
        return 30;
    }
}

