/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.monitor.falcon;

import com.heimuheimu.mysql.jdbc.monitor.ExecutionMonitorFactory;
import com.heimuheimu.naivemonitor.falcon.support.AbstractExecutionDataCollector;
import com.heimuheimu.naivemonitor.monitor.ExecutionMonitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DatabaseExecutionDataCollector
extends AbstractExecutionDataCollector {
    private static final Map<Integer, String> ERROR_METRIC_SUFFIX_MAP = new HashMap<Integer, String>();
    private final List<ExecutionMonitor> executionMonitors;
    private final String collectorName;

    DatabaseExecutionDataCollector(String host, String databaseName, String collectorName) {
        this.executionMonitors = Collections.singletonList(ExecutionMonitorFactory.get(host, databaseName));
        this.collectorName = collectorName;
    }

    protected List<ExecutionMonitor> getExecutionMonitorList() {
        return this.executionMonitors;
    }

    protected String getModuleName() {
        return "mysql_jdbc";
    }

    protected String getCollectorName() {
        return this.collectorName;
    }

    protected Map<Integer, String> getErrorMetricSuffixMap() {
        return ERROR_METRIC_SUFFIX_MAP;
    }

    public int getPeriod() {
        return 30;
    }

    static {
        ERROR_METRIC_SUFFIX_MAP.put(-1, "_mysql_error");
        ERROR_METRIC_SUFFIX_MAP.put(-2, "_illegal_state");
        ERROR_METRIC_SUFFIX_MAP.put(-3, "_timeout");
        ERROR_METRIC_SUFFIX_MAP.put(-4, "_invalid_parameter");
        ERROR_METRIC_SUFFIX_MAP.put(-5, "_result_error");
        ERROR_METRIC_SUFFIX_MAP.put(-6, "_unexpected_error");
        ERROR_METRIC_SUFFIX_MAP.put(-7, "_sql_slow_execution");
    }
}

