/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.net;

import com.heimuheimu.mysql.jdbc.net.BuildSocketException;
import com.heimuheimu.mysql.jdbc.net.SocketConfiguration;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketBuilder.class);

    private SocketBuilder() {
    }

    public static Socket create(String host) throws IllegalArgumentException, BuildSocketException {
        return SocketBuilder.create(host, null);
    }

    public static Socket create(String host, SocketConfiguration config) throws IllegalArgumentException, BuildSocketException {
        int port;
        String hostname;
        try {
            String[] hostParts = host.split(":");
            hostname = hostParts[0];
            port = Integer.parseInt(hostParts[1]);
        }
        catch (Exception e) {
            LOGGER.error("Create socket failed: `invalid host`. Host: `" + host + "`. Config: `" + config + "`.", (Throwable)e);
            throw new IllegalArgumentException("Create socket failed: `invalid host`. Host: `" + host + "`. Config: `" + config + "`.", e);
        }
        return SocketBuilder.create(hostname, port, config);
    }

    public static Socket create(String hostname, int port) throws BuildSocketException {
        return SocketBuilder.create(hostname, port, null);
    }

    public static Socket create(String hostname, int port, SocketConfiguration config) throws BuildSocketException {
        try {
            if (config == null) {
                config = SocketConfiguration.DEFAULT;
            }
            Socket socket = new Socket();
            SocketBuilder.setConfig(socket, config);
            int connectionTimeout = config.getConnectionTimeout();
            if (connectionTimeout < 0) {
                connectionTimeout = 0;
            }
            socket.connect(new InetSocketAddress(hostname, port), connectionTimeout);
            return socket;
        }
        catch (Exception e) {
            LOGGER.error("Create socket failed: `" + e.getMessage() + "`. Hostname: `" + hostname + "`. Port: `" + port + "`. Config: `" + config + "`.", (Throwable)e);
            throw new BuildSocketException("Create socket failed: `" + e.getMessage() + "`. Hostname: `" + hostname + "`. Port: `" + port + "`. Config: `" + config + "`.", e);
        }
    }

    public static void setConfig(Socket socket, SocketConfiguration config) throws BuildSocketException {
        try {
            if (config == null) {
                config = SocketConfiguration.DEFAULT;
            }
            if (config.getKeepAlive() != null) {
                socket.setKeepAlive(config.getKeepAlive());
            }
            if (config.getTcpNoDelay() != null) {
                socket.setTcpNoDelay(config.getTcpNoDelay());
            }
            if (config.getSendBufferSize() != null) {
                socket.setSendBufferSize(config.getSendBufferSize());
            }
            if (config.getReceiveBufferSize() != null) {
                socket.setReceiveBufferSize(config.getReceiveBufferSize());
            }
            if (config.getSoTimeout() != null) {
                socket.setSoTimeout(config.getSoTimeout());
            }
            if (config.getSoLinger() != null && config.getSoLinger() > 0) {
                socket.setSoLinger(true, config.getSoLinger());
            }
        }
        catch (Exception e) {
            LOGGER.error("Set socket config failed: `" + e.getMessage() + "`. Socket: `" + socket + "`. Config: `" + config + "`.", (Throwable)e);
            throw new BuildSocketException("Set socket config failed: `" + e.getMessage() + "`. Socket: `" + socket + "`. Config: `" + config + "`.", e);
        }
    }

    public static SocketConfiguration getConfig(Socket socket) throws BuildSocketException {
        try {
            SocketConfiguration config = new SocketConfiguration();
            config.setKeepAlive(socket.getKeepAlive());
            config.setTcpNoDelay(socket.getTcpNoDelay());
            config.setSendBufferSize(socket.getSendBufferSize());
            config.setReceiveBufferSize(socket.getReceiveBufferSize());
            config.setSoTimeout(socket.getSoTimeout());
            config.setSoLinger(socket.getSoLinger());
            return config;
        }
        catch (Exception e) {
            LOGGER.error("Get socket config failed: `" + e.getMessage() + "`. Socket: `" + socket + "`.", (Throwable)e);
            throw new BuildSocketException("Get socket config failed: `" + e.getMessage() + "`. Socket: `" + socket + "`.", e);
        }
    }
}

