/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.packet;

import java.util.ArrayList;
import java.util.List;

public class CapabilitiesFlagsUtil {
    public static final int INDEX_CLIENT_LONG_PASSWORD = 0;
    public static final int INDEX_CLIENT_FOUND_ROWS = 1;
    public static final int INDEX_CLIENT_LONG_FLAG = 2;
    public static final int INDEX_CLIENT_CONNECT_WITH_DB = 3;
    public static final int INDEX_CLIENT_NO_SCHEMA = 4;
    public static final int INDEX_CLIENT_COMPRESS = 5;
    public static final int INDEX_CLIENT_ODBC = 6;
    public static final int INDEX_CLIENT_LOCAL_FILES = 7;
    public static final int INDEX_CLIENT_IGNORE_SPACE = 8;
    public static final int INDEX_CLIENT_PROTOCOL_41 = 9;
    public static final int INDEX_CLIENT_INTERACTIVE = 10;
    public static final int INDEX_CLIENT_SSL = 11;
    public static final int INDEX_CLIENT_IGNORE_SIGPIPE = 12;
    public static final int INDEX_CLIENT_TRANSACTIONS = 13;
    public static final int INDEX_CLIENT_RESERVED = 14;
    public static final int INDEX_CLIENT_RESERVED2 = 15;
    public static final int INDEX_CLIENT_MULTI_STATEMENTS = 16;
    public static final int INDEX_CLIENT_MULTI_RESULTS = 17;
    public static final int INDEX_CLIENT_PS_MULTI_RESULTS = 18;
    public static final int INDEX_CLIENT_PLUGIN_AUTH = 19;
    public static final int INDEX_CLIENT_CONNECT_ATTRS = 20;
    public static final int INDEX_CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA = 21;
    public static final int INDEX_CLIENT_CAN_HANDLE_EXPIRED_PASSWORDS = 22;
    public static final int INDEX_CLIENT_SESSION_TRACK = 23;
    public static final int INDEX_CLIENT_DEPRECATE_EOF = 24;
    public static final int INDEX_CLIENT_OPTIONAL_RESULTSET_METADATA = 25;
    public static final int INDEX_CLIENT_SSL_VERIFY_SERVER_CERT = 30;
    public static final int INDEX_CLIENT_REMEMBER_OPTIONS = 31;

    public static boolean isCapabilityEnabled(long capabilitiesFlags, int capabilityIndex) throws IllegalArgumentException {
        if (capabilityIndex < 0 || capabilityIndex > 31) {
            throw new IllegalArgumentException("Check capability flag failed: `invalid capability index`. `capabilitiesFlags`:`" + capabilitiesFlags + "`. `capabilityIndex`:`" + capabilityIndex + "`.");
        }
        return (capabilitiesFlags & 1L << capabilityIndex) != 0L;
    }

    public static long enableCapability(long capabilitiesFlags, int capabilityIndex) throws IllegalArgumentException {
        if (capabilityIndex < 0 || capabilityIndex > 31) {
            throw new IllegalArgumentException("Enable capability flag failed: `invalid capability index`. `capabilitiesFlags`:`" + capabilitiesFlags + "`. `capabilityIndex`:`" + capabilityIndex + "`.");
        }
        return capabilitiesFlags | 1L << capabilityIndex;
    }

    public static long disableCapability(long capabilitiesFlags, int capabilityIndex) throws IllegalArgumentException {
        if (capabilityIndex < 0 || capabilityIndex > 31) {
            throw new IllegalArgumentException("Disable capability flag failed: `invalid capability index`. `capabilitiesFlags`:`" + capabilitiesFlags + "`. `capabilityIndex`:`" + capabilityIndex + "`.");
        }
        long maskCapability = CapabilitiesFlagsUtil.enableCapability(0L, capabilityIndex) ^ 0xFFFFFFFFFFFFFFFFL;
        return capabilitiesFlags & maskCapability;
    }

    public static String getCapabilityName(int capabilityIndex) throws IllegalArgumentException {
        switch (capabilityIndex) {
            case 0: {
                return "CLIENT_LONG_PASSWORD";
            }
            case 1: {
                return "CLIENT_FOUND_ROWS";
            }
            case 2: {
                return "CLIENT_LONG_FLAG";
            }
            case 3: {
                return "CLIENT_CONNECT_WITH_DB";
            }
            case 4: {
                return "CLIENT_NO_SCHEMA";
            }
            case 5: {
                return "CLIENT_COMPRESS";
            }
            case 6: {
                return "CLIENT_ODBC";
            }
            case 7: {
                return "CLIENT_LOCAL_FILES";
            }
            case 8: {
                return "CLIENT_IGNORE_SPACE";
            }
            case 9: {
                return "CLIENT_PROTOCOL_41";
            }
            case 10: {
                return "CLIENT_INTERACTIVE";
            }
            case 11: {
                return "CLIENT_SSL";
            }
            case 12: {
                return "CLIENT_IGNORE_SIGPIPE";
            }
            case 13: {
                return "CLIENT_TRANSACTIONS";
            }
            case 14: {
                return "CLIENT_RESERVED";
            }
            case 15: {
                return "CLIENT_RESERVED2";
            }
            case 16: {
                return "CLIENT_MULTI_STATEMENTS";
            }
            case 17: {
                return "CLIENT_MULTI_RESULTS";
            }
            case 18: {
                return "CLIENT_PS_MULTI_RESULTS";
            }
            case 19: {
                return "CLIENT_PLUGIN_AUTH";
            }
            case 20: {
                return "CLIENT_CONNECT_ATTRS";
            }
            case 21: {
                return "CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA";
            }
            case 22: {
                return "CLIENT_CAN_HANDLE_EXPIRED_PASSWORDS";
            }
            case 23: {
                return "CLIENT_SESSION_TRACK";
            }
            case 24: {
                return "CLIENT_DEPRECATE_EOF";
            }
            case 25: {
                return "CLIENT_OPTIONAL_RESULTSET_METADATA";
            }
            case 30: {
                return "CLIENT_SSL_VERIFY_SERVER_CERT";
            }
            case 31: {
                return "CLIENT_REMEMBER_OPTIONS";
            }
        }
        throw new IllegalArgumentException("Get capability name failed: `invalid capability index`. `capabilityIndex`:`" + capabilityIndex + "`.");
    }

    public static List<String> getEnabledCapabilitiesNames(long capabilitiesFlags) {
        ArrayList<String> enabledCapabilitiesNames = new ArrayList<String>();
        for (int i = 0; i < 32; ++i) {
            if (i > 25 && i < 30 || !CapabilitiesFlagsUtil.isCapabilityEnabled(capabilitiesFlags, i)) continue;
            enabledCapabilitiesNames.add(CapabilitiesFlagsUtil.getCapabilityName(i));
        }
        return enabledCapabilitiesNames;
    }
}

