/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.packet;

import java.util.ArrayList;
import java.util.List;

public class ColumnDefinitionFlagsUtil {
    public static final int INDEX_NOT_NULL_FLAG = 0;
    public static final int INDEX_PRI_KEY_FLAG = 1;
    public static final int INDEX_UNIQUE_KEY_FLAG = 2;
    public static final int INDEX_MULTIPLE_KEY_FLAG = 3;
    public static final int INDEX_BLOB_FLAG = 4;
    public static final int INDEX_UNSIGNED_FLAG = 5;
    public static final int INDEX_ZEROFILL_FLAG = 6;
    public static final int INDEX_BINARY_FLAG = 7;
    public static final int INDEX_ENUM_FLAG = 8;
    public static final int INDEX_AUTO_INCREMENT_FLAG = 9;
    public static final int INDEX_TIMESTAMP_FLAG = 10;
    public static final int INDEX_SET_FLAG = 11;
    public static final int INDEX_NO_DEFAULT_VALUE_FLAG = 12;
    public static final int INDEX_ON_UPDATE_NOW_FLAG = 13;
    public static final int INDEX_NUM_FLAG = 15;

    public static boolean isColumnDefinitionEnabled(int columnDefinitionFlags, int columnDefinitionIndex) throws IllegalArgumentException {
        if (columnDefinitionIndex < 0 || columnDefinitionIndex > 15) {
            throw new IllegalArgumentException("Check column definition flag failed: `invalid column definition index`. `columnDefinitionFlags`:`" + columnDefinitionFlags + "`. `columnDefinitionIndex`:`" + columnDefinitionIndex + "`.");
        }
        return ((long)columnDefinitionFlags & 1L << columnDefinitionIndex) != 0L;
    }

    public static String getColumnDefinitionName(int columnDefinitionIndex) throws IllegalArgumentException {
        switch (columnDefinitionIndex) {
            case 0: {
                return "NOT_NULL_FLAG";
            }
            case 1: {
                return "PRI_KEY_FLAG";
            }
            case 2: {
                return "UNIQUE_KEY_FLAG";
            }
            case 3: {
                return "MULTIPLE_KEY_FLAG";
            }
            case 4: {
                return "BLOB_FLAG";
            }
            case 5: {
                return "UNSIGNED_FLAG";
            }
            case 6: {
                return "ZEROFILL_FLAG";
            }
            case 7: {
                return "BINARY_FLAG";
            }
            case 8: {
                return "ENUM_FLAG";
            }
            case 9: {
                return "AUTO_INCREMENT_FLAG";
            }
            case 10: {
                return "TIMESTAMP_FLAG";
            }
            case 11: {
                return "SET_FLAG";
            }
            case 12: {
                return "NO_DEFAULT_VALUE_FLAG";
            }
            case 13: {
                return "ON_UPDATE_NOW_FLAG";
            }
            case 15: {
                return "NUM_FLAG";
            }
        }
        throw new IllegalArgumentException("Get column definition flag name failed: `invalid column definition index`. `columnDefinitionIndex`:`" + columnDefinitionIndex + "`.");
    }

    public static List<String> getEnabledColumnDefinitionNames(int columnDefinitionFlags) {
        ArrayList<String> enabledColumnDefinitionNames = new ArrayList<String>();
        for (int i = 0; i < 16; ++i) {
            if (i == 14 || !ColumnDefinitionFlagsUtil.isColumnDefinitionEnabled(columnDefinitionFlags, i)) continue;
            enabledColumnDefinitionNames.add(ColumnDefinitionFlagsUtil.getColumnDefinitionName(i));
        }
        return enabledColumnDefinitionNames;
    }
}

