/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.packet;

import com.heimuheimu.mysql.jdbc.packet.ColumnDefinitionFlagsUtil;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class ColumnTypeMappingUtil {
    public static final int MYSQL_TYPE_TINY = 1;
    public static final int MYSQL_TYPE_SHORT = 2;
    public static final int MYSQL_TYPE_LONG = 3;
    public static final int MYSQL_TYPE_FLOAT = 4;
    public static final int MYSQL_TYPE_DOUBLE = 5;
    public static final int MYSQL_TYPE_TIMESTAMP = 7;
    public static final int MYSQL_TYPE_LONGLONG = 8;
    public static final int MYSQL_TYPE_INT24 = 9;
    public static final int MYSQL_TYPE_DATE = 10;
    public static final int MYSQL_TYPE_TIME = 11;
    public static final int MYSQL_TYPE_DATETIME = 12;
    public static final int MYSQL_TYPE_YEAR = 13;
    public static final int MYSQL_TYPE_BIT = 16;
    public static final int MYSQL_TYPE_NEWDECIMAL = 246;
    public static final int MYSQL_TYPE_BLOB = 252;
    public static final int MYSQL_TYPE_VAR_STRING = 253;
    public static final int MYSQL_TYPE_STRING = 254;
    private static final Map<Integer, String> MYSQL_TYPE_NAME_MAP = new HashMap<Integer, String>();

    public static String getTypeName(int columnType, int columnDefinitionFlags, long maximumColumnLength) {
        if (columnType == 254) {
            if (ColumnDefinitionFlagsUtil.isColumnDefinitionEnabled(columnDefinitionFlags, 8)) {
                return "ENUM";
            }
            if (ColumnDefinitionFlagsUtil.isColumnDefinitionEnabled(columnDefinitionFlags, 11)) {
                return "SET";
            }
            if (ColumnDefinitionFlagsUtil.isColumnDefinitionEnabled(columnDefinitionFlags, 7)) {
                return "BINARY";
            }
            return "CHAR";
        }
        if (columnType == 253) {
            if (ColumnDefinitionFlagsUtil.isColumnDefinitionEnabled(columnDefinitionFlags, 7)) {
                return "VARBINARY";
            }
            return "VARCHAR";
        }
        if (columnType == 252) {
            String blobTypeName;
            String string = blobTypeName = ColumnDefinitionFlagsUtil.isColumnDefinitionEnabled(columnDefinitionFlags, 7) ? "BLOB" : "TEXT";
            String sizeName = maximumColumnLength < 65535L ? "TINY" : (maximumColumnLength < 0xFFFFFFL ? "" : (maximumColumnLength < 0xFFFFFFFFL ? "MEDIUM" : "LONG"));
            return sizeName + blobTypeName;
        }
        if (MYSQL_TYPE_NAME_MAP.containsKey(columnType)) {
            return MYSQL_TYPE_NAME_MAP.get(columnType);
        }
        return "UNKNOWN";
    }

    public static Class<?> getJavaType(int columnType, int columnDefinitionFlags) {
        if (columnType == 1 || columnType == 2 || columnType == 9 || columnType == 3) {
            return Integer.class;
        }
        if (columnType == 8) {
            return Long.class;
        }
        if (columnType == 246) {
            return BigDecimal.class;
        }
        if (columnType == 4 || columnType == 5) {
            return Double.class;
        }
        if (columnType == 16) {
            return Boolean.class;
        }
        if (columnType == 13 || columnType == 10) {
            return Date.class;
        }
        if (columnType == 11) {
            return Time.class;
        }
        if (columnType == 7 || columnType == 12) {
            return Timestamp.class;
        }
        if (ColumnDefinitionFlagsUtil.isColumnDefinitionEnabled(columnDefinitionFlags, 7)) {
            return byte[].class;
        }
        return String.class;
    }

    public static int getJDBCType(int columnType, int columnDefinitionFlags, long maximumColumnLength) {
        String typeName = ColumnTypeMappingUtil.getTypeName(columnType, columnDefinitionFlags, maximumColumnLength);
        if ("TINYINT".equals(typeName)) {
            return -6;
        }
        if ("SMALLINT".equals(typeName)) {
            return 5;
        }
        if ("MEDIUMINT".equals(typeName)) {
            return 4;
        }
        if ("INT".equals(typeName)) {
            return 4;
        }
        if ("BIGINT".equals(typeName)) {
            return -5;
        }
        if ("FLOAT".equals(typeName)) {
            return 6;
        }
        if ("DOUBLE".equals(typeName)) {
            return 8;
        }
        if ("DECIMAL".equals(typeName)) {
            return 3;
        }
        if ("BIT".equals(typeName)) {
            return -7;
        }
        if ("YEAR".equals(typeName) || "DATE".equals(typeName)) {
            return 91;
        }
        if ("TIME".equals(typeName)) {
            return 92;
        }
        if ("TIMESTAMP".equals(typeName) || "DATETIME".equals(typeName)) {
            return 93;
        }
        if ("ENUM".equals(typeName) || "SET".equals(typeName) || "CHAR".equals(typeName)) {
            return 1;
        }
        if ("VARCHAR".equals(typeName) || "TINYTEXT".equals(typeName)) {
            return 12;
        }
        if ("TEXT".equals(typeName) || "MEDIUMTEXT".equals(typeName) || "LONGTEXT".equals(typeName)) {
            return -1;
        }
        if ("BINARY".equals(typeName)) {
            return -2;
        }
        if ("VARBINARY".equals(typeName) || "TINYBLOB".equals(typeName)) {
            return -3;
        }
        if ("BLOB".equals(typeName) || "MEDIUMBLOB".equals(typeName) || "LONGBLOB".equals(typeName)) {
            return -4;
        }
        return 1111;
    }

    static {
        MYSQL_TYPE_NAME_MAP.put(1, "TINYINT");
        MYSQL_TYPE_NAME_MAP.put(2, "SMALLINT");
        MYSQL_TYPE_NAME_MAP.put(9, "MEDIUMINT");
        MYSQL_TYPE_NAME_MAP.put(3, "INT");
        MYSQL_TYPE_NAME_MAP.put(8, "BIGINT");
        MYSQL_TYPE_NAME_MAP.put(4, "FLOAT");
        MYSQL_TYPE_NAME_MAP.put(5, "DOUBLE");
        MYSQL_TYPE_NAME_MAP.put(246, "DECIMAL");
        MYSQL_TYPE_NAME_MAP.put(16, "BIT");
        MYSQL_TYPE_NAME_MAP.put(13, "YEAR");
        MYSQL_TYPE_NAME_MAP.put(10, "DATE");
        MYSQL_TYPE_NAME_MAP.put(11, "TIME");
        MYSQL_TYPE_NAME_MAP.put(7, "TIMESTAMP");
        MYSQL_TYPE_NAME_MAP.put(12, "DATETIME");
        MYSQL_TYPE_NAME_MAP.put(252, "BLOB");
        MYSQL_TYPE_NAME_MAP.put(253, "VAR_STRING");
        MYSQL_TYPE_NAME_MAP.put(254, "STRING");
    }
}

