/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.packet;

import com.heimuheimu.mysql.jdbc.util.BytesUtil;
import java.nio.charset.Charset;
import java.util.Arrays;

public class MysqlPacket {
    private final int sequenceId;
    private final byte[] payload;
    private int position = 0;

    public MysqlPacket(int sequenceId, byte[] payload) {
        this.sequenceId = sequenceId;
        this.payload = payload;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean hasRemaining() {
        return this.position < this.payload.length;
    }

    public byte[] readFixedLengthBytes(int length) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (length < 0) {
            throw new IllegalArgumentException("Read fixed length bytes failed: `invalid length`. `length`:`" + length + "`.");
        }
        if (length == 0) {
            return new byte[0];
        }
        byte[] value = new byte[length];
        System.arraycopy(this.payload, this.position, value, 0, length);
        this.position += length;
        return value;
    }

    public long readFixedLengthInteger(int length) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        long value = BytesUtil.decodeUnsignedInteger(this.payload, this.position, length);
        this.position += length;
        return value;
    }

    public long readLengthEncodedInteger() throws ArrayIndexOutOfBoundsException {
        long magicValue = this.readFixedLengthInteger(1);
        if (magicValue == 252L) {
            return this.readFixedLengthInteger(2);
        }
        if (magicValue == 253L) {
            return this.readFixedLengthInteger(3);
        }
        if (magicValue == 254L) {
            return this.readFixedLengthInteger(8);
        }
        return magicValue == 251L ? -1L : magicValue;
    }

    public String readNullTerminatedString(Charset charset) throws ArrayIndexOutOfBoundsException {
        int length = 0;
        int startPosition = this.position;
        while (this.payload[this.position++] != 0) {
            ++length;
        }
        return new String(this.payload, startPosition, length, charset);
    }

    public String readLengthEncodedString(Charset charset) throws ArrayIndexOutOfBoundsException {
        int length = (int)this.readLengthEncodedInteger();
        return this.readFixedLengthString(length, charset);
    }

    public String readFixedLengthString(int length, Charset charset) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (length < 0) {
            throw new IllegalArgumentException("Read fixed length string failed: `invalid length`. `length`:`" + length + "`.");
        }
        if (length == 0) {
            return "";
        }
        int startPosition = this.position;
        this.position += length;
        return new String(this.payload, startPosition, length, charset);
    }

    public String readRestOfPacketString(Charset charset) {
        if (this.position < this.payload.length) {
            int startPosition = this.position;
            this.position = this.payload.length;
            int length = this.payload.length - startPosition;
            return new String(this.payload, startPosition, length, charset);
        }
        return null;
    }

    public MysqlPacket writeFixedLengthBytes(byte[] src) throws IndexOutOfBoundsException, NullPointerException {
        if (src == null) {
            throw new IllegalArgumentException("Write fixed length bytes failed: `src is null`.");
        }
        if (src.length > 0) {
            System.arraycopy(src, 0, this.payload, this.position, src.length);
            this.position += src.length;
        }
        return this;
    }

    public MysqlPacket writeFixedLengthInteger(int length, long value) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        BytesUtil.encodeUnsignedInteger(this.payload, this.position, length, value);
        this.position += length;
        return this;
    }

    public MysqlPacket writeLengthEncodedInteger(long value) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (value < 251L) {
            BytesUtil.encodeUnsignedInteger(this.payload, this.position++, 1, value);
        } else if (value < 65536L) {
            BytesUtil.encodeUnsignedInteger(this.payload, this.position++, 1, 252L);
            BytesUtil.encodeUnsignedInteger(this.payload, this.position, 2, value);
            this.position += 2;
        } else if (value < 0x1000000L) {
            BytesUtil.encodeUnsignedInteger(this.payload, this.position++, 1, 253L);
            BytesUtil.encodeUnsignedInteger(this.payload, this.position, 3, value);
            this.position += 3;
        } else {
            BytesUtil.encodeUnsignedInteger(this.payload, this.position++, 1, 254L);
            BytesUtil.encodeUnsignedInteger(this.payload, this.position, 8, value);
            this.position += 8;
        }
        return this;
    }

    public MysqlPacket writeNullTerminatedString(byte[] text) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (text == null) {
            throw new IllegalArgumentException("Write null terminated string failed: `text is null`.");
        }
        this.writeFixedLengthBytes(text);
        this.payload[this.position++] = 0;
        return this;
    }

    public MysqlPacket writeLengthEncodedString(byte[] text) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (text == null) {
            throw new IllegalArgumentException("Write length encoded string failed: `text is null`.");
        }
        this.writeLengthEncodedInteger(text.length);
        this.writeFixedLengthBytes(text);
        return this;
    }

    public byte[] buildMysqlPacketBytes() throws IllegalArgumentException {
        if (this.position == 0) {
            throw new IllegalArgumentException("Build mysql packet bytes failed: `payload is empty`.");
        }
        byte[] packetBytes = new byte[4 + this.position];
        BytesUtil.encodeUnsignedInteger(packetBytes, 0, 3, this.position);
        BytesUtil.encodeUnsignedInteger(packetBytes, 3, 1, this.sequenceId);
        System.arraycopy(this.payload, 0, packetBytes, 4, this.position);
        return packetBytes;
    }

    public String toString() {
        return "MysqlPacket{sequenceId=" + this.sequenceId + ", payload=" + Arrays.toString(this.payload) + ", position=" + this.position + '}';
    }

    public static int getBytesLengthForLengthEncodedInteger(long value) {
        if (value < 251L) {
            return 1;
        }
        if (value < 65536L) {
            return 3;
        }
        if (value < 0x1000000L) {
            return 4;
        }
        return 9;
    }
}

