/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.packet;

import com.heimuheimu.mysql.jdbc.facility.parameter.ConstructorParameterChecker;
import com.heimuheimu.mysql.jdbc.facility.parameter.Parameters;
import com.heimuheimu.mysql.jdbc.packet.MysqlPacket;
import com.heimuheimu.mysql.jdbc.util.BytesUtil;
import com.heimuheimu.naivemonitor.facility.MonitoredSocketInputStream;
import com.heimuheimu.naivemonitor.monitor.SocketMonitor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlPacketReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MysqlPacketReader.class);
    private final BufferedInputStream inputStream;

    public MysqlPacketReader(InputStream inputStream, int bufferSize, SocketMonitor socketMonitor) throws IllegalArgumentException {
        ConstructorParameterChecker checker = new ConstructorParameterChecker("MysqlPacketReader", LOGGER);
        checker.addParameter("inputStream", inputStream);
        checker.addParameter("bufferSize", bufferSize);
        checker.addParameter("socketMonitor", socketMonitor);
        checker.check("inputStream", "isNull", Parameters::isNull);
        checker.check("bufferSize", "isEqualOrLessThanZero", Parameters::isEqualOrLessThanZero);
        checker.check("socketMonitor", "isNull", Parameters::isNull);
        this.inputStream = new BufferedInputStream((InputStream)new MonitoredSocketInputStream(inputStream, socketMonitor), bufferSize);
    }

    public MysqlPacket read() throws IOException {
        int readBytes;
        int readBytes2;
        byte[] header = new byte[4];
        for (int headerPos = 0; headerPos < 4; headerPos += readBytes2) {
            readBytes2 = this.inputStream.read(header, headerPos, 4 - headerPos);
            if (readBytes2 >= 0) {
                continue;
            }
            return null;
        }
        int payloadLength = (int)BytesUtil.decodeUnsignedInteger(header, 0, 3);
        int sequenceId = (int)BytesUtil.decodeUnsignedInteger(header, 3, 1);
        byte[] payload = new byte[payloadLength];
        for (int payloadPos = 0; payloadPos < payloadLength; payloadPos += readBytes) {
            readBytes = this.inputStream.read(payload, payloadPos, payloadLength - payloadPos);
            if (readBytes >= 0) {
                continue;
            }
            return null;
        }
        return new MysqlPacket(sequenceId, payload);
    }
}

